/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.view;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model.VisualizerExecutionState;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.view.IMulticoreVisualizerConstants;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.view.MulticoreVisualizerCPU;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.view.MulticoreVisualizerGraphicObject;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.view.MulticoreVisualizerLoadMeter;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.view.MulticoreVisualizerThread;
import org.eclipse.cdt.visualizer.ui.util.Colors;
import org.eclipse.cdt.visualizer.ui.util.GUIUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;

public class MulticoreVisualizerCore
extends MulticoreVisualizerGraphicObject {
    protected MulticoreVisualizerCPU m_cpu = null;
    protected int m_id;
    protected ArrayList<MulticoreVisualizerThread> m_threads;
    protected MulticoreVisualizerLoadMeter m_loadMeter;

    public MulticoreVisualizerCore(MulticoreVisualizerCPU cpu, int id) {
        this.m_cpu = cpu;
        if (this.m_cpu != null) {
            this.m_cpu.addCore(this);
        }
        this.m_id = id;
        this.m_threads = new ArrayList();
        this.m_loadMeter = new MulticoreVisualizerLoadMeter(null, null);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.m_threads != null) {
            this.m_threads.clear();
            this.m_threads = null;
        }
        if (this.m_loadMeter != null) {
            this.m_loadMeter.dispose();
        }
    }

    public MulticoreVisualizerCPU getCPU() {
        return this.m_cpu;
    }

    public int getID() {
        return this.m_id;
    }

    public void addThread(MulticoreVisualizerThread thread) {
        this.m_threads.add(thread);
    }

    public void removeThread(MulticoreVisualizerThread thread) {
        this.m_threads.remove((Object)thread);
    }

    public void removeAllThreads() {
        this.m_threads.clear();
    }

    public List<MulticoreVisualizerThread> getThreads() {
        return this.m_threads;
    }

    public void setLoadMeter(MulticoreVisualizerLoadMeter meter) {
        this.m_loadMeter = meter;
    }

    public MulticoreVisualizerLoadMeter getLoadMeter() {
        return this.m_loadMeter;
    }

    protected VisualizerExecutionState getCoreState() {
        VisualizerExecutionState state = VisualizerExecutionState.RUNNING;
        for (MulticoreVisualizerThread thread : this.m_threads) {
            switch (thread.getState()) {
                case CRASHED: {
                    return VisualizerExecutionState.CRASHED;
                }
                case SUSPENDED: {
                    state = VisualizerExecutionState.SUSPENDED;
                }
            }
        }
        return state;
    }

    protected Color getCoreStateColor(boolean foreground) {
        VisualizerExecutionState state = this.getCoreState();
        switch (state) {
            case RUNNING: {
                if (foreground) {
                    return IMulticoreVisualizerConstants.COLOR_RUNNING_CORE_FG;
                }
                return IMulticoreVisualizerConstants.COLOR_RUNNING_CORE_BG;
            }
            case SUSPENDED: {
                if (foreground) {
                    return IMulticoreVisualizerConstants.COLOR_SUSPENDED_CORE_FG;
                }
                return IMulticoreVisualizerConstants.COLOR_SUSPENDED_CORE_BG;
            }
            case CRASHED: {
                if (foreground) {
                    return IMulticoreVisualizerConstants.COLOR_CRASHED_CORE_FG;
                }
                return IMulticoreVisualizerConstants.COLOR_CRASHED_CORE_BG;
            }
        }
        assert (false);
        return Colors.BLACK;
    }

    @Override
    public void paintContent(GC gc) {
        Color bg = this.getCoreStateColor(false);
        gc.setBackground(bg);
        this.m_loadMeter.setParentBgColor(bg);
        if (this.m_selected) {
            gc.setForeground(IMulticoreVisualizerConstants.COLOR_SELECTED);
        } else {
            gc.setForeground(this.getCoreStateColor(true));
        }
        gc.fillRectangle(this.m_bounds);
        gc.drawRectangle(this.m_bounds);
        if (this.m_bounds.height > 16) {
            int text_indent = 3;
            int tx = this.m_bounds.x + this.m_bounds.width - text_indent;
            int ty = this.m_bounds.y + text_indent;
            gc.setForeground(this.getCoreStateColor(true));
            GUIUtils.drawTextAligned((GC)gc, (String)Integer.toString(this.m_id), (int)tx, (int)ty, (boolean)false, (boolean)true);
        }
    }
}

