/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.utils;

import java.util.ArrayList;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.ImmediateCountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateDataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model.VisualizerExecutionState;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.utils.DSFDebugModelListener;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.utils.DSFSessionState;
import org.eclipse.cdt.dsf.gdb.service.IGDBHardwareAndOS;
import org.eclipse.cdt.dsf.gdb.service.IGDBHardwareAndOS2;
import org.eclipse.cdt.dsf.gdb.service.IGDBProcesses;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.visualizer.ui.util.Timer;

public class DSFDebugModel {
    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    public static void getCPUs(DSFSessionState sessionState, final DSFDebugModelListener listener, final Object arg) {
        ICommandControlService controlService = sessionState.getService(ICommandControlService.class);
        IGDBHardwareAndOS hwService = sessionState.getService(IGDBHardwareAndOS.class);
        if (controlService == null || hwService == null) {
            listener.getCPUsDone(null, arg);
            return;
        }
        IGDBHardwareAndOS.IHardwareTargetDMContext contextToUse = (IGDBHardwareAndOS.IHardwareTargetDMContext)DMContexts.getAncestorOfType((IDMContext)controlService.getContext(), IGDBHardwareAndOS.IHardwareTargetDMContext.class);
        hwService.getCPUs(contextToUse, (DataRequestMonitor)new ImmediateDataRequestMonitor<IGDBHardwareAndOS.ICPUDMContext[]>(){

            protected void handleCompleted() {
                IGDBHardwareAndOS.ICPUDMContext[] cpuContexts = (IGDBHardwareAndOS.ICPUDMContext[])this.getData();
                if (!this.isSuccess()) {
                    cpuContexts = null;
                }
                listener.getCPUsDone(cpuContexts, arg);
            }
        });
    }

    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    public static void getLoad(DSFSessionState sessionState, final IDMContext context, final DSFDebugModelListener listener, final Object arg) {
        IGDBHardwareAndOS2 hwService = sessionState.getService(IGDBHardwareAndOS2.class);
        if (hwService == null) {
            listener.getLoadDone(context, null, arg);
            return;
        }
        hwService.getLoadInfo(context, (DataRequestMonitor)new ImmediateDataRequestMonitor<IGDBHardwareAndOS2.ILoadInfo>(){

            protected void handleCompleted() {
                listener.getLoadDone(context, (IGDBHardwareAndOS2.ILoadInfo)this.getData(), arg);
            }
        });
    }

    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    public static void getCores(DSFSessionState sessionState, DSFDebugModelListener listener, Object arg) {
        DSFDebugModel.getCores(sessionState, null, listener, arg);
    }

    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    public static void getCores(DSFSessionState sessionState, final IGDBHardwareAndOS.ICPUDMContext cpuContext, final DSFDebugModelListener listener, final Object arg) {
        IGDBHardwareAndOS hwService = sessionState.getService(IGDBHardwareAndOS.class);
        if (hwService == null) {
            listener.getCoresDone(cpuContext, null, arg);
            return;
        }
        IGDBHardwareAndOS.ICPUDMContext targetContextToUse = cpuContext;
        if (targetContextToUse == null) {
            ICommandControlService controlService = sessionState.getService(ICommandControlService.class);
            targetContextToUse = DMContexts.getAncestorOfType((IDMContext)controlService.getContext(), IGDBHardwareAndOS.IHardwareTargetDMContext.class);
        }
        hwService.getCores((IDMContext)targetContextToUse, (DataRequestMonitor)new ImmediateDataRequestMonitor<IGDBHardwareAndOS.ICoreDMContext[]>(){

            protected void handleCompleted() {
                IGDBHardwareAndOS.ICoreDMContext[] coreContexts = (IGDBHardwareAndOS.ICoreDMContext[])this.getData();
                if (!this.isSuccess() || coreContexts == null || coreContexts.length < 1) {
                    listener.getCoresDone(cpuContext, null, arg);
                    return;
                }
                IGDBHardwareAndOS.ICPUDMContext cpuContextToUse = cpuContext;
                if (cpuContextToUse == null) {
                    cpuContextToUse = (IGDBHardwareAndOS.ICPUDMContext)DMContexts.getAncestorOfType((IDMContext)coreContexts[0], IGDBHardwareAndOS.ICPUDMContext.class);
                }
                listener.getCoresDone(cpuContextToUse, coreContexts, arg);
            }
        });
    }

    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    public static void getThreads(DSFSessionState sessionState, final IGDBHardwareAndOS.ICPUDMContext cpuContext, final IGDBHardwareAndOS.ICoreDMContext coreContext, final DSFDebugModelListener listener, final Object arg) {
        final IProcesses procService = sessionState.getService(IProcesses.class);
        ICommandControlService.ICommandControlDMContext controlContext = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)coreContext, ICommandControlService.ICommandControlDMContext.class);
        if (procService == null || controlContext == null) {
            listener.getThreadsDone(cpuContext, coreContext, null, arg);
            return;
        }
        procService.getProcessesBeingDebugged((IDMContext)controlContext, (DataRequestMonitor)new ImmediateDataRequestMonitor<IDMContext[]>(){

            protected void handleCompleted() {
                IDMContext[] processContexts = (IDMContext[])this.getData();
                if (!this.isSuccess() || processContexts == null || processContexts.length < 1) {
                    listener.getThreadsDone(cpuContext, coreContext, null, arg);
                    return;
                }
                final ArrayList threadContextsList = new ArrayList();
                final ImmediateCountingRequestMonitor crm1 = new ImmediateCountingRequestMonitor((RequestMonitor)new ImmediateRequestMonitor(){

                    protected void handleCompleted() {
                        IDMContext[] threadContexts = threadContextsList.toArray(new IDMContext[threadContextsList.size()]);
                        listener.getThreadsDone(cpuContext, coreContext, threadContexts, arg);
                    }
                });
                crm1.setDoneCount(processContexts.length);
                IDMContext[] iDMContextArray = processContexts;
                int n = processContexts.length;
                int n2 = 0;
                while (n2 < n) {
                    IDMContext processContext = iDMContextArray[n2];
                    IRunControl.IContainerDMContext containerContext = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)processContext, IRunControl.IContainerDMContext.class);
                    procService.getProcessesBeingDebugged((IDMContext)containerContext, (DataRequestMonitor)new ImmediateDataRequestMonitor<IDMContext[]>((RequestMonitor)crm1){

                        protected void handleCompleted() {
                            IDMContext[] threadContexts = (IDMContext[])this.getData();
                            if (!this.isSuccess() || threadContexts == null || threadContexts.length < 1) {
                                crm1.done();
                                return;
                            }
                            final ImmediateCountingRequestMonitor crm2 = new ImmediateCountingRequestMonitor((RequestMonitor)crm1);
                            crm2.setDoneCount(threadContexts.length);
                            IDMContext[] iDMContextArray = threadContexts;
                            int n = threadContexts.length;
                            int n2 = 0;
                            while (n2 < n) {
                                final IDMContext threadContext = iDMContextArray[n2];
                                IProcesses.IThreadDMContext threadContext2 = (IProcesses.IThreadDMContext)DMContexts.getAncestorOfType((IDMContext)threadContext, IProcesses.IThreadDMContext.class);
                                procService.getExecutionData(threadContext2, (DataRequestMonitor)new ImmediateDataRequestMonitor<IProcesses.IThreadDMData>((RequestMonitor)crm2){

                                    protected void handleCompleted() {
                                        String[] cores;
                                        IProcesses.IThreadDMData data = (IProcesses.IThreadDMData)this.getData();
                                        if (data != null && data instanceof IGDBProcesses.IGdbThreadDMData && (cores = ((IGDBProcesses.IGdbThreadDMData)data).getCores()) != null && cores.length == 1 && coreContext.getId().equals(cores[0])) {
                                            threadContextsList.add(threadContext);
                                        }
                                        crm2.done();
                                    }
                                });
                                ++n2;
                            }
                        }
                    });
                    ++n2;
                }
            }
        });
    }

    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    public static void getThreadData(DSFSessionState sessionState, final IGDBHardwareAndOS.ICPUDMContext cpuContext, final IGDBHardwareAndOS.ICoreDMContext coreContext, final IMIExecutionDMContext execContext, final DSFDebugModelListener listener, final Object arg) {
        IProcesses procService = sessionState.getService(IProcesses.class);
        if (procService == null) {
            listener.getThreadDataDone(cpuContext, coreContext, execContext, null, arg);
            return;
        }
        IProcesses.IThreadDMContext threadContext = (IProcesses.IThreadDMContext)DMContexts.getAncestorOfType((IDMContext)execContext, IProcesses.IThreadDMContext.class);
        procService.getExecutionData(threadContext, (DataRequestMonitor)new ImmediateDataRequestMonitor<IProcesses.IThreadDMData>(){

            protected void handleCompleted() {
                IProcesses.IThreadDMData threadData = this.isSuccess() ? (IProcesses.IThreadDMData)this.getData() : null;
                listener.getThreadDataDone(cpuContext, coreContext, execContext, threadData, arg);
            }
        });
    }

    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    public static void getThreadExecutionState(DSFSessionState sessionState, final IGDBHardwareAndOS.ICPUDMContext cpuContext, final IGDBHardwareAndOS.ICoreDMContext coreContext, final IMIExecutionDMContext execContext, final IProcesses.IThreadDMData threadData, final DSFDebugModelListener listener, final Object arg) {
        IRunControl runControl = sessionState.getService(IRunControl.class);
        if (runControl == null) {
            listener.getThreadExecutionStateDone(cpuContext, coreContext, execContext, threadData, null, arg);
            return;
        }
        if (!runControl.isSuspended((IRunControl.IExecutionDMContext)execContext)) {
            listener.getThreadExecutionStateDone(cpuContext, coreContext, execContext, threadData, VisualizerExecutionState.RUNNING, arg);
        } else {
            runControl.getExecutionData((IRunControl.IExecutionDMContext)execContext, (DataRequestMonitor)new ImmediateDataRequestMonitor<IRunControl.IExecutionDMData>(){

                protected void handleCompleted() {
                    String details;
                    IRunControl.IExecutionDMData executionData = (IRunControl.IExecutionDMData)this.getData();
                    VisualizerExecutionState state = VisualizerExecutionState.SUSPENDED;
                    if (this.isSuccess() && executionData != null && executionData.getStateChangeReason() == IRunControl.StateChangeReason.SIGNAL && executionData instanceof IRunControl.IExecutionDMData2 && (details = ((IRunControl.IExecutionDMData2)executionData).getDetails()) != null && DSFDebugModel.isCrashSignal(details)) {
                        state = VisualizerExecutionState.CRASHED;
                    }
                    listener.getThreadExecutionStateDone(cpuContext, coreContext, execContext, threadData, state, arg);
                }
            });
        }
    }

    public static boolean isCrashSignal(String signalInfo) {
        return signalInfo.startsWith("SIGHUP") || signalInfo.startsWith("SIGILL") || signalInfo.startsWith("SIGABRT") || signalInfo.startsWith("SIGBUS") || signalInfo.startsWith("SIGSEGV");
    }

    public static Timer getLoadTimer(final DSFSessionState sessionState, int timeout, final DSFDebugModelListener listener) {
        Timer t = new Timer(timeout){

            public void run() {
                DsfExecutor executor;
                DsfSession session;
                if (sessionState != null && (session = DsfSession.getSession((String)sessionState.getSessionID())) != null && (executor = session.getExecutor()) != null) {
                    executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            listener.updateLoads();
                        }
                    });
                }
            }
        };
        return t;
    }
}

