/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig2;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.List;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector2;
import org.eclipse.cdt.make.core.scannerconfig.ScannerInfoTypes;
import org.eclipse.cdt.make.internal.core.scannerconfig.ScannerConfigUtil;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.CCommandDSC;
import org.eclipse.cdt.make.internal.core.scannerconfig2.DefaultRunSIProvider;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class SCDMakefileGenerator
extends DefaultRunSIProvider {
    private static final String ENDL = System.getProperty("line.separator");
    private static final String DENDL = String.valueOf(ENDL) + ENDL;
    private String fMakeCommand = "-f ${project_name}_scd.mk ";

    @Override
    protected boolean initialize() {
        String args = this.buildInfo.getProviderRunArguments(this.providerId);
        if (args == null) {
            args = " -E -P -v -dD ";
        } else {
            int nPos = args.indexOf(124);
            if (nPos > 0) {
                this.fMakeCommand = args.substring(0, nPos);
                args = args.substring(nPos + 1);
            }
        }
        this.fCompileCommand = new Path(this.buildInfo.getProviderRunCommand(this.providerId));
        args = this.substituteDynamicVariables(args);
        this.fCompileArguments = ScannerConfigUtil.tokenizeStringWithQuotes(args, "\"");
        this.fWorkingDirectory = MakeCorePlugin.getWorkingDirectory();
        this.fMakeCommand = this.substituteDynamicVariables(this.fMakeCommand);
        return this.generateMakefile(this.resource.getProject().getName());
    }

    private boolean generateMakefile(String projectName) {
        IScannerInfoCollector2 collector2;
        List commands;
        boolean rc = false;
        if (this.collector instanceof IScannerInfoCollector2 && (commands = (collector2 = (IScannerInfoCollector2)this.collector).getCollectedScannerInfo(this.resource.getProject(), ScannerInfoTypes.UNDISCOVERED_COMPILER_COMMAND)) != null && commands.size() > 0) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("# This is a generated file. Please do not edit.");
            buffer.append(DENDL);
            buffer.append(".PHONY: all");
            buffer.append(DENDL);
            buffer.append("COMMANDS := ");
            for (CCommandDSC cmd : commands) {
                buffer.append("\t\\" + ENDL + "\t    scd_cmd_");
                buffer.append(cmd.getCommandId());
            }
            buffer.append(DENDL);
            buffer.append("all: $(COMMANDS)");
            buffer.append(DENDL);
            for (CCommandDSC cmd : commands) {
                buffer.append("scd_cmd_");
                buffer.append(cmd.getCommandId());
                buffer.append(':');
                buffer.append(ENDL);
                buffer.append("\t@echo begin generating scanner info for $@" + ENDL + "\t");
                buffer.append(cmd.getSCDRunnableCommand(true, true));
                String[] stringArray = this.prepareArguments(this.buildInfo.isUseDefaultProviderCommand(this.providerId));
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String arg = stringArray[n2];
                    buffer.append(' ');
                    buffer.append(arg);
                    ++n2;
                }
                buffer.append(' ');
                buffer.append(cmd.appliesToCPPFileType() ? "specs.cpp" : "specs.c");
                buffer.append(ENDL);
                buffer.append("\t@echo end generating scanner info for $@");
                buffer.append(DENDL);
            }
            File makefile = new File(this.fWorkingDirectory.toFile(), this.getMakeFileName(projectName));
            try {
                PrintStream ps = new PrintStream(new FileOutputStream(makefile));
                ps.println(buffer.toString());
                ps.close();
                rc = true;
            }
            catch (FileNotFoundException e) {
                MakeCorePlugin.log(e);
            }
        }
        return rc;
    }

    private String getMakeFileName(String projectName) {
        String[] makeArgs = ScannerConfigUtil.tokenizeStringWithQuotes(this.fMakeCommand, "\"");
        boolean found = false;
        String[] stringArray = makeArgs;
        int n = makeArgs.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (found) {
                return arg;
            }
            if (arg.equals("-f")) {
                found = true;
            }
            ++n2;
        }
        return String.valueOf(projectName) + "_scd.mk";
    }

    protected String substituteDynamicVariables(String in) {
        String string = in;
        string = string.replaceAll("\\$\\{project_name\\}", this.resource.getProject().getName());
        string = string.replaceAll("\\$\\{plugin_state_location\\}", MakeCorePlugin.getWorkingDirectory().toString());
        string = string.replaceAll("\\$\\{specs_file\\}", "specs.c");
        return string;
    }

    @Override
    protected String[] getCommandLineOptions() {
        return ScannerConfigUtil.tokenizeStringWithQuotes(this.fMakeCommand, "\"");
    }

    @Override
    protected IPath getCommandToLaunch() {
        return new Path("make");
    }
}

