/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.dom.ast.IASTCompletionContext;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.qt.core.QtKeywords;

public class QtFunctionCallUtil {
    private static final Pattern SignalRegex = Pattern.compile("^\\s*SIGNAL.*");
    private static final Pattern MethodRegex = Pattern.compile("^\\s*(?:SIGNAL|SLOT).*");

    public static boolean isQObjectFunctionCall(IASTCompletionContext astContext, boolean isPrefix, IASTName name) {
        IBinding[] funcBindings;
        if (name == null) {
            return false;
        }
        IBinding[] iBindingArray = funcBindings = astContext.findBindings(name.getLastName(), isPrefix);
        int n = funcBindings.length;
        int n2 = 0;
        while (n2 < n) {
            IBinding funcBinding = iBindingArray[n2];
            if (QtKeywords.is_QObject_connect(funcBinding) || QtKeywords.is_QObject_disconnect(funcBinding)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static IASTNode getTypeNode(IASTFunctionCallExpression call, IASTInitializerClause[] args, int argIndex) {
        int sigExpIndex = QtFunctionCallUtil.getExpansionArgIndex(args, 0, SignalRegex);
        if (argIndex == sigExpIndex) {
            return QtFunctionCallUtil.getSignalTargetNode(sigExpIndex, call, args);
        }
        int methodExpIndex = QtFunctionCallUtil.getExpansionArgIndex(args, sigExpIndex + 1, MethodRegex);
        if (argIndex == methodExpIndex) {
            return QtFunctionCallUtil.getMethodTargetNode(methodExpIndex, sigExpIndex, call, args);
        }
        return null;
    }

    private static IASTNode getSignalTargetNode(int sigExpIndex, IASTFunctionCallExpression call, IASTInitializerClause[] args) {
        return sigExpIndex == 0 ? call : args[sigExpIndex - 1];
    }

    private static IASTNode getMethodTargetNode(int methodExpIndex, int sigExpIndex, IASTFunctionCallExpression call, IASTInitializerClause[] args) {
        return methodExpIndex == sigExpIndex + 1 ? call : args[methodExpIndex - 1];
    }

    private static int getExpansionArgIndex(IASTInitializerClause[] args, int begin, Pattern macroNameRegex) {
        int i = begin;
        while (i < args.length) {
            IASTInitializerClause arg = args[i];
            String raw = arg.getRawSignature();
            Matcher m = macroNameRegex.matcher(raw);
            if (m.matches()) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

