/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core;

import java.util.regex.Matcher;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.internal.qt.core.ASTUtil;
import org.eclipse.cdt.internal.qt.core.QtSignalSlotReferenceName;

public class QtSignalSlotReference {
    public final IASTNode parent;
    public final IASTNode node;
    public final Type type;
    public final String signature;
    public final int offset;
    public final int length;

    private QtSignalSlotReference(IASTNode parent, IASTNode node, Type type, String signature, int offset, int length) {
        this.parent = parent;
        this.node = node;
        this.type = type;
        this.signature = signature;
        this.offset = offset;
        this.length = length;
    }

    public IASTName createName(IBinding binding) {
        return new QtSignalSlotReferenceName(this.parent, this.node, this.signature, this.offset, this.length, binding);
    }

    public static QtSignalSlotReference parse(IASTNode parent, IASTNode arg) {
        Type type;
        String raw = arg.getRawSignature();
        Matcher m = ASTUtil.Regex_SignalSlotExpansion.matcher(raw);
        if (!m.matches()) {
            return null;
        }
        String macroName = m.group(1);
        if ("SIGNAL".equals(macroName)) {
            type = Type.Signal;
        } else if ("SLOT".equals(macroName)) {
            type = Type.Slot;
        } else {
            return null;
        }
        String expansionArgs = m.group(2);
        int expansionOffset = m.start(2);
        int expansionLength = m.end(2) - expansionOffset;
        return new QtSignalSlotReference(parent, arg, type, expansionArgs, expansionOffset, expansionLength);
    }

    public static enum Type {
        Signal("sender", "SIGNAL", "signal"),
        Slot("receiver", "SLOT", "slot");

        public final String roleName;
        public final String macroName;
        public final String paramName;

        public boolean matches(Type other) {
            if (other == null) {
                return false;
            }
            return this == Signal ? other == Signal : true;
        }

        private Type(String roleName, String macroName, String paramName) {
            this.roleName = roleName;
            this.macroName = macroName;
            this.paramName = paramName;
        }
    }
}

