/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core.index;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.cdt.internal.qt.core.index.QMakeParser;
import org.eclipse.cdt.internal.qt.core.index.QMakeVersion;
import org.eclipse.cdt.qt.core.QtPlugin;
import org.eclipse.cdt.qt.core.index.IQMakeInfo;
import org.eclipse.cdt.qt.core.index.IQtVersion;
import org.eclipse.cdt.utils.spawner.ProcessFactory;

public final class QMakeInfo
implements IQMakeInfo {
    public static final Pattern PATTERN_QUERY_LINE = Pattern.compile("^(\\w+):(.*)$");
    public static final Pattern PATTERN_EVAL_LINE = Pattern.compile("^([a-zA-Z0-9_\\.]+)\\s*=\\s*(.*)$");
    public static final IQMakeInfo INVALID = new QMakeInfo(false, null, Collections.<String>emptyList(), Collections.<String>emptyList(), Collections.<String>emptyList(), Collections.<String>emptyList(), Collections.<String>emptyList(), Collections.<String>emptyList(), Collections.<String>emptyList(), Collections.<String>emptyList());
    private final boolean valid;
    private final IQtVersion qtVersion;
    private final List<String> involvedQMakeFiles;
    private final List<String> qtImportPath;
    private final List<String> qtQmlPath;
    private final List<String> includePath;
    private final List<String> defines;
    private final List<String> sourceFiles;
    private final List<String> headerFiles;
    private final List<String> otherFiles;

    private QMakeInfo(boolean valid, IQtVersion qtVersion, List<String> involvedQMakeFiles, List<String> qtImportPath, List<String> qtQmlPath, List<String> includePath, List<String> defines, List<String> sourceFiles, List<String> headerFiles, List<String> otherFiles) {
        this.valid = valid;
        this.qtVersion = qtVersion;
        this.involvedQMakeFiles = Collections.unmodifiableList(involvedQMakeFiles);
        this.qtImportPath = Collections.unmodifiableList(qtImportPath);
        this.qtQmlPath = Collections.unmodifiableList(qtQmlPath);
        this.includePath = Collections.unmodifiableList(includePath);
        this.defines = Collections.unmodifiableList(defines);
        this.sourceFiles = Collections.unmodifiableList(sourceFiles);
        this.headerFiles = Collections.unmodifiableList(headerFiles);
        this.otherFiles = Collections.unmodifiableList(otherFiles);
    }

    public static IQMakeInfo create(File projectFile, File qmake, String[] extraEnv) {
        return QMakeInfo.create(projectFile.getAbsolutePath(), qmake.getAbsolutePath(), extraEnv);
    }

    public static IQMakeInfo create(String proPath, String qmakePath, String[] extraEnv) {
        if (proPath == null || qmakePath == null) {
            return INVALID;
        }
        Map<String, String> qmake1 = QMakeInfo.exec(PATTERN_QUERY_LINE, extraEnv, qmakePath, "-query");
        if (qmake1 == null) {
            return INVALID;
        }
        QMakeVersion version = QMakeVersion.create(qmake1.get("QMAKE_VERSION"));
        Map<String, String> qmake2 = version != null && version.getMajor() >= 3 ? QMakeInfo.exec(PATTERN_EVAL_LINE, extraEnv, qmakePath, "-E", proPath) : Collections.emptyMap();
        QMakeVersion qtVersion = QMakeVersion.create(qmake1.get("QT_VERSION"));
        List<String> qtImportPaths = QMakeParser.singleValue(qmake1, "QT_INSTALL_IMPORTS");
        List<String> qtQmlPaths = QMakeParser.singleValue(qmake1, "QT_INSTALL_QML");
        List<String> involvedQMakeFiles = QMakeParser.qmake3DecodeValueList(qmake2, "QMAKE_INTERNAL_INCLUDED_FILES");
        List<String> includePath = QMakeParser.qmake3DecodeValueList(qmake2, "INCLUDEPATH");
        List<String> defines = QMakeParser.qmake3DecodeValueList(qmake2, "DEFINES");
        List<String> sourceFiles = QMakeParser.qmake3DecodeValueList(qmake2, "SOURCES");
        List<String> headerFiles = QMakeParser.qmake3DecodeValueList(qmake2, "HEADERS");
        List<String> otherFiles = QMakeParser.qmake3DecodeValueList(qmake2, "HEADERS");
        List<String> qmlImportPath = QMakeParser.qmake3DecodeValueList(qmake2, "QML_IMPORT_PATH");
        ArrayList<String> realQtImportPaths = new ArrayList<String>(qtImportPaths);
        realQtImportPaths.addAll(qmlImportPath);
        ArrayList<String> realQtQmlPaths = new ArrayList<String>(qtQmlPaths);
        realQtQmlPaths.addAll(qmlImportPath);
        return new QMakeInfo(true, qtVersion, involvedQMakeFiles, realQtImportPaths, realQtQmlPaths, includePath, defines, sourceFiles, headerFiles, otherFiles);
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public IQtVersion getQtVersion() {
        return this.qtVersion;
    }

    @Override
    public List<String> getInvolvedQMakeFiles() {
        return this.involvedQMakeFiles;
    }

    @Override
    public List<String> getQtImportPath() {
        return this.qtImportPath;
    }

    @Override
    public List<String> getQtQmlPath() {
        return this.qtQmlPath;
    }

    @Override
    public List<String> getIncludePath() {
        return this.includePath;
    }

    @Override
    public List<String> getDefines() {
        return this.defines;
    }

    @Override
    public List<String> getSourceFiles() {
        return this.sourceFiles;
    }

    @Override
    public List<String> getHeaderFiles() {
        return this.headerFiles;
    }

    @Override
    public List<String> getOtherFiles() {
        return this.otherFiles;
    }

    /*
     * Loose catch block
     */
    private static Map<String, String> exec(Pattern regex, String[] extraEnv, String ... command) {
        Map<String, String> map;
        Process process;
        BufferedReader reader;
        block15: {
            if (command.length < 1 || !new File(command[0]).exists()) {
                QtPlugin.log("qmake: cannot run command: " + (command.length > 0 ? command[0] : ""));
                return null;
            }
            reader = null;
            process = null;
            process = extraEnv != null && extraEnv.length > 0 ? ProcessFactory.getFactory().exec(command, extraEnv) : ProcessFactory.getFactory().exec(command);
            reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            map = QMakeParser.parse(regex, reader);
            if (reader == null) break block15;
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        if (process != null) {
            process.destroy();
        }
        return map;
        catch (IOException e) {
            block16: {
                try {
                    QtPlugin.log(e);
                    if (reader == null) break block16;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (process != null) {
                        process.destroy();
                    }
                    throw throwable;
                }
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            if (process != null) {
                process.destroy();
            }
            return null;
        }
    }
}

