/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core.index;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.qt.core.QtPlugin;

public final class QMakeParser {
    public static final String KEY_QMAKE_VERSION = "QMAKE_VERSION";
    public static final String KEY_QT_VERSION = "QT_VERSION";
    public static final String KEY_QT_INSTALL_IMPORTS = "QT_INSTALL_IMPORTS";
    public static final String KEY_QT_INSTALL_QML = "QT_INSTALL_QML";
    public static final String KEY_QMAKE_INTERNAL_INCLUDED_FILES = "QMAKE_INTERNAL_INCLUDED_FILES";
    public static final String KEY_SOURCES = "SOURCES";
    public static final String KEY_HEADERS = "HEADERS";
    public static final String KEY_INCLUDEPATH = "INCLUDEPATH";
    public static final String KEY_DEFINES = "DEFINES";
    public static final String KEY_QML_IMPORT_PATH = "QML_IMPORT_PATH";

    public static Map<String, String> parse(Pattern regex, BufferedReader reader) throws IOException {
        String line;
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        while ((line = reader.readLine()) != null) {
            String value;
            Matcher m = regex.matcher(line);
            if (!m.matches() || m.groupCount() != 2) {
                QtPlugin.log("qmake: cannot decode query line '" + line + '\'');
                continue;
            }
            String key = m.group(1);
            String oldValue = result.put(key, value = m.group(2));
            if (oldValue == null) continue;
            QtPlugin.log("qmake: duplicate keys in query info '" + line + "' was '" + oldValue + '\'');
        }
        return result;
    }

    public static List<String> singleValue(Map<String, String> map, String key) {
        String value = map.get(key);
        return value == null ? Collections.emptyList() : Collections.singletonList(value);
    }

    public static List<String> qmake3DecodeValueList(Map<String, String> map, String key) {
        String value = map.get(key);
        if (value == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String item : QMakeParser.qmake3SplitValueList(value)) {
            result.add(QMakeParser.qmake3DecodeValue(item));
        }
        return result;
    }

    public static String qmake3DecodeValue(String value) {
        int length = value.length();
        if (length >= 2 && value.charAt(0) == '\"' && value.charAt(length - 1) == '\"') {
            value = value.substring(1, length - 1);
            length = value.length();
        }
        StringBuilder sb = new StringBuilder(length);
        int i = 0;
        while (i < length) {
            block14: {
                char c;
                block13: {
                    c = value.charAt(i);
                    if (c != '\\') break block13;
                    if (++i >= length) break block14;
                    char next = value.charAt(i);
                    switch (next) {
                        case 'r': {
                            sb.append('\r');
                            break;
                        }
                        case 'n': {
                            sb.append('\n');
                            break;
                        }
                        case 't': {
                            sb.append('\t');
                            break;
                        }
                        case '\"': 
                        case '\'': 
                        case '\\': {
                            sb.append(next);
                            break;
                        }
                        case 'x': {
                            if ((i += 2) >= length) break block14;
                            char first = value.charAt(i - 1);
                            char second = value.charAt(i);
                            if (first < '0' || first > '9' || second < '0' || second > '9') break block14;
                            sb.append((char)((first - 48) * 16 + (second - 48)));
                        }
                        default: {
                            break;
                        }
                        {
                            break block14;
                        }
                    }
                    break block14;
                }
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    private static List<String> qmake3SplitValueList(String value) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        char quote = '\u0000';
        boolean hadWord = false;
        int length = value.length();
        int i = 0;
        while (i < length) {
            block10: {
                char c;
                block9: {
                    c = value.charAt(i);
                    if (quote != c) break block9;
                    quote = '\u0000';
                    hadWord = true;
                    sb.append(c);
                    break block10;
                }
                switch (c) {
                    case '\"': 
                    case '\'': {
                        quote = c;
                        hadWord = true;
                        break;
                    }
                    case '\t': 
                    case ' ': {
                        if (quote != '\u0000') break;
                        if (hadWord) {
                            result.add(sb.toString());
                            sb.delete(0, sb.length());
                            hadWord = false;
                        }
                        break block10;
                    }
                    case '\\': {
                        char nextChar;
                        if (i + 1 < length && ((nextChar = value.charAt(i + 1)) == '\'' || nextChar == '\"' || nextChar == '\\')) {
                            sb.append(c);
                            c = nextChar;
                            ++i;
                        }
                    }
                    default: {
                        hadWord = true;
                    }
                }
                sb.append(c);
            }
            ++i;
        }
        if (hadWord) {
            result.add(sb.toString());
        }
        return Collections.unmodifiableList(result);
    }
}

