/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.internal.qt.core.index.CDTIndex;
import org.eclipse.cdt.internal.qt.core.index.QEnum;
import org.eclipse.cdt.internal.qt.core.index.QMethod;
import org.eclipse.cdt.internal.qt.core.index.QObjectMembers;
import org.eclipse.cdt.internal.qt.core.index.QProperty;
import org.eclipse.cdt.internal.qt.core.index.QtIndexImpl;
import org.eclipse.cdt.internal.qt.core.pdom.QtPDOMProperty;
import org.eclipse.cdt.internal.qt.core.pdom.QtPDOMQEnum;
import org.eclipse.cdt.internal.qt.core.pdom.QtPDOMQMethod;
import org.eclipse.cdt.internal.qt.core.pdom.QtPDOMQObject;
import org.eclipse.cdt.qt.core.index.IQEnum;
import org.eclipse.cdt.qt.core.index.IQMethod;
import org.eclipse.cdt.qt.core.index.IQObject;
import org.eclipse.cdt.qt.core.index.IQProperty;
import org.eclipse.core.runtime.CoreException;

public class QObject
implements IQObject {
    private final String name;
    private final QtPDOMQObject pdomQObject;
    private final List<IQObject> bases;
    private final IQObject.IMembers<IQMethod> slots;
    private final IQObject.IMembers<IQMethod> signals;
    private final IQObject.IMembers<IQMethod> invokables;
    private final IQObject.IMembers<IQProperty> properties;
    private final List<IQEnum> enums;
    private final Map<String, String> classInfos;

    public QObject(QtIndexImpl qtIndex, CDTIndex cdtIndex, QtPDOMQObject pdomQObject) throws CoreException {
        this.name = pdomQObject.getName();
        this.pdomQObject = pdomQObject;
        ArrayList<IQMethod> baseSlots = new ArrayList<IQMethod>();
        ArrayList<IQMethod> baseSignals = new ArrayList<IQMethod>();
        ArrayList<IQMethod> baseInvokables = new ArrayList<IQMethod>();
        ArrayList<IQProperty> baseProps = new ArrayList<IQProperty>();
        this.bases = new ArrayList<IQObject>();
        for (QtPDOMQObject base : pdomQObject.findBases()) {
            QObject baseQObj = new QObject(qtIndex, cdtIndex, base);
            this.bases.add(baseQObj);
            baseSlots.addAll(baseQObj.getSlots().all());
            baseSignals.addAll(baseQObj.getSignals().all());
            baseInvokables.addAll(baseQObj.getInvokables().all());
            baseProps.addAll(baseQObj.getProperties().all());
        }
        this.classInfos = pdomQObject.getClassInfos();
        ArrayList<QMethod> slots = new ArrayList<QMethod>();
        ArrayList<QMethod> signals = new ArrayList<QMethod>();
        ArrayList<QMethod> invokables = new ArrayList<QMethod>();
        for (QtPDOMQMethod qtPDOMQMethod : pdomQObject.getChildren(QtPDOMQMethod.class)) {
            switch (qtPDOMQMethod.getKind()) {
                case Slot: {
                    slots.add(new QMethod(this, qtPDOMQMethod));
                    break;
                }
                case Signal: {
                    signals.add(new QMethod(this, qtPDOMQMethod));
                    break;
                }
                case Invokable: {
                    invokables.add(new QMethod(this, qtPDOMQMethod));
                    break;
                }
            }
        }
        this.slots = QObjectMembers.create(slots, baseSlots);
        this.signals = QObjectMembers.create(signals, baseSignals);
        this.invokables = QObjectMembers.create(invokables, baseInvokables);
        this.enums = new ArrayList<IQEnum>();
        for (QtPDOMQEnum qtPDOMQEnum : pdomQObject.getChildren(QtPDOMQEnum.class)) {
            this.enums.add(new QEnum(qtPDOMQEnum.getName(), qtPDOMQEnum.isFlag(), qtPDOMQEnum.getEnumerators()));
        }
        ArrayList<QProperty> arrayList = new ArrayList<QProperty>();
        for (QtPDOMProperty pdom : pdomQObject.getChildren(QtPDOMProperty.class)) {
            QProperty qProp = new QProperty(this, pdom.getType(), pdom.getName());
            QtPDOMProperty.Attribute[] attributeArray = pdom.getAttributes();
            int n = attributeArray.length;
            int n2 = 0;
            while (n2 < n) {
                QtPDOMProperty.Attribute attr = attributeArray[n2];
                qProp.setAttribute(attr.attr, attr.value);
                ++n2;
            }
            arrayList.add(qProp);
        }
        this.properties = QObjectMembers.create(arrayList, baseProps);
    }

    @Override
    public IBinding getBinding() {
        return this.pdomQObject;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<IQObject> getBases() {
        return this.bases;
    }

    @Override
    public IQObject.IMembers<IQMethod> getSlots() {
        return this.slots;
    }

    @Override
    public IQObject.IMembers<IQMethod> getSignals() {
        return this.signals;
    }

    @Override
    public IQObject.IMembers<IQMethod> getInvokables() {
        return this.invokables;
    }

    @Override
    public IQObject.IMembers<IQProperty> getProperties() {
        return this.properties;
    }

    @Override
    public String getClassInfo(String key) {
        String value = this.classInfos.get(key);
        if (value != null) {
            return value;
        }
        for (IQObject base : this.bases) {
            value = base.getClassInfo(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Override
    public Collection<IQEnum> getEnums() {
        return this.enums;
    }
}

