/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core.index;

import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexMacro;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.qt.core.index.CDTIndex;
import org.eclipse.cdt.internal.qt.core.index.QtIndexImpl;
import org.eclipse.cdt.qt.core.QtPlugin;
import org.eclipse.cdt.qt.core.index.QtIndex;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class QtFactory {
    private static final char[] QT_VERSION = "QT_VERSION".toCharArray();
    private static final CDTIndex.Accessor<QtVersion> QtVersionAccessor = new CDTIndex.Accessor<QtVersion>(){

        @Override
        public QtVersion access(IIndex index) throws CoreException {
            TreeSet<String> versions = new TreeSet<String>();
            try {
                IIndexMacro[] iIndexMacroArray = index.findMacros(QT_VERSION, IndexFilter.ALL, null);
                int n = iIndexMacroArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IIndexMacro macro = iIndexMacroArray[n2];
                    versions.add(new String(macro.getExpansion()).toLowerCase());
                    ++n2;
                }
            }
            catch (CoreException coreException) {}
            if (versions.size() <= 0) {
                return null;
            }
            return QtVersion.create((String)versions.last());
        }
    };

    public static QtIndex create(IProject project) {
        CDTIndex cdtIndex = QtFactory.getCDTIndex(project);
        if (cdtIndex == null) {
            QtPlugin.log("could not get CDT index from project " + project.getName());
            return null;
        }
        QtVersion qtVersion = cdtIndex.get(QtVersionAccessor);
        if (qtVersion == null) {
            QtPlugin.log("could not find Qt version in CDT index from project " + project.getName());
            return null;
        }
        if (qtVersion.major == 4 && qtVersion.minor == 8) {
            return new QtIndexImpl(cdtIndex);
        }
        return new QtIndexImpl(cdtIndex);
    }

    private static CDTIndex getCDTIndex(IProject project) {
        if (project == null) {
            return null;
        }
        ICProject cProject = CoreModel.getDefault().create(project);
        if (cProject == null) {
            return null;
        }
        IIndex index = null;
        try {
            index = CCorePlugin.getIndexManager().getIndex(cProject);
        }
        catch (CoreException e) {
            QtPlugin.log(e);
            return null;
        }
        return index == null ? null : new CDTIndex(index);
    }

    private static class QtVersion {
        public final int major;
        public final int minor;
        public final int patch;
        private static final Pattern Version_regex = Pattern.compile("0x([a-fA-F\\d]{1,2})([a-fA-F\\d]{2})([a-fA-F\\d]{2})");

        public static QtVersion create(String version) {
            Matcher m = Version_regex.matcher(version);
            if (!m.matches()) {
                return null;
            }
            try {
                int major = Integer.parseInt(m.group(1), 16);
                int minor = Integer.parseInt(m.group(2), 16);
                int patch = Integer.parseInt(m.group(3), 16);
                return new QtVersion(major, minor, patch);
            }
            catch (NumberFormatException e) {
                QtPlugin.log(e);
                return null;
            }
        }

        private QtVersion(int major, int minor, int patch) {
            this.major = major;
            this.minor = minor;
            this.patch = patch;
        }
    }
}

