/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core.pdom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroExpansion;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.index.IIndexSymbols;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.parser.scanner.LocationMap;
import org.eclipse.cdt.internal.qt.core.QtMethodUtil;
import org.eclipse.cdt.internal.qt.core.pdom.ASTNameReference;
import org.eclipse.cdt.internal.qt.core.pdom.QMethodName;
import org.eclipse.cdt.internal.qt.core.pdom.QObjectName;
import org.eclipse.cdt.internal.qt.core.pdom.QtASTClass;
import org.eclipse.cdt.internal.qt.core.pdom.QtASTImageLocation;
import org.eclipse.cdt.internal.qt.core.pdom.QtEnumName;
import org.eclipse.cdt.internal.qt.core.pdom.QtPropertyName;
import org.eclipse.cdt.qt.core.index.IQMethod;
import org.eclipse.cdt.qt.core.index.IQProperty;

public class QtASTVisitor
extends ASTVisitor {
    private final IIndexSymbols symbols;
    private final LocationMap locationMap;
    private static final Pattern expansionParamRegex = Pattern.compile("^(?:Q_ENUMS|Q_FLAGS)\\s*\\((.*)\\)$", 32);
    private static final Pattern qualNameRegex = Pattern.compile("\\s*((?:[^\\s:]+\\s*::\\s*)*[^\\s:]+).*");
    private static final Pattern declareFlagsRegex = Pattern.compile("^Q_DECLARE_FLAGS\\s*\\(\\s*([^\\s]+),\\s*([^\\s]+)\\s*\\)$", 32);
    private static final Pattern classInfoRegex = Pattern.compile("^Q_CLASSINFO\\s*\\(\\s*\"([^\"]+)\"\\s*,\\s*\"(.*)\"\\s*\\)$", 32);
    private static final Pattern leadingWhitespaceRegex = Pattern.compile("^\\s*([^\\s].*)$");
    private static final Pattern qPropertyRegex = Pattern.compile("^Q_PROPERTY\\s*\\(\\s*(.+?)\\s*([a-zA-Z_][\\w]*+)(?:(?:\\s+(READ\\s+.*))|\\s*)\\s*\\)$", 32);
    private static final Pattern qPropertyAttributeRegex;

    static {
        StringBuilder regexBuilder = new StringBuilder();
        IQProperty.Attribute[] attributeArray = IQProperty.Attribute.values();
        int n = attributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IQProperty.Attribute attr = attributeArray[n2];
            if (attr.ordinal() > 0) {
                regexBuilder.append('|');
            }
            regexBuilder.append("(:?");
            regexBuilder.append(attr.identifier);
            regexBuilder.append(")");
            ++n2;
        }
        qPropertyAttributeRegex = Pattern.compile(regexBuilder.toString());
    }

    public QtASTVisitor(IIndexSymbols symbols, LocationMap locationMap) {
        this.shouldVisitDeclSpecifiers = true;
        this.symbols = symbols;
        this.locationMap = locationMap;
    }

    public int visit(IASTDeclSpecifier declSpec) {
        if (declSpec instanceof ICPPASTCompositeTypeSpecifier) {
            ICPPASTCompositeTypeSpecifier spec = (ICPPASTCompositeTypeSpecifier)declSpec;
            IASTFileLocation loc = spec.getFileLocation();
            IASTPreprocessorIncludeStatement owner = loc == null ? null : loc.getContextInclusionStatement();
            IASTPreprocessorMacroExpansion[] expansions = this.locationMap.getMacroExpansions(loc);
            if (this.isQObject(spec, expansions)) {
                this.handleQObject(owner, spec, expansions);
            }
        }
        return super.visit(declSpec);
    }

    private boolean isQObject(ICPPASTCompositeTypeSpecifier spec, IASTPreprocessorMacroExpansion[] expansions) {
        IASTPreprocessorMacroExpansion[] iASTPreprocessorMacroExpansionArray = expansions;
        int n = expansions.length;
        int n2 = 0;
        while (n2 < n) {
            IASTPreprocessorMacroExpansion expansion = iASTPreprocessorMacroExpansionArray[n2];
            IASTPreprocessorMacroDefinition macro = expansion.getMacroDefinition();
            if ("Q_OBJECT".equals(String.valueOf(macro.getName()))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void handleQObject(IASTPreprocessorIncludeStatement owner, ICPPASTCompositeTypeSpecifier spec, IASTPreprocessorMacroExpansion[] expansions) {
        QObjectName qobjName = new QObjectName(spec);
        this.symbols.add(owner, (IASTName)qobjName, null);
        this.symbols.add(owner, (IASTName)new ASTNameReference(spec.getName()), (IASTName)qobjName);
        ArrayList<EnumDecl> enumDecls = new ArrayList<EnumDecl>();
        HashMap<String, String> flagAliases = new HashMap<String, String>();
        IASTPreprocessorMacroExpansion[] iASTPreprocessorMacroExpansionArray = expansions;
        int n = expansions.length;
        int n2 = 0;
        while (n2 < n) {
            String macroName;
            IASTPreprocessorMacroExpansion expansion = iASTPreprocessorMacroExpansionArray[n2];
            IASTName name = expansion.getMacroReference();
            String string = macroName = name == null ? null : name.toString();
            if (!"Q_OBJECT".equals(macroName)) {
                Matcher m;
                if ("Q_ENUMS".equals(macroName)) {
                    this.extractEnumDecls(expansion, false, enumDecls);
                } else if ("Q_FLAGS".equals(macroName)) {
                    this.extractEnumDecls(expansion, true, enumDecls);
                } else if ("Q_DECLARE_FLAGS".equals(macroName)) {
                    m = declareFlagsRegex.matcher(expansion.getRawSignature());
                    if (m.matches()) {
                        String flagName = m.group(1);
                        String enumName = m.group(2);
                        flagAliases.put(flagName, enumName);
                    }
                } else if ("Q_CLASSINFO".equals(macroName)) {
                    m = classInfoRegex.matcher(expansion.getRawSignature());
                    if (m.matches()) {
                        String key = m.group(1);
                        String value = m.group(2);
                        qobjName.addClassInfo(key, value);
                    }
                } else if ("Q_PROPERTY".equals(macroName)) {
                    this.handleQPropertyDefn(owner, qobjName, expansion);
                }
            }
            ++n2;
        }
        this.extractQMethods(owner, spec, qobjName);
        for (EnumDecl decl : enumDecls) {
            decl.handle(owner, spec, qobjName, flagAliases);
        }
    }

    private void extractEnumDecls(IASTPreprocessorMacroExpansion expansion, boolean isFlag, List<EnumDecl> decls) {
        String signature = expansion.getRawSignature();
        Matcher m = expansionParamRegex.matcher(signature);
        if (!m.matches()) {
            return;
        }
        IASTName refName = expansion.getMacroReference();
        String param = m.group(1);
        int offset = m.start(1);
        int end = param.length();
        while (!param.isEmpty()) {
            m = qualNameRegex.matcher(param);
            if (!m.matches()) break;
            int start = m.start(1);
            end = m.end(1);
            String enumName = m.group(1);
            decls.add(new EnumDecl(enumName, isFlag, refName, offset + start, end - start));
            offset += end;
            param = param.substring(end);
        }
    }

    private void handleQPropertyDefn(IASTPreprocessorIncludeStatement owner, QObjectName qobjName, IASTPreprocessorMacroExpansion expansion) {
        Matcher m = qPropertyRegex.matcher(expansion.getRawSignature());
        if (!m.matches()) {
            return;
        }
        String type = m.group(1);
        String name = m.group(2);
        int nameStart = m.start(2);
        int nameEnd = m.end(2);
        IASTName refName = expansion.getMacroReference();
        QtASTImageLocation location = new QtASTImageLocation(refName.getFileLocation(), nameStart, nameEnd - nameStart);
        QtPropertyName propertyName = new QtPropertyName(qobjName, refName, name, location);
        propertyName.setType(type);
        qobjName.addProperty(propertyName);
        this.symbols.add(owner, (IASTName)propertyName, (IASTName)qobjName);
        AttrValue[] values = new AttrValue[IQProperty.Attribute.values().length];
        String attributes = m.group(3);
        if (attributes == null) {
            return;
        }
        int attrOffset = m.start(3);
        int lastEnd = 0;
        IQProperty.Attribute lastAttr = null;
        Matcher attributeMatcher = qPropertyAttributeRegex.matcher(attributes);
        while (attributeMatcher.find()) {
            if (lastAttr != null) {
                String value = attributes.substring(lastEnd, attributeMatcher.start());
                int wsOffset = 0;
                Matcher ws = leadingWhitespaceRegex.matcher(value);
                if (ws.matches()) {
                    value = ws.group(1);
                    wsOffset = ws.start(1);
                }
                values[lastAttr.ordinal()] = new AttrValue(attrOffset + lastEnd + wsOffset, value.trim());
            }
            lastAttr = IQProperty.Attribute.valueOf(IQProperty.Attribute.class, attributeMatcher.group(0));
            if (!lastAttr.hasValue) {
                values[lastAttr.ordinal()] = AttrValue.None;
                lastAttr = null;
            }
            lastEnd = attributeMatcher.end();
        }
        if (lastAttr != null) {
            String value = attributes.substring(lastEnd);
            int wsOffset = 0;
            Matcher ws = leadingWhitespaceRegex.matcher(value);
            if (ws.matches()) {
                value = ws.group(1);
                wsOffset = ws.start(1);
            }
            values[lastAttr.ordinal()] = new AttrValue(attrOffset + lastEnd + wsOffset, value.trim());
        }
        int i = 0;
        while (i < values.length) {
            IQProperty.Attribute attr = IQProperty.Attribute.values()[i];
            AttrValue value = values[i];
            if (value != null) {
                if (!QtASTVisitor.couldHaveBinding(attr)) {
                    propertyName.addAttribute(attr, value.value);
                } else {
                    IBinding[] bindings = null;
                    IASTNode specNode = qobjName.getParent();
                    if (specNode instanceof IASTCompositeTypeSpecifier) {
                        IScope scope = ((IASTCompositeTypeSpecifier)specNode).getScope();
                        bindings = CPPSemantics.findBindings((IScope)scope, (String)value.value, (boolean)false);
                    }
                    if (bindings == null || bindings.length <= 0) {
                        propertyName.addAttribute(attr, value.value);
                    } else {
                        IBinding[] iBindingArray = bindings;
                        int n = bindings.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IBinding foundBinding = iBindingArray[n2];
                            propertyName.addAttribute(attr, value.value, foundBinding);
                            IASTName cppName = QtASTVisitor.findASTName(foundBinding);
                            if (cppName != null) {
                                QtASTImageLocation attrLoc = new QtASTImageLocation(refName.getFileLocation(), value.offset, value.value.length());
                                this.symbols.add(owner, (IASTName)new ASTNameReference(cppName, (IASTFileLocation)attrLoc), (IASTName)propertyName);
                            }
                            ++n2;
                        }
                    }
                }
            }
            ++i;
        }
    }

    private static boolean couldHaveBinding(IQProperty.Attribute attr) {
        switch (attr) {
            case READ: 
            case WRITE: 
            case RESET: 
            case NOTIFY: 
            case DESIGNABLE: 
            case SCRIPTABLE: {
                return true;
            }
        }
        return false;
    }

    private static IASTName findASTName(IBinding binding) {
        IASTName astName;
        IASTNode node = null;
        if (binding instanceof ICPPInternalBinding && (node = ((ICPPInternalBinding)binding).getDefinition()) == null) {
            node = ((ICPPInternalBinding)binding).getDeclarations()[0];
        }
        if (node == null) {
            return null;
        }
        IASTName iASTName = astName = node instanceof IASTName ? (IASTName)node : null;
        if (astName != null) {
            return astName;
        }
        if (node instanceof IASTDeclarator) {
            return ((IASTDeclarator)node).getName();
        }
        return null;
    }

    private void extractQMethods(IASTPreprocessorIncludeStatement owner, ICPPASTCompositeTypeSpecifier spec, QObjectName qobjName) {
        QtASTClass qtASTClass = QtASTClass.create(spec);
        IASTDeclaration[] iASTDeclarationArray = spec.getMembers();
        int n = iASTDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTSimpleDeclaration simpleDecl;
            IASTDeclaration decl = iASTDeclarationArray[n2];
            int offset = decl.getFileLocation().getNodeOffset();
            IQMethod.Kind kind = qtASTClass.getKindFor(offset);
            Long revision = qtASTClass.getRevisionFor(offset);
            if (kind != IQMethod.Kind.Unspecified && (simpleDecl = QtASTVisitor.getSimpleDecl((IASTNode)decl)) != null) {
                IASTName cppName;
                ICPPASTFunctionDeclarator decltor = null;
                IASTDeclarator[] iASTDeclaratorArray = simpleDecl.getDeclarators();
                int n3 = iASTDeclaratorArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IASTDeclarator d = iASTDeclaratorArray[n4];
                    if (d instanceof ICPPASTFunctionDeclarator) {
                        decltor = (ICPPASTFunctionDeclarator)d;
                        break;
                    }
                    ++n4;
                }
                if (decltor != null && (cppName = decltor.getName()) != null) {
                    String qtEncSignatures = QtMethodUtil.getEncodedQtMethodSignatures(decltor);
                    this.symbols.add(owner, (IASTName)new QMethodName(qobjName, cppName, kind, qtEncSignatures, revision), (IASTName)qobjName);
                }
            }
            ++n2;
        }
    }

    private static IASTSimpleDeclaration getSimpleDecl(IASTNode node) {
        while (node != null && !(node instanceof IASTSimpleDeclaration)) {
            node = node.getParent();
        }
        return node instanceof IASTSimpleDeclaration ? (IASTSimpleDeclaration)node : null;
    }

    private static IASTName getFunctionName(IASTDeclaration decl) {
        IASTSimpleDeclaration simpleDecl = QtASTVisitor.getSimpleDecl((IASTNode)decl);
        if (simpleDecl == null) {
            return null;
        }
        IASTDeclarator[] iASTDeclaratorArray = simpleDecl.getDeclarators();
        int n = iASTDeclaratorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclarator decltor = iASTDeclaratorArray[n2];
            if (decltor instanceof IASTFunctionDeclarator) {
                return decltor.getName();
            }
            ++n2;
        }
        return null;
    }

    private static class AttrValue {
        public final int offset;
        public final String value;
        public static final AttrValue None = new AttrValue(0, null);

        public AttrValue(int offset, String value) {
            this.offset = offset;
            this.value = value;
        }
    }

    private class EnumDecl {
        private final String name;
        private final boolean isFlag;
        private final IASTName refName;
        private final QtASTImageLocation location;

        public EnumDecl(String name, boolean isFlag, IASTName refName, int offset, int length) {
            this.name = name;
            this.isFlag = isFlag;
            this.refName = refName;
            this.location = new QtASTImageLocation(refName.getFileLocation(), offset, length);
        }

        public void handle(IASTPreprocessorIncludeStatement owner, ICPPASTCompositeTypeSpecifier spec, QObjectName qobjName, Map<String, String> aliases) {
            IBinding[] bindings;
            String alias = aliases.get(this.name);
            IBinding[] iBindingArray = bindings = CPPSemantics.findBindingsForQualifiedName((IScope)spec.getScope(), (String)(alias == null ? this.name : alias));
            int n = bindings.length;
            int n2 = 0;
            while (n2 < n) {
                IBinding binding = iBindingArray[n2];
                IASTName cppName = QtASTVisitor.findASTName(binding);
                QtEnumName astName = new QtEnumName(qobjName, this.refName, this.name, cppName, this.location, this.isFlag);
                QtASTVisitor.this.symbols.add(owner, (IASTName)astName, (IASTName)qobjName);
                if (cppName != null) {
                    QtASTVisitor.this.symbols.add(owner, (IASTName)new ASTNameReference(cppName, (IASTFileLocation)this.location), (IASTName)astName);
                }
                ++n2;
            }
        }
    }
}

