/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core.pdom;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.index.IIndexFragmentBinding;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeComparator;
import org.eclipse.cdt.internal.core.pdom.dom.FindBinding;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.qt.core.pdom.IQtASTName;
import org.eclipse.cdt.internal.qt.core.pdom.QtPDOMBinding;
import org.eclipse.cdt.internal.qt.core.pdom.QtPDOMNodeType;
import org.eclipse.cdt.qt.core.QtPlugin;
import org.eclipse.core.runtime.CoreException;

public class QtPDOMLinkage
extends PDOMLinkage {
    private static int offsetInitializer = 32;
    private int version;
    private final Map<IQtASTName, PDOMBinding> cache = new HashMap<IQtASTName, PDOMBinding>();

    public QtPDOMLinkage(PDOM pdom, long record) throws CoreException {
        super(pdom, record);
        this.version = pdom.getDB().getInt(Field.Version.getRecord(record));
    }

    protected QtPDOMLinkage(PDOM pdom) throws CoreException {
        super(pdom, "Qt", "Qt".toCharArray());
        this.version = 4;
        pdom.getDB().putInt(Field.Version.getRecord(this.record), this.version);
    }

    public int getVersion() {
        return this.version;
    }

    public String getLinkageName() {
        return "Qt";
    }

    public int getLinkageID() {
        return 5;
    }

    public PDOMNode getNode(long record, int nodeType) throws CoreException {
        return QtPDOMNodeType.load(this, nodeType, record);
    }

    public IBTreeComparator getIndexComparator() {
        return new FindBinding.DefaultBindingBTreeComparator((PDOMLinkage)this);
    }

    public PDOMBinding adaptBinding(IBinding binding, boolean includeLocal) throws CoreException {
        if (binding == null) {
            return null;
        }
        QtPDOMBinding pdomBinding = (QtPDOMBinding)((Object)binding.getAdapter(QtPDOMBinding.class));
        if (pdomBinding != null && pdomBinding.getLinkage() == this) {
            return pdomBinding;
        }
        if (pdomBinding != null) {
            this.addChild((PDOMNode)pdomBinding);
            return pdomBinding;
        }
        return this.getPDOM().getLinkage(1).adaptBinding(binding);
    }

    public long getCPPRecord(IASTName cppName) throws CoreException {
        if (cppName == null) {
            return 0L;
        }
        IIndexFragmentBinding binding = this.getPDOM().findBinding(cppName);
        if (binding == null) {
            return 0L;
        }
        IPDOMBinding pdomBinding = (IPDOMBinding)binding.getAdapter(IPDOMBinding.class);
        if (pdomBinding == null) {
            return 0L;
        }
        if (pdomBinding.getLinkage() == null || pdomBinding.getLinkage().getLinkageID() != 1) {
            return 0L;
        }
        return pdomBinding.getRecord();
    }

    public PDOMBinding getBinding(IQtASTName qtAstName) throws CoreException {
        PDOMBinding pdomBinding = null;
        pdomBinding = this.cache.get(qtAstName);
        if (pdomBinding != null) {
            return pdomBinding;
        }
        pdomBinding = qtAstName.createPDOMBinding(this);
        this.cache.put(qtAstName, pdomBinding);
        if (pdomBinding != null) {
            this.addChild((PDOMNode)pdomBinding);
        }
        return pdomBinding;
    }

    public PDOMBinding addBinding(IASTName name) throws CoreException {
        if (name == null) {
            return null;
        }
        if (name instanceof IQtASTName) {
            return this.getBinding((IQtASTName)name);
        }
        IBinding binding = name.getBinding();
        if (binding == null) {
            return null;
        }
        QtPDOMLinkage pdomLinkage = this;
        ILinkage linkage = binding.getLinkage();
        if (linkage != null && linkage.getLinkageID() != this.getLinkageID()) {
            pdomLinkage = this.getPDOM().getLinkage(linkage.getLinkageID());
        }
        return (pdomLinkage == null ? this : pdomLinkage).adaptBinding(binding);
    }

    public int getBindingType(IBinding binding) {
        return binding instanceof QtPDOMBinding ? ((QtPDOMBinding)binding).getNodeType() : 0;
    }

    public PDOMBinding addTypeBinding(IBinding binding) throws CoreException {
        throw new CoreException(QtPlugin.error("Qt Linkage does not manage types"));
    }

    public IType unmarshalType(ITypeMarshalBuffer buffer) throws CoreException {
        throw new CoreException(QtPlugin.error("Qt Linkage does not marshal types"));
    }

    public IBinding unmarshalBinding(ITypeMarshalBuffer buffer) throws CoreException {
        throw new CoreException(QtPlugin.error("Qt Linkage does not marshal bindings"));
    }

    public ISerializableEvaluation unmarshalEvaluation(ITypeMarshalBuffer typeMarshalBuffer) throws CoreException {
        throw new CoreException(QtPlugin.error("Qt Linkage does not marshal evaluations"));
    }

    private static enum Field {
        Version(4),
        Last(0);

        private final int offset = QtPDOMLinkage.access$0();

        private Field(int sizeof) {
            offsetInitializer = offsetInitializer + sizeof;
        }

        public long getRecord(long baseRec) {
            return baseRec + (long)this.offset;
        }
    }
}

