/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.qt.core;

import org.eclipse.cdt.qt.core.QtPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class QtNature
implements IProjectNature {
    private static final String ID = "org.eclipse.cdt.qt.core.qtNature";
    private IProject project;

    public static boolean hasNature(IProject project) {
        try {
            return project.hasNature(ID);
        }
        catch (CoreException e) {
            QtPlugin.log(e);
            return false;
        }
    }

    public static void addNature(IProject project, IProgressMonitor monitor) throws CoreException {
        if (project.isOpen()) {
            if (QtNature.hasNature(project)) {
                return;
            }
            IProjectDescription desc = project.getDescription();
            String[] oldIds = desc.getNatureIds();
            String[] newIds = new String[oldIds.length + 1];
            System.arraycopy(oldIds, 0, newIds, 0, oldIds.length);
            newIds[oldIds.length] = ID;
            desc.setNatureIds(newIds);
            project.setDescription(desc, monitor);
        }
    }

    public void configure() throws CoreException {
    }

    public void deconfigure() throws CoreException {
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }
}

