/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.command.factories.macos;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIList;
import org.eclipse.cdt.debug.mi.core.output.MIOutput;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MIResultRecord;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;
import org.eclipse.cdt.debug.mi.core.output.MIVarChange;
import org.eclipse.cdt.debug.mi.core.output.MIVarUpdateInfo;

class MacOSMIVarUpdateInfo
extends MIVarUpdateInfo {
    MIVarChange[] changeList;

    public MacOSMIVarUpdateInfo(MIOutput record) {
        super(record);
        this.parse();
    }

    @Override
    public MIVarChange[] getMIVarChanges() {
        return this.changeList;
    }

    void parse() {
        MIOutput out;
        MIResultRecord rr;
        ArrayList aList = new ArrayList();
        if (this.isDone() && (rr = (out = this.getMIOutput()).getMIResultRecord()) != null) {
            MIResult[] results = rr.getMIResults();
            int i = 0;
            while (i < results.length) {
                String var = results[i].getVariable();
                if (var.equals("changelist")) {
                    MIValue value = results[i].getMIValue();
                    if (value instanceof MITuple) {
                        this.parseChangeList((MITuple)value, aList);
                    } else if (value instanceof MIList) {
                        this.parseChangeList((MIList)value, aList);
                    }
                }
                ++i;
            }
        }
        this.changeList = aList.toArray(new MIVarChange[aList.size()]);
    }

    void parseChangeList(MIList miList, List aList) {
        MIValue[] values = miList.getMIValues();
        int i = 0;
        while (i < values.length) {
            if (values[i] instanceof MITuple) {
                this.parseChangeList((MITuple)values[i], aList);
            } else if (values[i] instanceof MIList) {
                this.parseChangeList((MIList)values[i], aList);
            }
            ++i;
        }
        MIResult[] results = miList.getMIResults();
        int i2 = 0;
        while (i2 < results.length) {
            String var = results[i2].getVariable();
            if (var.equals("varobj")) {
                MIValue value = results[i2].getMIValue();
                if (value instanceof MITuple) {
                    this.parseChangeList((MITuple)value, aList);
                } else if (value instanceof MIList) {
                    this.parseChangeList((MIList)value, aList);
                }
            }
            ++i2;
        }
    }

    void parseChangeList(MITuple tuple, List aList) {
        MIResult[] results = tuple.getMIResults();
        MIVarChange change = null;
        int i = 0;
        while (i < results.length) {
            String var = results[i].getVariable();
            MIValue value = results[i].getMIValue();
            if (value instanceof MITuple) {
                this.parseChangeList((MITuple)value, aList);
            } else {
                String str = "";
                if (value instanceof MIConst) {
                    str = ((MIConst)value).getString();
                }
                if (var.equals("name")) {
                    change = new MIVarChange(str);
                    aList.add(change);
                } else if (var.equals("in_scope")) {
                    if (change != null) {
                        change.setInScope("true".equals(str));
                    }
                } else if (var.equals("type_changed") && change != null) {
                    change.setChanged("true".equals(str));
                }
            }
            ++i;
        }
    }
}

