/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.ui;

import org.eclipse.cdt.codan.internal.ui.cxx.Activator;
import org.eclipse.cdt.codan.ui.AbstractCodanCMarkerResolution;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public abstract class AbstractAstRewriteQuickFix
extends AbstractCodanCMarkerResolution {
    private IDocument document;

    @Override
    public void apply(IMarker marker, IDocument document) {
        try {
            IIndex index;
            this.document = document;
            this.openEditor(marker).doSave((IProgressMonitor)new NullProgressMonitor());
            try {
                index = this.getIndexFromMarker(marker);
            }
            catch (CoreException e) {
                Activator.log(e);
                return;
            }
            try {
                index.acquireReadLock();
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            try {
                this.modifyAST(index, marker);
            }
            finally {
                index.releaseReadLock();
            }
        }
        catch (Exception e) {
            Activator.log(e);
        }
    }

    public abstract void modifyAST(IIndex var1, IMarker var2);

    public IDocument getDocument() {
        return this.document;
    }

    public IASTName getAstNameFromProblemArgument(IMarker marker, IASTTranslationUnit ast, int argumentIndex) {
        IRegion region;
        IASTName astName = null;
        int pos = this.getOffset(marker, this.getDocument());
        String name = null;
        try {
            name = this.getProblemArgument(marker, argumentIndex);
        }
        catch (Exception exception) {
            return null;
        }
        if (name == null) {
            return null;
        }
        FindReplaceDocumentAdapter dad = new FindReplaceDocumentAdapter(this.getDocument());
        try {
            region = dad.find(pos, name, true, true, true, false);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        astName = this.getASTNameFromPositions(ast, region.getOffset(), region.getLength());
        return astName;
    }
}

