/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.cdt.ui.breakpoints;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.dialogs.SelectionDialog;

public class TCFContextQueryExpressionDialog
extends SelectionDialog {
    private String expression;
    private final String originalExpression;
    private final String[] attributeList;
    private ParameterDataModel[] parameterData;
    final String[] columnNames = new String[]{"Parameter", "Value"};

    protected TCFContextQueryExpressionDialog(Shell parentShell, String[] attributes, String initialExpression) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.expression = initialExpression;
        this.originalExpression = initialExpression;
        this.attributeList = attributes;
    }

    String getParameterInitialValue(String comparator, int initIndex) {
        int indexExpr;
        String param = String.valueOf(comparator) + "=";
        if (this.expression != null && this.expression.length() > 0 && (indexExpr = this.expression.indexOf(param, initIndex)) != -1) {
            String testChar;
            if (indexExpr != 0 && !(testChar = this.expression.substring(indexExpr - 1, indexExpr)).matches("[,/]")) {
                return this.getParameterInitialValue(comparator, indexExpr + 1);
            }
            int startOfVal = indexExpr + param.length();
            if (startOfVal != -1) {
                int endOfVal = -1;
                if (startOfVal != 0 && (endOfVal = this.expression.charAt(startOfVal) == '\"' ? this.expression.indexOf(34, ++startOfVal) : this.expression.indexOf(44, startOfVal)) == -1) {
                    endOfVal = this.expression.length();
                }
                return this.expression.substring(startOfVal, endOfVal);
            }
        }
        return null;
    }

    ParameterDataModel[] setupTableList() {
        this.parameterData = new ParameterDataModel[this.attributeList.length];
        int i = 0;
        while (i < this.attributeList.length) {
            this.parameterData[i] = new ParameterDataModel(this.attributeList[i]);
            String initialValue = this.getParameterInitialValue(this.attributeList[i], 0);
            if (initialValue != null) {
                this.parameterData[i].setData(initialValue);
            }
            ++i;
        }
        return this.parameterData;
    }

    int findParameter(String comparator, int initIndex) {
        String testChar;
        int indexExpr = -1;
        if (this.expression != null && this.expression.length() > 0 && (indexExpr = this.expression.indexOf(comparator, initIndex)) != -1 && indexExpr != 0 && !(testChar = this.expression.substring(indexExpr - 1, indexExpr)).matches("[,/]")) {
            return this.findParameter(comparator, indexExpr + 1);
        }
        return indexExpr;
    }

    private boolean replaceParameter(String parameter, String replaceString, int index) {
        String testChar = null;
        int endLocation = 0;
        if (replaceString.length() != 0 && this.expression.contains(replaceString)) {
            return true;
        }
        if (index != 0) {
            testChar = this.expression.substring(index + parameter.length(), index + 1 + parameter.length());
            if (!testChar.equals("=")) {
                return false;
            }
            testChar = this.expression.substring(index - 1, index);
            if (!testChar.matches("[,/]")) {
                return false;
            }
        }
        if ((testChar = this.expression.substring(index + parameter.length() + 1, index + parameter.length() + 2)).equals("\"")) {
            endLocation = this.expression.indexOf(34, index + parameter.length() + 3);
            if (endLocation != -1 && endLocation != this.expression.length() - 1) {
                testChar = this.expression.substring(endLocation + 1, endLocation + 2);
                if (testChar.equals(",")) {
                    ++endLocation;
                }
            } else {
                endLocation = -1;
            }
        } else {
            endLocation = this.expression.indexOf(44, index + 1);
        }
        if (endLocation == -1) {
            endLocation = this.expression.length();
            testChar = this.expression.substring(index - 1, index);
            if (testChar.matches("[,]") && replaceString.length() == 0) {
                --index;
            }
        } else if (replaceString.length() == 0) {
            ++endLocation;
        }
        String removeStr = this.expression.substring(index, endLocation);
        this.expression = this.expression.replace(removeStr, replaceString);
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite page = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, true);
        page.setLayout((Layout)gridLayout);
        page.setLayoutData((Object)new GridData(4, 4, true, true));
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        Table table = new Table(parent, 68096);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setLayout((Layout)tableLayout);
        TableViewer tableViewer = new TableViewer(table);
        tableViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        Control cntrl = tableViewer.getControl();
        cntrl.setLayoutData((Object)new GridData(768));
        TableViewerColumn labelColumn = new TableViewerColumn(tableViewer, 0);
        labelColumn.getColumn().setText(this.columnNames[0]);
        TableViewerColumn valueColumn = new TableViewerColumn(tableViewer, 24);
        valueColumn.getColumn().setText(this.columnNames[1]);
        tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        tableViewer.setLabelProvider((IBaseLabelProvider)new ParameterTableLabelProvider());
        valueColumn.setEditingSupport((EditingSupport)new ExpressionEditingSupport(valueColumn.getViewer()));
        tableViewer.setInput((Object)this.setupTableList());
        tableViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                ParameterDataModel t1 = (ParameterDataModel)e1;
                ParameterDataModel t2 = (ParameterDataModel)e2;
                return t1.getLabel().compareTo(t2.getLabel());
            }
        });
        return parent;
    }

    public String getExpression() {
        return this.expression;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Select Expression Parameters");
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(false);
    }

    public final class CellEditorListener
    implements ICellEditorListener {
        private ValueCellEditor fcellEditor;

        public CellEditorListener(ValueCellEditor cellEditor) {
            this.fcellEditor = cellEditor;
        }

        public void applyEditorValue() {
            String cellString = null;
            Object obj = this.fcellEditor.getValue();
            ParameterDataModel param = (ParameterDataModel)this.fcellEditor.getTableElement();
            String paramName = param.getLabel();
            if (obj != null) {
                cellString = (String)obj;
            }
            if (cellString == null) {
                return;
            }
            if ((cellString = cellString.trim()).length() > 0) {
                if (cellString.charAt(0) != '\"') {
                    cellString = "\"" + cellString;
                }
                if (cellString.charAt(cellString.length() - 1) != '\"') {
                    cellString = String.valueOf(cellString) + "\"";
                }
                if (TCFContextQueryExpressionDialog.this.expression == null || TCFContextQueryExpressionDialog.this.expression.length() == 0) {
                    TCFContextQueryExpressionDialog.this.expression = new String(String.valueOf(paramName) + "=" + cellString);
                } else {
                    String nameValuePair = String.valueOf(paramName) + "=" + cellString;
                    int strIndex = TCFContextQueryExpressionDialog.this.findParameter(paramName, 0);
                    if (strIndex == -1) {
                        String check_parameter = TCFContextQueryExpressionDialog.this.expression;
                        Pattern p = Pattern.compile("\"([^\"]*)\"");
                        Matcher m = p.matcher(check_parameter);
                        check_parameter = m.replaceAll("temp");
                        if (check_parameter.matches("^(.*?)=(.*)$")) {
                            TCFContextQueryExpressionDialog tCFContextQueryExpressionDialog = TCFContextQueryExpressionDialog.this;
                            tCFContextQueryExpressionDialog.expression = String.valueOf(tCFContextQueryExpressionDialog.expression) + "," + nameValuePair;
                        } else {
                            TCFContextQueryExpressionDialog tCFContextQueryExpressionDialog = TCFContextQueryExpressionDialog.this;
                            tCFContextQueryExpressionDialog.expression = String.valueOf(tCFContextQueryExpressionDialog.expression) + nameValuePair;
                        }
                    } else if (!TCFContextQueryExpressionDialog.this.replaceParameter(paramName, nameValuePair, strIndex)) {
                        TCFContextQueryExpressionDialog.this.getButton(0).setEnabled(false);
                    }
                }
                param.setData(cellString);
            } else if (TCFContextQueryExpressionDialog.this.expression != null && TCFContextQueryExpressionDialog.this.expression.length() != 0) {
                this.fcellEditor.setValue(cellString);
                int strIndex = TCFContextQueryExpressionDialog.this.findParameter(paramName, 0);
                if (strIndex != -1) {
                    if (!TCFContextQueryExpressionDialog.this.replaceParameter(paramName, "", strIndex)) {
                        TCFContextQueryExpressionDialog.this.getButton(0).setEnabled(false);
                    }
                    param.setData("");
                }
            }
            if (TCFContextQueryExpressionDialog.this.expression == null || TCFContextQueryExpressionDialog.this.expression.length() == 0 && TCFContextQueryExpressionDialog.this.originalExpression.length() == 0 || TCFContextQueryExpressionDialog.this.originalExpression.contentEquals(TCFContextQueryExpressionDialog.this.expression)) {
                TCFContextQueryExpressionDialog.this.getButton(0).setEnabled(false);
            } else {
                TCFContextQueryExpressionDialog.this.getButton(0).setEnabled(true);
            }
        }

        public void cancelEditor() {
        }

        public void editorValueChanged(boolean oldValidState, boolean newValidState) {
        }
    }

    public final class ExpressionEditingSupport
    extends EditingSupport {
        private ValueCellEditor cellEditor;
        private ColumnViewer fviewer;

        private ExpressionEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.cellEditor = null;
            this.fviewer = viewer;
            this.cellEditor = new ValueCellEditor((Composite)this.getViewer().getControl(), 0);
            this.cellEditor.addListener(new CellEditorListener(this.cellEditor));
        }

        protected CellEditor getCellEditor(Object element) {
            this.cellEditor.setTableElement(element);
            return this.cellEditor;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            if (element instanceof ParameterDataModel) {
                ParameterDataModel data = (ParameterDataModel)element;
                return data.getData();
            }
            return null;
        }

        protected void setValue(Object element, Object value) {
            if (element instanceof ParameterDataModel) {
                ParameterDataModel data = (ParameterDataModel)element;
                data.setData(value);
                this.fviewer.update(element, null);
            }
        }
    }

    public static class ParameterDataModel {
        private String attribute;
        private String value;

        public ParameterDataModel(String label) {
            this.attribute = label;
            this.value = "";
        }

        public String getLabel() {
            return this.attribute;
        }

        public void setLabel(String label) {
            this.attribute = label;
        }

        public String getData() {
            return this.value;
        }

        public void setData(Object data) {
            this.value = data != null ? (String)data : "";
        }
    }

    public final class ParameterTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            ParameterDataModel data = (ParameterDataModel)element;
            switch (columnIndex) {
                case 0: {
                    return data.getLabel();
                }
                case 1: {
                    return data.getData();
                }
            }
            return "";
        }
    }

    public class ValueCellEditor
    extends TextCellEditor {
        private Object tableElement;

        public ValueCellEditor(Composite parent) {
            super(parent);
            this.tableElement = null;
        }

        public ValueCellEditor(Composite parent, int style) {
            super(parent, style);
            this.tableElement = null;
        }

        public void setTableElement(Object element) {
            this.tableElement = element;
        }

        public Object getTableElement() {
            return this.tableElement;
        }
    }
}

