/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.cdt.debug.core.model.CVariableFormat;
import org.eclipse.cdt.debug.internal.ui.actions.VariableFormatActionDelegate;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

public class NumberFormatsContribution
extends CompoundContributionItem
implements IWorkbenchContribution {
    static final String CURRENT_FORMAT = "current_format";
    private static final Map<CVariableFormat, String> FORMATS = new LinkedHashMap<CVariableFormat, String>();
    private IServiceLocator fServiceLocator;
    private static IContributionItem[] NO_ITEMS;

    static {
        FORMATS.put(CVariableFormat.NATURAL, "Default");
        FORMATS.put(CVariableFormat.DECIMAL, "Decimal");
        FORMATS.put(CVariableFormat.HEXADECIMAL, "Hexadecimal");
        FORMATS.put(CVariableFormat.OCTAL, "Octal");
        FORMATS.put(CVariableFormat.BINARY, "Binary");
        NO_ITEMS = new IContributionItem[]{new ContributionItem(){

            public void fill(Menu menu, int index) {
                MenuItem item = new MenuItem(menu, 0);
                item.setEnabled(false);
                item.setText("Empty");
            }

            public boolean isEnabled() {
                return false;
            }
        }};
    }

    protected IContributionItem[] getContributionItems() {
        ISelectionService service = (ISelectionService)this.fServiceLocator.getService(ISelectionService.class);
        ISelection selection = service.getSelection();
        ArrayList<SelectNumberFormatAction> actions = new ArrayList<SelectNumberFormatAction>(FORMATS.size());
        for (CVariableFormat formatId : FORMATS.keySet()) {
            SelectNumberFormatAction action = new SelectNumberFormatAction(formatId);
            action.selectionChanged(selection);
            actions.add(action);
        }
        if (actions.isEmpty()) {
            return NO_ITEMS;
        }
        IContributionItem[] items = new IContributionItem[actions.size()];
        int i = 0;
        while (i < actions.size()) {
            items[i] = new ActionContributionItem((IAction)actions.get(i));
            ++i;
        }
        return items;
    }

    public void initialize(IServiceLocator serviceLocator) {
        this.fServiceLocator = serviceLocator;
    }

    private class SelectNumberFormatAction
    extends Action {
        private final CVariableFormat fFormat;
        private VariableFormatActionDelegate delegate;

        public VariableFormatActionDelegate getDelegate() {
            return this.delegate;
        }

        SelectNumberFormatAction(CVariableFormat format) {
            super((String)FORMATS.get(format), 8);
            this.fFormat = format;
            this.delegate = new VariableFormatActionDelegate(this.fFormat);
        }

        void selectionChanged(ISelection sel) {
            this.delegate.selectionChanged((IAction)this, sel);
        }

        public void run() {
            if (this.isChecked()) {
                this.delegate.run((IAction)this);
            }
        }
    }
}

