/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.disassembly.rendering;

import org.eclipse.cdt.debug.core.disassembly.IDisassemblyContextProvider;
import org.eclipse.cdt.debug.internal.ui.disassembly.rendering.DisassemblyAnnotationModel;
import org.eclipse.cdt.debug.internal.ui.disassembly.viewer.DisassemblyPane;
import org.eclipse.cdt.debug.internal.ui.disassembly.viewer.VirtualDocument;
import org.eclipse.cdt.debug.internal.ui.disassembly.viewer.VirtualSourceViewer;
import org.eclipse.cdt.debug.ui.disassembly.IDocumentPresentation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.ui.memory.AbstractMemoryRendering;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class DisassemblyMemoryRendering
extends AbstractMemoryRendering {
    protected SashForm fSashForm;
    protected DisassemblyPane fDisassemblyPane = new DisassemblyPane("#DisassemblyRenderingContext", "#DisassemblyRenderingRulerContext");

    public DisassemblyMemoryRendering(String renderingId) {
        super(renderingId);
    }

    public Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 2048);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.createViewer(composite);
        return composite;
    }

    public Control getControl() {
        return this.fDisassemblyPane.getControl();
    }

    protected VirtualSourceViewer getViewer() {
        return this.fDisassemblyPane.getViewer();
    }

    protected void createViewer(Composite parent) {
        this.fSashForm = new SashForm(parent, 512);
        this.fSashForm.setLayoutData((Object)new GridData(1808));
        this.fDisassemblyPane.create((Composite)this.fSashForm);
        IMemoryBlock memoryBlock = this.getMemoryBlock();
        IDisassemblyContextProvider contextProvider = this.getDisassemblyContextProvider(memoryBlock);
        Object disassemblyContext = null;
        if (contextProvider != null) {
            disassemblyContext = contextProvider.getDisassemblyContext((Object)memoryBlock);
        }
        DisassemblyAnnotationModel annotationModel = new DisassemblyAnnotationModel();
        VirtualDocument document = new VirtualDocument(annotationModel, this.getDocumentPresentationContext(), disassemblyContext);
        this.getViewer().setDocument((IDocument)document);
        document.getContentProvider().changeInput(this.getViewer(), document.getPresentationContext(), null, this.getMemoryBlock(), document.getCurrentOffset());
    }

    private IDocumentPresentation getDocumentPresentationContext() {
        return null;
    }

    private IDisassemblyContextProvider getDisassemblyContextProvider(Object element) {
        IDisassemblyContextProvider adapter = null;
        if (element instanceof IDisassemblyContextProvider) {
            adapter = (IDisassemblyContextProvider)element;
        } else if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            adapter = (IDisassemblyContextProvider)adaptable.getAdapter(IDisassemblyContextProvider.class);
        }
        return adapter;
    }
}

