/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.compare;

import org.eclipse.compare.ICompareContainer;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.compare.ISharedDocumentAdapter;
import org.eclipse.compare.SharedDocumentAdapter;
import org.eclipse.compare.contentmergeviewer.ContentMergeViewer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IOperation;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.OpUpload;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.compare.EditableSharedDocumentAdapter;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.compare.LocalTypedElement;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.compare.MergeEditorInput;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.compare.MergeInput;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.operations.UiExecutor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.SaveablesLifecycleEvent;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class LocalFileSaveable
extends Saveable
implements IPropertyChangeListener,
EditableSharedDocumentAdapter.ISharedDocumentAdapterListener,
IContentChangeListener {
    private ListenerList listeners = new ListenerList(1);
    private final MergeInput input;
    private final MergeEditorInput editorInput;
    private boolean saving;
    private LocalTypedElement fileElement;
    private IDocument document;
    private boolean connected;

    public LocalFileSaveable(MergeInput input, MergeEditorInput editorInput, LocalTypedElement fileElement) {
        Assert.isNotNull((Object)input);
        this.input = input;
        this.editorInput = editorInput;
        this.fileElement = fileElement;
        this.fileElement.addContentChangeListener(this);
        this.fileElement.setDocumentListener(this);
    }

    public void dispose() {
        this.fileElement.removeContentChangeListener(this);
        this.fileElement.discardBuffer();
        this.fileElement.setDocumentListener(null);
    }

    protected void performSave(IProgressMonitor monitor) throws CoreException {
        try {
            this.saving = true;
            monitor.beginTask(null, 100);
            this.flushViewers(monitor);
            if (this.fileElement.isDirty()) {
                if (this.fileElement.isConnected()) {
                    this.fileElement.store2Document(monitor);
                } else {
                    this.fileElement.store2Cache(monitor);
                }
            }
        }
        catch (Throwable throwable) {
            this.fireInputChange();
            this.setDirty(false);
            this.saving = false;
            monitor.done();
            FSTreeNode node = this.fileElement.getFSTreeNode();
            UiExecutor executor = new UiExecutor();
            executor.execute((IOperation)new OpUpload(new FSTreeNode[]{node}));
            throw throwable;
        }
        this.fireInputChange();
        this.setDirty(false);
        this.saving = false;
        monitor.done();
        FSTreeNode node = this.fileElement.getFSTreeNode();
        UiExecutor executor = new UiExecutor();
        executor.execute((IOperation)new OpUpload(new FSTreeNode[]{node}));
    }

    protected void flushViewers(IProgressMonitor monitor) throws CoreException {
        this.editorInput.saveChanges(monitor);
    }

    protected void fireInputChange() {
        this.editorInput.getCompareResult().fireInputChanged();
    }

    public boolean isDirty() {
        return this.editorInput.isSaveNeeded();
    }

    protected void setDirty(boolean dirty) {
        if (this.isDirty() != dirty) {
            this.editorInput.setDirty(dirty);
            this.firePropertyChange(257);
        }
    }

    public String getName() {
        if (this.fileElement.equals(this.input.getLeft())) {
            return this.input.getLeft().getName();
        }
        if (this.fileElement.equals(this.input.getRight())) {
            return this.input.getRight().getName();
        }
        return this.input.getName();
    }

    public String getToolTipText() {
        return this.editorInput.getToolTipText();
    }

    public ImageDescriptor getImageDescriptor() {
        Image image = this.input.getImage();
        if (image != null) {
            return ImageDescriptor.createFromImage((Image)image);
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getProperty();
        if ("DIRTY_STATE".equals(propertyName)) {
            boolean changed = false;
            Object newValue = e.getNewValue();
            if (newValue instanceof Boolean) {
                changed = (Boolean)newValue;
            }
            ContentMergeViewer cmv = (ContentMergeViewer)e.getSource();
            if (this.fileElement.equals(this.input.getLeft())) {
                if (changed && cmv.internalIsLeftDirty()) {
                    this.setDirty(changed);
                } else if (!changed && !cmv.internalIsLeftDirty()) {
                    this.setDirty(changed);
                }
            }
            if (this.fileElement.equals(this.input.getRight())) {
                if (changed && cmv.internalIsRightDirty()) {
                    this.setDirty(changed);
                } else if (!changed && !cmv.internalIsRightDirty()) {
                    this.setDirty(changed);
                }
            }
        }
    }

    public int hashCode() {
        if (this.document != null) {
            return this.document.hashCode();
        }
        return this.input.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Saveable)) {
            return false;
        }
        if (this.document != null) {
            Object otherDocument = ((Saveable)obj).getAdapter(IDocument.class);
            if (otherDocument == null) {
                return false;
            }
            return this.document.equals(otherDocument);
        }
        if (obj instanceof LocalFileSaveable) {
            LocalFileSaveable saveable = (LocalFileSaveable)obj;
            return saveable.input.equals(this.input);
        }
        return false;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IDocument.class) {
            IDocumentProvider provider;
            IEditorInput input;
            ISharedDocumentAdapter sda;
            if (this.document != null) {
                return this.document;
            }
            if (this.fileElement.isConnected() && (sda = (ISharedDocumentAdapter)this.fileElement.getAdapter(ISharedDocumentAdapter.class)) != null && (input = sda.getDocumentKey((Object)this.fileElement)) != null && (provider = SharedDocumentAdapter.getDocumentProvider((IEditorInput)input)) != null) {
                return provider.getDocument((Object)input);
            }
        }
        if (adapter == IEditorInput.class) {
            return this.fileElement.getEditorInput();
        }
        return super.getAdapter(adapter);
    }

    private ISaveablesLifecycleListener getSaveablesLifecycleListener(IWorkbenchPart part) {
        if (part instanceof ISaveablesLifecycleListener) {
            return (ISaveablesLifecycleListener)part;
        }
        Object adapted = part.getAdapter(ISaveablesLifecycleListener.class);
        if (adapted instanceof ISaveablesLifecycleListener) {
            return (ISaveablesLifecycleListener)adapted;
        }
        adapted = Platform.getAdapterManager().loadAdapter((Object)part, ISaveablesLifecycleListener.class.getName());
        if (adapted instanceof ISaveablesLifecycleListener) {
            return (ISaveablesLifecycleListener)adapted;
        }
        return (ISaveablesLifecycleListener)part.getSite().getService(ISaveablesLifecycleListener.class);
    }

    private void registerSaveable() {
        ICompareContainer container = this.editorInput.getContainer();
        IWorkbenchPart part = container.getWorkbenchPart();
        if (part != null) {
            ISaveablesLifecycleListener lifecycleListener = this.getSaveablesLifecycleListener(part);
            lifecycleListener.handleLifecycleEvent(new SaveablesLifecycleEvent((Object)part, 3, new Saveable[]{this}, false));
            IDocument document = (IDocument)this.getAdapter(IDocument.class);
            if (document != null) {
                this.document = document;
            }
            lifecycleListener.handleLifecycleEvent(new SaveablesLifecycleEvent((Object)part, 1, new Saveable[]{this}, false));
        }
    }

    @Override
    public void handleDocumentConnected() {
        if (this.connected) {
            return;
        }
        this.connected = true;
        this.registerSaveable();
        this.fileElement.setDocumentListener(null);
    }

    @Override
    public void handleDocumentDeleted() {
    }

    @Override
    public void handleDocumentDisconnected() {
    }

    @Override
    public void handleDocumentFlushed() {
    }

    @Override
    public void handleDocumentSaved() {
    }

    public void contentChanged(IContentChangeNotifier source) {
        if (!this.saving) {
            try {
                this.performSave((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public void doSave(IProgressMonitor monitor) throws CoreException {
        if (this.isDirty()) {
            this.performSave(monitor);
            this.setDirty(false);
        }
    }

    public void doRevert(IProgressMonitor monitor) {
        if (!this.isDirty()) {
            return;
        }
        this.fileElement.discardBuffer();
        this.setDirty(false);
    }

    public void addPropertyListener(IPropertyListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removePropertyListener(IPropertyListener listener) {
        this.listeners.remove((Object)listener);
    }

    protected void firePropertyChange(final int property) {
        Object[] allListeners = this.listeners.getListeners();
        int i = 0;
        while (i < allListeners.length) {
            final Object object = allListeners[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void handleException(Throwable e) {
                }

                public void run() throws Exception {
                    ((IPropertyListener)object).propertyChanged((Object)LocalFileSaveable.this, property);
                }
            });
            ++i;
        }
    }
}

