/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.compare;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.OpOutStreamOp;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.compare.MergeTypedElement;
import org.eclipse.tcf.te.tcf.filesystem.ui.nls.Messages;

public class RemoteTypedElement
extends MergeTypedElement {
    public RemoteTypedElement(FSTreeNode node) {
        super(node);
    }

    protected InputStream createStream() throws CoreException {
        try {
            return this.node.getLocationURL().openStream();
        }
        catch (IOException e) {
            Status error = new Status(4, UIPlugin.getUniqueIdentifier(), e.getMessage(), (Throwable)e);
            throw new CoreException((IStatus)error);
        }
    }

    public void cacheContents(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.beginTask(NLS.bind((String)Messages.RemoteTypedElement_DowloadingFile, (Object)this.node.name), 100);
        BufferedOutputStream output = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        output = new BufferedOutputStream(baos);
        monitor.beginTask(String.valueOf(Messages.RemoteTypedElement_GettingRemoteContent) + this.node.name, 100);
        OpOutStreamOp operation = new OpOutStreamOp(this.node, (OutputStream)output);
        operation.run(monitor);
        if (!monitor.isCanceled()) {
            this.setContent(baos.toByteArray());
        }
    }

    public String toString() {
        return this.node.getLocationURI().toString();
    }
}

