/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.terminals.types;

import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.ui.terminals.internal.SettingsStore;
import org.eclipse.tcf.te.ui.terminals.streams.OutputStreamMonitor;
import org.eclipse.tcf.te.ui.terminals.streams.StreamsSettings;
import org.eclipse.tcf.te.ui.terminals.types.AbstractConnectorType;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnector;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalConnectorExtension;

public class StreamsConnectorType
extends AbstractConnectorType {
    @Override
    public ITerminalConnector createTerminalConnector(IPropertiesContainer properties) {
        Assert.isNotNull((Object)properties);
        String connectorId = properties.getStringProperty("tm.terminal.connector.id");
        if (connectorId == null) {
            connectorId = "org.eclipse.tcf.te.ui.terminals.StreamsConnector";
        }
        OutputStream stdin = (OutputStream)properties.getProperty("streams.stdin");
        InputStream stdout = (InputStream)properties.getProperty("streams.stdout");
        InputStream stderr = (InputStream)properties.getProperty("streams.stderr");
        boolean localEcho = properties.getBooleanProperty("localEcho");
        String lineSeparator = properties.getStringProperty("lineSeparator");
        OutputStreamMonitor.Listener[] stdoutListeners = (OutputStreamMonitor.Listener[])properties.getProperty("stdoutListeners");
        OutputStreamMonitor.Listener[] stderrListeners = (OutputStreamMonitor.Listener[])properties.getProperty("stderrListeners");
        SettingsStore store = new SettingsStore();
        StreamsSettings streamsSettings = new StreamsSettings();
        streamsSettings.setStdinStream(stdin);
        streamsSettings.setStdoutStream(stdout);
        streamsSettings.setStderrStream(stderr);
        streamsSettings.setLocalEcho(localEcho);
        streamsSettings.setLineSeparator(lineSeparator);
        streamsSettings.setStdOutListeners(stdoutListeners);
        streamsSettings.setStdErrListeners(stderrListeners);
        streamsSettings.save(store);
        ITerminalConnector connector = TerminalConnectorExtension.makeTerminalConnector((String)connectorId);
        if (connector != null) {
            connector.makeSettingsPage();
            connector.load((ISettingsStore)store);
        }
        return connector;
    }
}

