/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator.internal.adapters;

import java.net.URI;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IPersistableURIProvider;
import org.eclipse.tcf.te.tcf.locator.activator.CoreBundleActivator;

public class MapPersistableURIProvider
implements IPersistableURIProvider {
    public URI getURI(Object context) {
        Assert.isNotNull((Object)context);
        Assert.isNotNull(null);
        URI uri = null;
        if (context instanceof Map) {
            String name = (String)((Map)context).get("Name");
            if (name == null) {
                name = (String)((Map)context).get("ID");
            }
            name = this.makeValidFileSystemName(name);
            uri = this.getRoot().append(name).toFile().toURI();
        }
        return uri;
    }

    private String makeValidFileSystemName(String name) {
        Assert.isNotNull((Object)name);
        return name.replaceAll("\\W", "_");
    }

    protected IPath getRoot() {
        IPath location;
        block5: {
            location = null;
            try {
                IPath path = CoreBundleActivator.getDefault().getStateLocation().append(".peers");
                boolean exists = path.toFile().exists();
                if (!exists) {
                    exists = path.toFile().mkdirs();
                }
                if (exists && path.toFile().canRead() && path.toFile().isDirectory()) {
                    location = path;
                }
            }
            catch (IllegalStateException illegalStateException) {
                IPath path = new Path(System.getProperty("user.home")).append(".tcf/.peers");
                boolean exists = path.toFile().exists();
                if (!exists) {
                    exists = path.toFile().mkdirs();
                }
                if (!exists || !path.toFile().canRead() || !path.toFile().isDirectory()) break block5;
                location = path;
            }
        }
        return location;
    }
}

