/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator.listener;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.tcf.core.AbstractPeer;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.ILocator;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.utils.net.IPAddressUtil;
import org.eclipse.tcf.te.tcf.core.peers.Peer;
import org.eclipse.tcf.te.tcf.locator.ScannerRunnable;
import org.eclipse.tcf.te.tcf.locator.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.locator.interfaces.IModelListener;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelLookupService;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelRefreshService;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelUpdateService;
import org.eclipse.tcf.te.tcf.locator.nodes.PeerModel;
import org.eclipse.tcf.te.tcf.locator.nodes.PeerRedirector;

public class LocatorListener
implements ILocator.LocatorListener {
    final ILocatorModel model;
    private final Map<IPeer, AtomicBoolean> PEER_CHANGED_GUARDIANS = new HashMap<IPeer, AtomicBoolean>();

    public LocatorListener(ILocatorModel model) {
        Assert.isNotNull((Object)model);
        this.model = model;
    }

    public void peerAdded(IPeer peer) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorListener")) {
            CoreBundleActivator.getTraceHandler().trace("LocatorListener.peerAdded( " + (peer != null ? peer.getID() : null) + " )", "trace/locatorListener", (Object)this);
        }
        if (this.model != null && peer != null) {
            String clientID;
            IPeerModel peerNode = this.model.getService(ILocatorModelLookupService.class).lkupPeerModelById(peer.getID());
            if (peerNode == null && (clientID = (String)peer.getAttributes().get("ClientID")) != null) {
                peerNode = this.model.getService(ILocatorModelLookupService.class).lkupPeerModelById(clientID);
            }
            if (peerNode == null) {
                peerNode = new PeerModel(this.model, peer);
                if ((peerNode = this.model.validatePeerNodeForAdd(peerNode)) != null) {
                    ArrayList<IPeerModel> nodes = new ArrayList<IPeerModel>();
                    IPeerModel[] iPeerModelArray = this.model.getPeers();
                    int n = iPeerModelArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPeerModel node = iPeerModelArray[n2];
                        if (node.isStatic() && (node.getPeer().getAgentID() == null || "".equals(node.getPeer().getAgentID()))) {
                            nodes.add(node);
                        }
                        ++n2;
                    }
                    final IPeerModel finPeerNode = peerNode;
                    final IPeer finPeer = peer;
                    final Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            IPeerModel[] matches = LocatorListener.this.model.getService(ILocatorModelLookupService.class).lkupMatchingStaticPeerModels(finPeerNode);
                            if (matches.length == 0) {
                                if (LocatorListener.this.model.getService(ILocatorModelLookupService.class).lkupPeerModelById(finPeerNode.getPeerId()) != null) {
                                    ScannerRunnable runnable2 = new ScannerRunnable(LocatorListener.this.model.getScanner(), finPeerNode);
                                    Protocol.invokeLater((Runnable)runnable2);
                                }
                            } else {
                                LocatorListener.this.model.getService(ILocatorModelUpdateService.class).remove(finPeerNode);
                                IPeerModel[] iPeerModelArray = matches;
                                int n = matches.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IPeerModel match = iPeerModelArray[n2];
                                    IPeer myPeer = LocatorListener.this.model.validatePeer(finPeer);
                                    if (myPeer != null) {
                                        boolean changed = match.setChangeEventsEnabled(false);
                                        LocatorListener.this.model.getService(ILocatorModelUpdateService.class).mergeUserDefinedAttributes(match, myPeer, true);
                                        if (changed) {
                                            match.setChangeEventsEnabled(true);
                                        }
                                        match.fireChangeEvent("instance", myPeer, match.getPeer());
                                        ScannerRunnable runnable2 = new ScannerRunnable(LocatorListener.this.model.getScanner(), match);
                                        Protocol.invokeLater((Runnable)runnable2);
                                    }
                                    ++n2;
                                }
                            }
                        }
                    };
                    this.model.getService(ILocatorModelUpdateService.class).add(peerNode);
                    if (nodes.size() > 0) {
                        this.model.getService(ILocatorModelRefreshService.class).refreshAgentIDs(nodes.toArray(new IPeerModel[nodes.size()]), (ICallback)new Callback(){

                            protected void internalDone(Object caller, IStatus status) {
                                runnable.run();
                            }
                        });
                    } else {
                        runnable.run();
                    }
                }
            } else {
                boolean isStatic = peerNode.isStatic();
                if (isStatic) {
                    IPeer myPeer = this.model.validatePeer(peer);
                    if (myPeer != null) {
                        boolean changed = peerNode.setChangeEventsEnabled(false);
                        this.model.getService(ILocatorModelUpdateService.class).mergeUserDefinedAttributes(peerNode, myPeer, true);
                        if (changed) {
                            peerNode.setChangeEventsEnabled(true);
                        }
                        peerNode.fireChangeEvent("instance", myPeer, peerNode.getPeer());
                        ScannerRunnable runnable = new ScannerRunnable(this.model.getScanner(), peerNode);
                        Protocol.invokeLater((Runnable)runnable);
                    }
                } else {
                    peerNode.setProperty("instance", peer);
                    ScannerRunnable runnable = new ScannerRunnable(this.model.getScanner(), peerNode);
                    Protocol.invokeLater((Runnable)runnable);
                }
            }
        }
    }

    public void peerChanged(IPeer peer) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        if (peer != null) {
            AtomicBoolean guard = this.PEER_CHANGED_GUARDIANS.get(peer);
            if (guard != null && guard.get()) {
                return;
            }
            if (guard != null) {
                guard.set(true);
            } else {
                this.PEER_CHANGED_GUARDIANS.put(peer, new AtomicBoolean(true));
            }
        }
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorListener")) {
            CoreBundleActivator.getTraceHandler().trace("LocatorListener.peerChanged( " + (peer != null ? peer.getID() : null) + " )", "trace/locatorListener", (Object)this);
        }
        if (this.model != null && peer != null) {
            IPeer oldPeer;
            String clientID;
            IPeerModel peerNode = this.model.getService(ILocatorModelLookupService.class).lkupPeerModelById(peer.getID());
            if (peerNode == null && (clientID = (String)peer.getAttributes().get("ClientID")) != null) {
                peerNode = this.model.getService(ILocatorModelLookupService.class).lkupPeerModelById(clientID);
            }
            if (peerNode != null && (oldPeer = peerNode.getPeer()) != peer) {
                if (oldPeer instanceof AbstractPeer) {
                    peerNode.setProperty("instance", peer);
                } else {
                    IPeer myPeer = this.model.validatePeer(peer);
                    if (myPeer != null) {
                        boolean changed = peerNode.setChangeEventsEnabled(false);
                        this.model.getService(ILocatorModelUpdateService.class).mergeUserDefinedAttributes(peerNode, myPeer, true);
                        if (changed) {
                            peerNode.setChangeEventsEnabled(true);
                        }
                        peerNode.fireChangeEvent("instance", myPeer, peerNode.getPeer());
                    }
                }
            }
            this.model.getService(ILocatorModelRefreshService.class).refreshStaticPeers();
        }
        if (peer != null) {
            this.PEER_CHANGED_GUARDIANS.remove(peer);
        }
    }

    public void peerRemoved(String id) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorListener")) {
            CoreBundleActivator.getTraceHandler().trace("LocatorListener.peerRemoved( " + id + " )", "trace/locatorListener", (Object)this);
        }
        if (this.model != null && id != null) {
            IPeerModel peerNode = this.model.getService(ILocatorModelLookupService.class).lkupPeerModelById(id);
            if (peerNode == null) {
                int beginIndex = id.indexOf(58);
                int endIndex = id.lastIndexOf(58);
                String ip = id.substring(beginIndex + 1, endIndex);
                String loopback = IPAddressUtil.getInstance().getIPv4LoopbackAddress();
                if ("".equals(ip)) {
                    ip = loopback;
                } else if (IPAddressUtil.getInstance().isLocalHost(ip)) {
                    ip = loopback;
                }
                StringBuilder newId = new StringBuilder();
                newId.append(id.substring(0, beginIndex));
                newId.append(':');
                newId.append(ip);
                newId.append(':');
                newId.append(id.substring(endIndex + 1));
                peerNode = this.model.getService(ILocatorModelLookupService.class).lkupPeerModelById(newId.toString());
            }
            if (peerNode != null) {
                if (peerNode.isStatic()) {
                    Map peers;
                    IPeer remotePeer;
                    boolean changed = peerNode.setChangeEventsEnabled(false);
                    IPeer peer = peerNode.getPeer();
                    HashMap<String, String> attrs = new HashMap<String, String>(peerNode.getPeer().getAttributes());
                    String remotePeerID = (String)attrs.get("remote.id.transient");
                    String merged = (String)attrs.remove("remote.merged.transient");
                    if (merged != null) {
                        String[] keys;
                        merged = merged.replace('[', ' ').replace(']', ' ').trim();
                        List<String> keysToRemove = Arrays.asList(merged.split(",\\ "));
                        String[] stringArray = keys = attrs.keySet().toArray(new String[attrs.keySet().size()]);
                        int n = keys.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String key = stringArray[n2];
                            if (keysToRemove.contains(key)) {
                                attrs.remove(key);
                            }
                            ++n2;
                        }
                        if (attrs.get("ID") == null) {
                            attrs.put("ID", peer.getID());
                        }
                        if (peer instanceof PeerRedirector) {
                            ((PeerRedirector)peer).updateAttributes(attrs);
                        } else if (peer instanceof Peer) {
                            ((Peer)peer).updateAttributes(attrs);
                        }
                    }
                    peerNode.setProperty("services.local", null);
                    peerNode.setProperty("services.remote", null);
                    if (remotePeerID != null && (remotePeer = (IPeer)(peers = Protocol.getLocator().getPeers()).get(remotePeerID)) instanceof AbstractPeer) {
                        ((AbstractPeer)remotePeer).dispose();
                    }
                    peerNode.getModel().setChildren(peerNode.getPeerId(), null);
                    if (changed) {
                        peerNode.setChangeEventsEnabled(true);
                    }
                    peerNode.fireChangeEvent("instance", peer, peerNode.getPeer());
                    final IModelListener[] listeners = this.model.getListener();
                    if (listeners.length > 0) {
                        final IPeerModel finPeerNode = peerNode;
                        Protocol.invokeLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                IModelListener[] iModelListenerArray = listeners;
                                int n = listeners.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IModelListener listener = iModelListenerArray[n2];
                                    listener.locatorModelChanged(LocatorListener.this.model, finPeerNode, false);
                                    ++n2;
                                }
                            }
                        });
                    }
                } else {
                    this.model.getService(ILocatorModelUpdateService.class).remove(peerNode);
                }
            }
        }
    }

    public void peerHeartBeat(String id) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorListener")) {
            CoreBundleActivator.getTraceHandler().trace("LocatorListener.peerHeartBeat( " + id + " )", "trace/locatorListener", (Object)this);
        }
    }
}

