/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.editor.sections;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelPeerNodeQueryService;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;
import org.eclipse.tcf.te.ui.forms.parts.AbstractSection;
import org.eclipse.tcf.te.ui.swt.DisplayUtil;
import org.eclipse.tcf.te.ui.swt.SWTControlUtil;
import org.eclipse.tcf.te.ui.views.editor.pages.AbstractEditorPage;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ServicesSection
extends AbstractSection {
    Text local;
    Text remote;
    IPeerModel od;
    final IPropertiesContainer odc = new PropertiesContainer();
    private boolean servicesQueryTriggered = false;

    public ServicesSection(IManagedForm form, Composite parent) {
        super(form, parent, 130);
        this.createClient(this.getSection(), form.getToolkit());
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        Assert.isNotNull((Object)section);
        Assert.isNotNull((Object)toolkit);
        section.setText(Messages.ServicesSection_title);
        section.setDescription(Messages.ServicesSection_description);
        if (section.getParent().getLayout() instanceof GridLayout) {
            section.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        }
        Composite client = this.createClientContainer((Composite)section, 1, toolkit);
        Assert.isNotNull((Object)client);
        section.setClient((Control)client);
        Group group = new Group(client, 0);
        group.setText(Messages.ServicesSection_group_local_title);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.local = new Text((Composite)group, 74);
        GridData layoutData = new GridData(4, 0x1000000, true, false);
        layoutData.widthHint = SWTControlUtil.convertWidthInCharsToPixels((Control)this.local, (int)20);
        layoutData.heightHint = SWTControlUtil.convertHeightInCharsToPixels((Control)this.local, (int)5);
        this.local.setLayoutData((Object)layoutData);
        group = new Group(client, 0);
        group.setText(Messages.ServicesSection_group_remote_title);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.remote = new Text((Composite)group, 74);
        layoutData = new GridData(4, 0x1000000, true, false);
        layoutData.widthHint = SWTControlUtil.convertWidthInCharsToPixels((Control)this.local, (int)20);
        layoutData.heightHint = SWTControlUtil.convertHeightInCharsToPixels((Control)this.remote, (int)5);
        this.remote.setLayoutData((Object)layoutData);
        this.setIsUpdating(false);
    }

    public void setActive(boolean active) {
        Object node;
        if (active && this.getManagedForm().getContainer() instanceof AbstractEditorPage && !((AbstractEditorPage)this.getManagedForm().getContainer()).isDirty() && (node = ((AbstractEditorPage)this.getManagedForm().getContainer()).getEditorInputNode()) instanceof IPeerModel) {
            this.setupData((IPeerModel)node);
        }
    }

    public void setupData(final IPeerModel node) {
        if (this.od != node) {
            this.servicesQueryTriggered = false;
        }
        PropertiesContainer previousOdc = new PropertiesContainer();
        previousOdc.setProperties(this.odc.getProperties());
        this.od = node;
        this.odc.clearProperties();
        if (node == null) {
            return;
        }
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                ServicesSection.this.odc.setProperties(ServicesSection.this.od.getProperties());
            }
        });
        boolean forceQuery = false;
        if (!previousOdc.getProperties().equals(this.odc.getProperties())) {
            this.servicesQueryTriggered = false;
            forceQuery = true;
        }
        final AtomicBoolean fireRefreshTabs = new AtomicBoolean();
        final Runnable uiRunnable = new Runnable(){

            @Override
            public void run() {
                boolean fireNotification = fireRefreshTabs.get();
                String value = ServicesSection.this.odc.getStringProperty("services.local");
                fireNotification |= value != null && !value.equals(SWTControlUtil.getText((Control)ServicesSection.this.local));
                SWTControlUtil.setText((Control)ServicesSection.this.local, (String)(value != null ? value : ""));
                value = ServicesSection.this.odc.getStringProperty("services.remote");
                boolean bl = value != null && !value.equals(SWTControlUtil.getText((Control)ServicesSection.this.remote));
                SWTControlUtil.setText((Control)ServicesSection.this.remote, (String)(value != null ? value : ""));
                if (fireNotification |= bl) {
                    ServicesSection.this.od.fireChangeEvent("editor.refreshTab", (Object)Boolean.FALSE, (Object)Boolean.TRUE);
                }
            }
        };
        if (!this.servicesQueryTriggered) {
            this.servicesQueryTriggered = true;
            final boolean finForceQuery = forceQuery;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    boolean doQuery;
                    boolean bl = doQuery = finForceQuery || !node.containsKey("services.remote") && !node.containsKey("services.local");
                    if (doQuery) {
                        ILocatorModelPeerNodeQueryService service = (ILocatorModelPeerNodeQueryService)node.getModel().getService(ILocatorModelPeerNodeQueryService.class);
                        if (service != null) {
                            service.queryServicesAsync(node, new ILocatorModelPeerNodeQueryService.DoneQueryServices(){

                                public void doneQueryServices(Throwable error) {
                                    (this).ServicesSection.this.odc.setProperty("services.remote", node.getProperty("services.remote"));
                                    (this).ServicesSection.this.odc.setProperty("services.local", node.getProperty("services.local"));
                                    fireRefreshTabs.set(true);
                                    DisplayUtil.safeAsyncExec((Runnable)uiRunnable);
                                }
                            });
                        }
                    } else {
                        ServicesSection.this.odc.setProperties(node.getProperties());
                        DisplayUtil.safeAsyncExec((Runnable)uiRunnable);
                    }
                }
            };
            Protocol.invokeLater((Runnable)runnable);
        } else {
            uiRunnable.run();
        }
    }
}

