/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.navigator;

import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.services.interfaces.IAdapterService;
import org.eclipse.tcf.te.tcf.locator.interfaces.IModelListener;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.listener.ModelAdapter;
import org.eclipse.tcf.te.ui.views.editor.EditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonViewer;

public class ModelListener
extends ModelAdapter {
    private final ILocatorModel parentModel;
    final CommonViewer viewer;

    public ModelListener(ILocatorModel parent, CommonViewer viewer) {
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)viewer);
        this.parentModel = parent;
        this.viewer = viewer;
    }

    public void locatorModelChanged(ILocatorModel model, final IPeerModel peerModel, boolean added) {
        if (this.parentModel.equals(model)) {
            Tree tree = this.viewer.getTree();
            if (tree != null && !tree.isDisposed()) {
                Display display = tree.getDisplay();
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (ModelListener.this.viewer.getTree() != null && !ModelListener.this.viewer.getTree().isDisposed()) {
                            ModelListener.this.viewer.refresh();
                        }
                    }
                });
            }
            if (peerModel != null) {
                Display display;
                IModelListener listener;
                IAdapterService service = (IAdapterService)ServiceManager.getInstance().getService((Object)peerModel, IAdapterService.class);
                IModelListener iModelListener = listener = service != null ? (IModelListener)service.getAdapter((Object)peerModel, IModelListener.class) : null;
                if (listener != null) {
                    listener.locatorModelChanged(model, peerModel, added);
                } else if (!(added || peerModel.isStatic() || (display = PlatformUI.getWorkbench().getDisplay()) == null || display.isDisposed())) {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            EditorInput input;
                            IWorkbenchPage page;
                            IEditorReference[] editors;
                            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            if (window != null && (editors = (page = window.getActivePage()).findEditors((IEditorInput)(input = new EditorInput((Object)peerModel)), "org.eclipse.tcf.te.ui.views.Editor", 1)) != null && editors.length > 0) {
                                page.closeEditors(editors, true);
                            }
                        }
                    });
                }
            }
        }
    }
}

