/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.navigator.images;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.ui.jface.images.AbstractImageDescriptor;

public class PeerImageDescriptor
extends AbstractImageDescriptor {
    private Image baseImage;
    private Point imageSize;
    private int state;

    public PeerImageDescriptor(ImageRegistry registry, Image baseImage, final IPeerModel node) {
        super(registry);
        this.baseImage = baseImage;
        this.imageSize = new Point(baseImage.getImageData().width, baseImage.getImageData().height);
        if (Protocol.isDispatchThread()) {
            this.initialize(node);
        } else {
            Protocol.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    PeerImageDescriptor.this.initialize(node);
                }
            });
        }
        this.defineKey(baseImage.hashCode());
    }

    protected void initialize(IPeerModel node) {
        Assert.isNotNull((Object)node);
        Assert.isTrue((boolean)Protocol.isDispatchThread());
        this.state = node.getIntProperty("state");
    }

    protected void defineKey(int hashCode) {
        String key = "PMID:" + hashCode + ":" + this.state;
        this.setDecriptorKey(key);
    }

    protected void drawCompositeImage(int width, int height) {
        this.drawCentered(this.baseImage, width, height);
        if (this.state == 2) {
            this.drawBottomRight("RedOverlay");
        } else if (this.state == 3) {
            this.drawBottomRight("RedXOverlay");
        }
    }

    protected Point getSize() {
        return this.imageSize;
    }

    protected Image getBaseImage() {
        return this.baseImage;
    }
}

