/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.controls;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tcf.te.ui.controls.AbstractDecoratedDialogPageControl;
import org.eclipse.tcf.te.ui.controls.nls.Messages;
import org.eclipse.tcf.te.ui.controls.validator.Validator;
import org.eclipse.tcf.te.ui.jface.interfaces.IValidatingContainer;
import org.eclipse.tcf.te.ui.swt.SWTControlUtil;
import org.eclipse.tcf.te.ui.utils.DialogSettingsUtil;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class BaseEditBrowseTextControl
extends AbstractDecoratedDialogPageControl
implements SelectionListener,
ModifyListener {
    private boolean isGroup = true;
    private boolean hasHistroy = true;
    private boolean isReadOnly = false;
    private boolean labelIsButton = false;
    private int labelButtonStyle = 16;
    private boolean parentControlIsInnerPanel = false;
    private boolean hideBrowseButton = false;
    private boolean hideEditFieldControl = false;
    private boolean hideEditFieldControlDecoration = false;
    private boolean hideLabelControl = false;
    private boolean adjustBackgroundColor = false;
    private boolean restoreHistoryChangesEditFieldControl = false;
    boolean isInitializing = true;
    private String groupLabel = "";
    private String editFieldLabelTooltip = null;
    private String editFieldLabel = "";
    private String buttonLabel = Messages.BaseEditBrowseTextControl_button_label;
    private Composite innerPanel;
    private Control labelControl;
    private Control editFieldControl;
    private Button buttonControl;
    private String dialogSettingsSlotId;
    private Validator editFieldValidator;

    public BaseEditBrowseTextControl(IDialogPage parentPage) {
        super(parentPage);
        this.setAdjustBackgroundColor(parentPage != null);
    }

    public final void setIsGroup(boolean isGroup) {
        this.isGroup = isGroup;
    }

    public final boolean isGroup() {
        return this.isGroup;
    }

    public void setHasHistory(boolean hasHistory) {
        this.hasHistroy = hasHistory;
    }

    public final boolean hasHistory() {
        return this.hasHistroy;
    }

    public final void setReadOnly(boolean readOnly) {
        this.isReadOnly = readOnly;
    }

    public final boolean isReadOnly() {
        return this.isReadOnly;
    }

    public final void setHideLabelControl(boolean hide) {
        this.hideLabelControl = hide;
    }

    public final boolean isHideLabelControl() {
        return this.hideLabelControl;
    }

    public final void setHideEditFieldControl(boolean hide) {
        this.hideEditFieldControl = hide;
        if (hide) {
            this.setHideBrowseButton(hide);
            this.setHideEditFieldControlDecoration(hide);
        }
    }

    public final boolean isHideEditFieldControl() {
        return this.hideEditFieldControl;
    }

    public final void setHideEditFieldControlDecoration(boolean hide) {
        this.hideEditFieldControlDecoration = hide;
    }

    public final boolean isHideEditFieldControlDecoration() {
        return this.hideEditFieldControlDecoration;
    }

    public final void setHideBrowseButton(boolean hide) {
        this.hideBrowseButton = hide;
    }

    public final boolean isHideBrowseButton() {
        return this.hideBrowseButton;
    }

    public final void setAdjustBackgroundColor(boolean adjust) {
        this.adjustBackgroundColor = adjust;
    }

    public final boolean isAdjustBackgroundColor() {
        return this.adjustBackgroundColor;
    }

    public final void setRestoreHistoryChangesEditFieldControl(boolean change) {
        this.restoreHistoryChangesEditFieldControl = change;
    }

    public final boolean isRestoreHistoryChangesEditFieldControl() {
        return this.restoreHistoryChangesEditFieldControl;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        SWTControlUtil.setEnabled((Control)this.getLabelControl(), (boolean)enabled);
        SWTControlUtil.setEnabled((Control)this.getEditFieldControl(), (enabled && (!this.isLabelIsButton() || this.isLabelControlSelected()) ? 1 : 0) != 0);
        SWTControlUtil.setEnabled((Control)this.getButtonControl(), (enabled && (!this.isLabelIsButton() || this.isLabelControlSelected()) ? 1 : 0) != 0);
        if (this.getControlDecoration() != null) {
            if (enabled && this.getControlDecoration().getDescriptionText() != null) {
                this.getControlDecoration().show();
            } else {
                this.getControlDecoration().hide();
            }
        }
    }

    public void setVisible(boolean visible) {
        SWTControlUtil.setEnabled((Control)this.getLabelControl(), (boolean)visible);
        SWTControlUtil.setEnabled((Control)this.getEditFieldControl(), (boolean)visible);
        SWTControlUtil.setEnabled((Control)this.getButtonControl(), (boolean)visible);
    }

    public final void setParentControlIsInnerPanel(boolean parentIsInnerPanel) {
        this.parentControlIsInnerPanel = parentIsInnerPanel;
    }

    public final boolean isParentControlIsInnerPanel() {
        return this.parentControlIsInnerPanel;
    }

    public final void setGroupLabel(String groupLabel) {
        this.groupLabel = groupLabel != null ? groupLabel : "";
    }

    public final String getGroupLabel() {
        return this.groupLabel;
    }

    public final void setEditFieldLabelTooltip(String tooltip) {
        this.editFieldLabelTooltip = tooltip;
        SWTControlUtil.setToolTipText((Control)this.getLabelControl(), (String)this.editFieldLabelTooltip);
    }

    public final String getEditFieldLabelTooltip() {
        return this.editFieldLabelTooltip;
    }

    public final void setEditFieldLabel(String label) {
        this.editFieldLabel = label != null ? label : "";
        this.setLabelControlText(label);
    }

    public final String getEditFieldLabel() {
        return this.editFieldLabel;
    }

    public final void setButtonLabel(String label) {
        this.buttonLabel = label != null ? label : "";
    }

    public final String getButtonLabel() {
        return this.buttonLabel;
    }

    public final void setLabelIsButton(boolean isRadioButton) {
        this.labelIsButton = isRadioButton;
    }

    public final boolean isLabelIsButton() {
        return this.labelIsButton;
    }

    public final void setLabelButtonStyle(int style) {
        this.labelButtonStyle = style;
    }

    public int getLabelButtonStyle() {
        return this.labelButtonStyle;
    }

    public final Composite getInnerPanelComposite() {
        return this.innerPanel;
    }

    protected Composite doCreateInnerPanelComposite(Composite parent) {
        Assert.isNotNull((Object)parent);
        Group innerPanel = null;
        FormToolkit toolkit = this.getFormToolkit();
        if (this.isGroup()) {
            innerPanel = new Group(parent, 0);
            if (toolkit != null) {
                toolkit.adapt((Composite)innerPanel);
            }
            innerPanel.setText(this.getGroupLabel());
        } else {
            innerPanel = toolkit != null ? toolkit.createComposite(parent) : new Composite(parent, 0);
        }
        return innerPanel;
    }

    protected void configureInnerPanelComposite(Composite innerPanel) {
        Assert.isNotNull((Object)innerPanel);
        if (this.isAdjustBackgroundColor()) {
            SWTControlUtil.setBackground((Control)innerPanel, (Color)innerPanel.getParent().getBackground());
        }
        int numColumns = 3;
        if (this.isHideLabelControl()) {
            --numColumns;
        }
        if (this.isHideEditFieldControl()) {
            --numColumns;
        }
        if (this.isHideBrowseButton()) {
            --numColumns;
        }
        GridLayout layout = new GridLayout(numColumns, false);
        if (!(innerPanel instanceof Group)) {
            layout.marginHeight = 0;
            layout.marginWidth = 0;
        }
        innerPanel.setLayout((Layout)layout);
        innerPanel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    protected void doAdjustInnerPanelLayout(GridLayout layout) {
        Assert.isNotNull((Object)layout);
    }

    public Control getLabelControl() {
        return this.labelControl;
    }

    protected Control doCreateLabelControl(Composite parent) {
        Assert.isNotNull((Object)parent);
        Label labelControl = null;
        FormToolkit toolkit = this.getFormToolkit();
        if (!this.isLabelIsButton()) {
            labelControl = toolkit != null ? toolkit.createLabel(parent, null) : new Label(parent, 0);
        } else {
            labelControl = toolkit != null ? toolkit.createButton(parent, null, this.getLabelButtonStyle()) : new Button(parent, this.getLabelButtonStyle());
            SWTControlUtil.setSelection((Button)((Button)labelControl), (boolean)false);
        }
        SWTControlUtil.setText((Control)labelControl, (String)this.getEditFieldLabel());
        return labelControl;
    }

    protected void configureLabelControl(Control labelControl) {
        Assert.isNotNull((Object)labelControl);
        if (this.isAdjustBackgroundColor()) {
            SWTControlUtil.setBackground((Control)labelControl, (Color)labelControl.getParent().getBackground());
        }
        if (this.isLabelIsButton() && labelControl instanceof Button) {
            ((Button)labelControl).addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BaseEditBrowseTextControl.this.onLabelControlSelectedChanged();
                }
            });
        }
        SWTControlUtil.setToolTipText((Control)labelControl, (String)this.getEditFieldLabelTooltip());
    }

    protected void doAdjustLabelControlLayoutData() {
        Object data;
        int style = this.getEditFieldControl().getStyle();
        if ((style & 2) != 0 && ((data = this.getLabelControl().getLayoutData()) == null || data instanceof GridData)) {
            GridData layoutData = data != null ? (GridData)data : new GridData();
            layoutData.verticalAlignment = 128;
            this.getLabelControl().setLayoutData((Object)layoutData);
        }
    }

    protected void onLabelControlSelectedChanged() {
        if (this.isLabelIsButton() && this.labelControl instanceof Button) {
            if (((Button)this.labelControl).getSelection()) {
                SWTControlUtil.setEnabled((Control)this.getEditFieldControl(), (boolean)true);
                SWTControlUtil.setEnabled((Control)this.getButtonControl(), (boolean)true);
            } else {
                SWTControlUtil.setEnabled((Control)this.getEditFieldControl(), (boolean)false);
                SWTControlUtil.setEnabled((Control)this.getButtonControl(), (boolean)false);
            }
            IValidatingContainer validatingContainer = this.getValidatingContainer();
            if (validatingContainer != null) {
                validatingContainer.validate();
            }
        }
    }

    public void setLabelControlSelection(boolean selected) {
        if (this.isLabelIsButton() && this.labelControl instanceof Button) {
            SWTControlUtil.setSelection((Button)((Button)this.labelControl), (boolean)selected);
            this.onLabelControlSelectedChanged();
        }
    }

    public boolean isLabelControlSelected() {
        if (this.isLabelIsButton() && this.labelControl instanceof Button) {
            return SWTControlUtil.getSelection((Button)((Button)this.labelControl));
        }
        return true;
    }

    public String getLabelControlText() {
        String value = SWTControlUtil.getText((Control)this.labelControl);
        if (value == null) {
            value = "";
        }
        return value;
    }

    public void setLabelControlText(String text) {
        SWTControlUtil.setText((Control)this.labelControl, (String)text);
    }

    public Control getEditFieldControl() {
        return this.editFieldControl;
    }

    protected int doAdjustEditFieldControlStyles(int style) {
        return style;
    }

    protected void doAdjustEditFieldControlLayoutData(GridData layoutData) {
        Assert.isNotNull((Object)layoutData);
        if (this.getControlDecoration() != null) {
            layoutData.horizontalIndent = FieldDecorationRegistry.getDefault().getMaximumDecorationWidth();
        }
        layoutData.horizontalSpan = this.calculateEditFieldControlHorizontalSpan();
        if (this.isAdjustEditFieldControlWidthHint()) {
            int wHint;
            Point parentSize;
            layoutData.widthHint = SWTControlUtil.convertWidthInCharsToPixels((Control)this.getEditFieldControl(), (int)50);
            Composite parent = this.getParentControl();
            if (parent != null && (parentSize = parent.computeSize(wHint = parent.getLayoutData() instanceof GridData ? ((GridData)parent.getLayoutData()).widthHint : -1, -1, false)) != null) {
                layoutData.widthHint = 85 * parentSize.x / 100;
                if (parent.getLayoutData() instanceof GridData) {
                    ((GridData)parent.getLayoutData()).widthHint = parentSize.x;
                }
            }
        }
    }

    protected boolean isAdjustEditFieldControlWidthHint() {
        return false;
    }

    protected Control doCreateEditFieldControl(Composite parent) {
        Combo editField;
        Assert.isNotNull((Object)parent);
        FormToolkit toolkit = this.getFormToolkit();
        if (this.hasHistory()) {
            int style = 4;
            if (this.isReadOnly()) {
                style |= 8;
            }
            editField = new Combo(parent, this.doAdjustEditFieldControlStyles(style));
            if (toolkit != null) {
                toolkit.adapt((Composite)editField);
            }
            editField.addModifyListener(new ModifyListener((Scrollable)editField){
                private final /* synthetic */ Scrollable val$editField;
                {
                    this.val$editField = scrollable;
                }

                public void modifyText(ModifyEvent e) {
                    if (!BaseEditBrowseTextControl.this.isInitializing) {
                        SWTControlUtil.setValueToolTip((Scrollable)this.val$editField);
                    }
                }
            });
            editField.addSelectionListener((SelectionListener)new SelectionAdapter((Scrollable)editField){
                private final /* synthetic */ Scrollable val$editField;
                {
                    this.val$editField = scrollable;
                }

                public void widgetSelected(SelectionEvent e) {
                    if (!BaseEditBrowseTextControl.this.isInitializing) {
                        SWTControlUtil.setValueToolTip((Scrollable)this.val$editField);
                    }
                }
            });
            editField.addPaintListener(new PaintListener((Scrollable)editField){
                private final /* synthetic */ Scrollable val$editField;
                {
                    this.val$editField = scrollable;
                }

                public void paintControl(PaintEvent e) {
                    if (!BaseEditBrowseTextControl.this.isInitializing) {
                        SWTControlUtil.setValueToolTip((Scrollable)this.val$editField);
                    }
                }
            });
        } else {
            int style = 4;
            if (this.isReadOnly()) {
                style |= 8;
            }
            editField = toolkit != null ? toolkit.createText(parent, null, this.doAdjustEditFieldControlStyles(0x800 | style)) : new Text(parent, this.doAdjustEditFieldControlStyles(0x800 | style));
            ((Text)editField).addModifyListener(new ModifyListener((Scrollable)editField){
                private final /* synthetic */ Scrollable val$editField;
                {
                    this.val$editField = scrollable;
                }

                public void modifyText(ModifyEvent e) {
                    if (!BaseEditBrowseTextControl.this.isInitializing) {
                        SWTControlUtil.setValueToolTip((Scrollable)this.val$editField);
                    }
                }
            });
            ((Text)editField).addPaintListener(new PaintListener((Scrollable)editField){
                private final /* synthetic */ Scrollable val$editField;
                {
                    this.val$editField = scrollable;
                }

                public void paintControl(PaintEvent e) {
                    if (!BaseEditBrowseTextControl.this.isInitializing) {
                        SWTControlUtil.setValueToolTip((Scrollable)this.val$editField);
                    }
                }
            });
        }
        return editField;
    }

    protected void configureEditFieldControl(Control control) {
        Assert.isNotNull((Object)control);
        GridData layoutData = new GridData(4, 0x1000000, true, false);
        this.doAdjustEditFieldControlLayoutData(layoutData);
        control.setLayoutData((Object)layoutData);
        this.doAdjustLabelControlLayoutData();
        ModifyListener modifyListener = this.doGetEditFieldControlModifyListener();
        VerifyListener verifyListener = this.doGetEditFieldControlVerifyListener();
        SelectionListener selectionListener = this.doGetEditFieldControlSelectionListener();
        if (control instanceof Text) {
            if (modifyListener != null) {
                ((Text)control).addModifyListener(modifyListener);
            }
            if (verifyListener != null) {
                ((Text)control).addVerifyListener(verifyListener);
            }
        }
        if (control instanceof Combo) {
            if (modifyListener != null) {
                ((Combo)control).addModifyListener(modifyListener);
            }
            if (verifyListener != null) {
                ((Combo)control).addVerifyListener(verifyListener);
            }
            if (selectionListener != null) {
                ((Combo)control).addSelectionListener(selectionListener);
            }
        }
        if (this.isLabelIsButton()) {
            this.onLabelControlSelectedChanged();
        }
    }

    public int calculateEditFieldControlHorizontalSpan() {
        int span = 1;
        if (this.getEditFieldControl() != null && this.getEditFieldControl().getParent() != null) {
            Composite parent = this.getEditFieldControl().getParent();
            int numColumns = parent.getLayout() instanceof GridLayout ? ((GridLayout)parent.getLayout()).numColumns : 1;
            int consumed = 0;
            if (!this.isHideLabelControl()) {
                ++consumed;
            }
            if (!this.isHideEditFieldControl()) {
                ++consumed;
            }
            if (!this.isHideBrowseButton()) {
                ++consumed;
            }
            if (numColumns > consumed) {
                span = numColumns - consumed + 1;
            }
        }
        return span;
    }

    protected ModifyListener doGetEditFieldControlModifyListener() {
        return this;
    }

    public void modifyText(ModifyEvent e) {
        IValidatingContainer validatingContainer = this.getValidatingContainer();
        if (validatingContainer != null) {
            validatingContainer.validate();
        }
    }

    protected VerifyListener doGetEditFieldControlVerifyListener() {
        return null;
    }

    protected SelectionListener doGetEditFieldControlSelectionListener() {
        if (this.getEditFieldControl() instanceof Combo) {
            return this;
        }
        return null;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        IValidatingContainer validatingContainer = this.getValidatingContainer();
        if (validatingContainer != null) {
            validatingContainer.validate();
        }
    }

    public String getEditFieldControlText() {
        String value = SWTControlUtil.getText((Control)this.editFieldControl);
        return value != null ? value : "";
    }

    public String getEditFieldControlTextForValidation() {
        return this.getEditFieldControlText();
    }

    public void setEditFieldControlText(String text) {
        String oldText;
        if (text == null) {
            text = "";
        }
        if (!text.equals(oldText = SWTControlUtil.getText((Control)this.editFieldControl))) {
            SWTControlUtil.setText((Control)this.editFieldControl, (String)text);
        }
    }

    public void setEditFieldControlHistory(String[] historyEntries) {
        Assert.isNotNull((Object)historyEntries);
        if (this.hasHistory() && this.getEditFieldControl() instanceof Combo) {
            Combo combo = (Combo)this.getEditFieldControl();
            ArrayList<String> oldItems = new ArrayList<String>(Arrays.asList(SWTControlUtil.getItems((Control)combo)));
            ArrayList<String> newItems = new ArrayList<String>();
            String oldSelectedItem = this.getEditFieldControlText();
            String[] stringArray = historyEntries;
            int n = historyEntries.length;
            int n2 = 0;
            while (n2 < n) {
                String entry = stringArray[n2];
                if (entry != null && entry.trim().length() != 0 && !newItems.contains(entry)) {
                    newItems.add(entry);
                }
                ++n2;
            }
            String[] newItemsArray = newItems.toArray(new String[newItems.size()]);
            Collections.sort(oldItems);
            Collections.sort(newItems);
            if (!newItems.equals(oldItems)) {
                SWTControlUtil.setItems((Control)combo, (String[])newItemsArray);
            }
            if (newItems.contains(oldSelectedItem) || !oldItems.contains(oldSelectedItem)) {
                this.setEditFieldControlText(oldSelectedItem);
            }
        }
    }

    public void addToEditFieldControlHistory(String entry) {
        if (this.hasHistory() && this.getEditFieldControl() instanceof Combo) {
            Combo combo = (Combo)this.getEditFieldControl();
            if (entry != null && entry.trim().length() > 0 && combo.indexOf(entry) == -1) {
                combo.add(entry);
            }
        }
    }

    protected Validator doCreateEditFieldValidator() {
        return null;
    }

    protected void configureEditFieldValidator(Validator validator) {
    }

    public Button getButtonControl() {
        return this.buttonControl;
    }

    protected Button doCreateButtonControl(Composite parent) {
        Assert.isNotNull((Object)parent);
        FormToolkit toolkit = this.getFormToolkit();
        Button button = toolkit != null ? toolkit.createButton(parent, null, 8) : new Button(parent, 8);
        button.setText(" " + this.getButtonLabel().trim() + " ");
        return button;
    }

    protected void configureButtonControl(Button button) {
        Assert.isNotNull((Object)button);
        if (this.isAdjustBackgroundColor()) {
            SWTControlUtil.setBackground((Control)button, (Color)button.getParent().getBackground());
        }
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseEditBrowseTextControl.this.onButtonControlSelected();
            }
        });
        if (button.getLayoutData() == null) {
            GridData layoutData = new GridData(4, 0x1000000, false, false);
            layoutData.widthHint = SWTControlUtil.convertWidthInCharsToPixels((Control)button, (int)(SWTControlUtil.getText((Control)button).length() + 4));
            button.setLayoutData((Object)layoutData);
        }
    }

    protected void onButtonControlSelected() {
    }

    protected Object getTopMostCompositeLayoutData(Layout parentLayout) {
        GridData layoutData = new GridData(4, 0x1000000, true, false);
        if (parentLayout instanceof GridLayout) {
            layoutData.horizontalSpan = ((GridLayout)parentLayout).numColumns;
        }
        return layoutData;
    }

    @Override
    public void setupPanel(Composite parent) {
        GridLayout layout;
        this.isInitializing = true;
        super.setupPanel(parent);
        FormToolkit toolkit = this.getFormToolkit();
        if (!this.isParentControlIsInnerPanel() || !(parent.getLayout() instanceof GridLayout)) {
            Composite composite;
            Composite composite2 = composite = toolkit != null ? toolkit.createComposite(parent) : new Composite(parent, 0);
            if (this.isAdjustBackgroundColor()) {
                SWTControlUtil.setBackground((Control)composite, (Color)parent.getBackground());
            }
            composite.setLayoutData(this.getTopMostCompositeLayoutData(parent.getLayout()));
            layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            composite.setLayout((Layout)layout);
            this.innerPanel = this.doCreateInnerPanelComposite(composite);
            this.configureInnerPanelComposite(this.innerPanel);
        } else {
            this.innerPanel = parent;
        }
        if (this.innerPanel.getLayout() instanceof GridLayout) {
            this.doAdjustInnerPanelLayout((GridLayout)this.innerPanel.getLayout());
        }
        if (!this.isHideLabelControl()) {
            this.labelControl = this.doCreateLabelControl(this.innerPanel);
            this.configureLabelControl(this.labelControl);
        }
        Composite innerInnerPanel = this.innerPanel;
        if (((GridLayout)innerInnerPanel.getLayout()).numColumns == 2 && !this.isHideBrowseButton() && !this.isHideEditFieldControl()) {
            Composite composite = innerInnerPanel = toolkit != null ? toolkit.createComposite(this.innerPanel) : new Composite(this.innerPanel, 0);
            if (this.isAdjustBackgroundColor()) {
                SWTControlUtil.setBackground((Control)innerInnerPanel, (Color)this.innerPanel.getBackground());
            }
            layout = new GridLayout(2, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            innerInnerPanel.setLayout((Layout)layout);
            innerInnerPanel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        }
        if (!this.isHideEditFieldControl()) {
            this.editFieldControl = this.doCreateEditFieldControl(innerInnerPanel);
            Assert.isNotNull((Object)this.editFieldControl);
            if (!this.isHideEditFieldControlDecoration()) {
                ControlDecoration controlDecoration = this.doCreateControlDecoration(this.editFieldControl);
                Assert.isNotNull((Object)controlDecoration);
                this.configureControlDecoration(controlDecoration);
            }
            this.configureEditFieldControl(this.editFieldControl);
            this.setEditFieldValidator(this.doCreateEditFieldValidator());
            this.configureEditFieldValidator(this.getEditFieldValidator());
        }
        if (!this.isHideBrowseButton()) {
            this.buttonControl = this.doCreateButtonControl(innerInnerPanel);
            this.configureButtonControl(this.buttonControl);
        }
        this.isValid();
        this.isInitializing = false;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.labelControl = null;
        this.editFieldControl = null;
        this.buttonControl = null;
    }

    public void setDialogSettingsSlotId(String settingsSlotId) {
        this.dialogSettingsSlotId = settingsSlotId;
    }

    public String getDialogSettingsSlotId(String prefix) {
        String settingsSlotId = this.dialogSettingsSlotId;
        if (settingsSlotId == null) {
            settingsSlotId = this.getEditFieldLabel().replace(':', ' ').trim().replace(' ', '_');
        }
        return this.prefixDialogSettingsSlotId(settingsSlotId, prefix);
    }

    @Override
    public void doRestoreWidgetValues(IDialogSettings settings, String idPrefix) {
        String[] historyEntries = this.getHistory(settings, idPrefix);
        if (historyEntries.length > 0) {
            this.setEditFieldControlHistory(historyEntries);
            if ("".equals(this.getEditFieldControlText()) && this.restoreHistoryChangesEditFieldControl) {
                this.setEditFieldControlText(historyEntries[0]);
            }
        }
    }

    protected String[] getHistory(IDialogSettings settings, String idPrefix) {
        Assert.isNotNull((Object)settings);
        if (settings != null && this.getDialogSettingsSlotId(idPrefix) != null) {
            return DialogSettingsUtil.getSettingsArraySafe((IDialogSettings)settings, (String)this.getDialogSettingsSlotId(idPrefix));
        }
        return new String[0];
    }

    @Override
    public void doSaveWidgetValues(IDialogSettings settings, String idPrefix) {
        Assert.isNotNull((Object)settings);
        if (settings != null && this.getDialogSettingsSlotId(idPrefix) != null) {
            String[] historyEntries = DialogSettingsUtil.getSettingsArraySafe((IDialogSettings)settings, (String)this.getDialogSettingsSlotId(idPrefix));
            historyEntries = DialogSettingsUtil.addToHistory((String[])historyEntries, (String)this.getEditFieldControlText());
            settings.put(this.getDialogSettingsSlotId(idPrefix), historyEntries);
        }
    }

    public final Validator getEditFieldValidator() {
        return this.editFieldValidator;
    }

    public void setEditFieldValidator(Validator editFieldValidator) {
        this.editFieldValidator = editFieldValidator;
    }

    @Override
    public boolean isValid() {
        if (this.isInitializing) {
            return true;
        }
        boolean valid = super.isValid();
        if (this.getEditFieldValidator() != null && this.getEditFieldControl() != null && !this.getEditFieldControl().isDisposed() && SWTControlUtil.isEnabled((Control)this.getEditFieldControl()) && !this.isReadOnly() && this.isLabelControlSelected()) {
            valid = this.getEditFieldValidator().isValid(this.getEditFieldControlTextForValidation());
            this.setMessage(this.getEditFieldValidator().getMessage(), this.getEditFieldValidator().getMessageType());
        }
        if (this.getControlDecoration() != null) {
            if (this.isEnabled() && (!valid || this.getMessage() != null && this.getMessageType() != 0)) {
                this.updateControlDecoration(this.getMessage(), this.getMessageType());
            } else {
                this.updateControlDecoration(null, 0);
            }
        }
        return valid;
    }
}

