/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.controls.wire;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.tcf.te.ui.controls.BaseEditBrowseTextControl;
import org.eclipse.tcf.te.ui.controls.nls.Messages;
import org.eclipse.tcf.te.ui.swt.SWTControlUtil;

public class WireTypeControl
extends BaseEditBrowseTextControl {
    private static final String[] WIRE_TYPES = new String[]{"network", "serial"};

    public WireTypeControl(IDialogPage parentPage) {
        super(parentPage);
        this.setIsGroup(false);
        this.setReadOnly(true);
        this.setHideBrowseButton(true);
        this.setEditFieldLabel(Messages.WireTypeControl_label);
    }

    @Override
    public void setupPanel(Composite parent) {
        super.setupPanel(parent);
        ArrayList<String> wireTypeLabels = new ArrayList<String>();
        String[] stringArray = WIRE_TYPES;
        int n = WIRE_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            String wireType = stringArray[n2];
            String label = this.getWireTypeLabel(wireType);
            if (label != null) {
                wireTypeLabels.add(label);
            }
            ++n2;
        }
        this.setEditFieldControlHistory(wireTypeLabels.toArray(new String[wireTypeLabels.size()]));
        SWTControlUtil.select((Control)this.getEditFieldControl(), (int)0);
    }

    public static final String[] getSupportedWireTypes() {
        return Arrays.copyOf(WIRE_TYPES, WIRE_TYPES.length);
    }

    protected String getWireTypeLabel(String wireType) {
        Assert.isNotNull((Object)wireType);
        if ("network".equals(wireType)) {
            return Messages.WireTypeControl_networkType_label;
        }
        if ("serial".equals(wireType)) {
            return Messages.WireTypeControl_serialType_label;
        }
        return null;
    }

    public String getSelectedWireType() {
        String type = this.getEditFieldControlText();
        if (Messages.WireTypeControl_networkType_label.equals(type)) {
            type = "network";
        } else if (Messages.WireTypeControl_serialType_label.equals(type)) {
            type = "serial";
        }
        return type;
    }

    public void setSelectedWireType(String wireType) {
        Assert.isNotNull((Object)wireType);
        String label = this.getWireTypeLabel(wireType);
        int index = SWTControlUtil.indexOf((Control)this.getEditFieldControl(), (String)label);
        if (index != -1) {
            SWTControlUtil.select((Control)this.getEditFieldControl(), (int)index);
        }
    }

    @Override
    public void doRestoreWidgetValues(IDialogSettings settings, String idPrefix) {
    }

    @Override
    public void doSaveWidgetValues(IDialogSettings settings, String idPrefix) {
    }
}

