/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.core.listeners;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.tcf.core.internal.utils.LogUtils;
import org.eclipse.tcf.te.tcf.core.listeners.ChannelListener;
import org.eclipse.tcf.te.tcf.core.listeners.interfaces.IChannelOpenListener;
import org.eclipse.tcf.te.tcf.core.nls.Messages;

public class ChannelOpenListener
implements IChannelOpenListener {
    private final Map<IChannel, IChannel.IChannelListener> channelListeners = new HashMap<IChannel, IChannel.IChannelListener>();

    public void onChannelOpen(IChannel channel) {
        Assert.isNotNull((Object)channel);
        Assert.isTrue((boolean)Protocol.isDispatchThread());
        LogUtils.logMessageForChannel(channel, Messages.InternalChannelOpenListener_onChannelOpen_message, "trace/channels", this);
        IChannel.IChannelListener channelListener = this.channelListeners.remove(channel);
        if (channelListener != null) {
            channel.removeChannelListener(channelListener);
        }
        channelListener = new ChannelListener(channel);
        this.setChannelListener(channel, channelListener);
        channel.addChannelListener(channelListener);
        Tcf.fireChannelStateChangeListeners(channel, 1);
    }

    @Override
    public void setChannelListener(IChannel channel, IChannel.IChannelListener listener) {
        Assert.isNotNull((Object)channel);
        if (listener != null) {
            this.channelListeners.put(channel, listener);
        } else {
            this.channelListeners.remove(channel);
        }
    }
}

