/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.commands;

import java.math.BigInteger;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.protocol.JSON;

class MemoryMapItemDialog
extends Dialog {
    private final Map<String, Object> props;
    private final boolean enable_editing;
    private final Image image;
    private Text addr_text;
    private Text size_text;
    private Text offset_text;
    private Text file_text;
    private Button rd_button;
    private Button wr_button;
    private Button ex_button;

    MemoryMapItemDialog(Shell parent, Image image, Map<String, Object> props, boolean enable_editing) {
        super(parent);
        this.image = image;
        this.props = props;
        this.enable_editing = enable_editing;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Symbol File");
        shell.setImage(this.image);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.updateButtons();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createFileNameFields(composite);
        this.createPropsFields(composite);
        this.setData();
        composite.setSize(composite.computeSize(-1, -1));
        return composite;
    }

    private void createFileNameFields(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        composite.setFont(font);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        Label file_label = new Label(composite, 64);
        file_label.setLayoutData((Object)new GridData(32));
        file_label.setFont(font);
        file_label.setText("File name:");
        this.file_text = new Text(composite, 2052);
        this.file_text.setLayoutData((Object)new GridData(768));
        this.file_text.setFont(font);
        this.file_text.setEditable(this.enable_editing);
        this.file_text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MemoryMapItemDialog.this.updateButtons();
            }
        });
        Button button = new Button(composite, 8);
        button.setFont(font);
        button.setText("...");
        button.setLayoutData((Object)new GridData(32));
        button.setEnabled(this.enable_editing);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog file_dialog = new FileDialog(MemoryMapItemDialog.this.getShell(), 0);
                file_dialog.setFileName(MemoryMapItemDialog.this.file_text.getText());
                String path = file_dialog.open();
                if (path != null) {
                    MemoryMapItemDialog.this.file_text.setText(path);
                }
            }
        });
    }

    private void createPropsFields(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setFont(font);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        this.createTextFields(composite);
        this.createFlagsGroup(composite);
    }

    private void createTextFields(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setFont(font);
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.widthHint = 250;
        composite.setLayoutData((Object)gd);
        Label addr_label = new Label(composite, 64);
        addr_label.setLayoutData((Object)new GridData(32));
        addr_label.setFont(font);
        addr_label.setText("Address:");
        this.addr_text = new Text(composite, 2052);
        this.addr_text.setLayoutData((Object)new GridData(768));
        this.addr_text.setFont(font);
        this.addr_text.setEditable(this.enable_editing);
        Label size_label = new Label(composite, 64);
        size_label.setLayoutData((Object)new GridData(32));
        size_label.setFont(font);
        size_label.setText("Size:");
        this.size_text = new Text(composite, 2052);
        this.size_text.setLayoutData((Object)new GridData(768));
        this.size_text.setFont(font);
        this.size_text.setEditable(this.enable_editing);
        Label offset_label = new Label(composite, 64);
        offset_label.setLayoutData((Object)new GridData(32));
        offset_label.setFont(font);
        offset_label.setText("File offset:");
        this.offset_text = new Text(composite, 2052);
        this.offset_text.setLayoutData((Object)new GridData(768));
        this.offset_text.setFont(font);
        this.offset_text.setEditable(this.enable_editing);
    }

    private void createFlagsGroup(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        layout.numColumns = 1;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(1808));
        group.setFont(font);
        group.setText("Flags");
        this.rd_button = new Button((Composite)group, 32);
        this.rd_button.setFont(font);
        this.rd_button.setText("Data read");
        this.rd_button.setLayoutData((Object)new GridData(768));
        this.rd_button.setEnabled(this.enable_editing);
        this.wr_button = new Button((Composite)group, 32);
        this.wr_button.setFont(font);
        this.wr_button.setText("Data write");
        this.wr_button.setLayoutData((Object)new GridData(768));
        this.wr_button.setEnabled(this.enable_editing);
        this.ex_button = new Button((Composite)group, 32);
        this.ex_button.setFont(font);
        this.ex_button.setText("Instructions read");
        this.ex_button.setLayoutData((Object)new GridData(768));
        this.ex_button.setEnabled(this.enable_editing);
    }

    private String toHex(Number n) {
        if (n == null) {
            return null;
        }
        BigInteger x = JSON.toBigInteger((Number)n);
        String s = x.toString(16);
        int l = 16 - s.length();
        if (l < 0) {
            l = 0;
        }
        if (l > 16) {
            l = 16;
        }
        return String.valueOf("0x0000000000000000".substring(0, 2 + l)) + s;
    }

    private void setText(Text text, String str) {
        if (str == null) {
            str = "";
        }
        text.setText(str);
    }

    private void setData() {
        this.setText(this.addr_text, this.toHex((Number)this.props.get("Addr")));
        this.setText(this.size_text, this.toHex((Number)this.props.get("Size")));
        if (this.props.get("SectionName") != null) {
            this.setText(this.offset_text, (String)this.props.get("SectionName"));
        } else {
            this.setText(this.offset_text, this.toHex((Number)this.props.get("Offs")));
        }
        this.setText(this.file_text, (String)this.props.get("FileName"));
        int flags = 0;
        Number n = (Number)this.props.get("Flags");
        if (n != null) {
            flags = n.intValue();
        }
        this.rd_button.setSelection((flags & 1) != 0);
        this.wr_button.setSelection((flags & 2) != 0);
        this.ex_button.setSelection((flags & 4) != 0);
        this.updateButtons();
    }

    private void getNumber(Text text, String key) {
        String s = text.getText().trim();
        if (s == null || s.length() == 0) {
            this.props.remove(key);
        } else if (s.startsWith("0x")) {
            this.props.put(key, new BigInteger(s.substring(2), 16));
        } else {
            this.props.put(key, new BigInteger(s));
        }
    }

    private void getText(Text text, String key) {
        String s = text.getText().trim();
        if (s == null || s.length() == 0) {
            this.props.remove(key);
        } else {
            this.props.put(key, s);
        }
    }

    private void getData() {
        this.getNumber(this.addr_text, "Addr");
        this.getNumber(this.size_text, "Size");
        if (this.offset_text.getText().startsWith(".")) {
            this.props.put("SectionName", this.offset_text.getText());
            this.props.remove("Offs");
        } else {
            this.getNumber(this.offset_text, "Offs");
            this.props.remove("SectionName");
        }
        this.getText(this.file_text, "FileName");
        int flags = 0;
        if (this.rd_button.getSelection()) {
            flags |= 1;
        }
        if (this.wr_button.getSelection()) {
            flags |= 2;
        }
        if (this.ex_button.getSelection()) {
            flags |= 4;
        }
        this.props.put("Flags", flags);
    }

    private void updateButtons() {
        Button btn = this.getButton(0);
        if (btn != null && this.file_text != null) {
            btn.setEnabled(!this.enable_editing || this.file_text.getText().trim().length() > 0);
        }
    }

    protected void okPressed() {
        if (this.enable_editing) {
            try {
                this.getData();
            }
            catch (Throwable x) {
                MessageBox mb = new MessageBox(this.getShell(), 33);
                mb.setText("Invalid data");
                mb.setMessage(TCFModel.getErrorMessage(x, true));
                mb.open();
                return;
            }
        }
        super.okPressed();
    }
}

