/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tcf.internal.debug.ui.Activator;
import org.eclipse.tcf.internal.debug.ui.ImageCache;

public class TCFArgumentsTab
extends AbstractLaunchConfigurationTab {
    private Text text_arguments;
    private Button button_variables;
    private Exception init_error;

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        comp.setLayout((Layout)layout);
        comp.setFont(font);
        GridData gd = new GridData(1808);
        comp.setLayoutData((Object)gd);
        this.setControl((Control)comp);
        this.createArgumentsGroup(comp);
    }

    private void createArgumentsGroup(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        comp.setLayoutData((Object)gd);
        Label label = new Label(comp, 0);
        label.setText("Program Arguments:");
        gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.text_arguments = new Text(comp, 2626);
        gd = new GridData(1808);
        gd.heightHint = 40;
        gd.widthHint = 100;
        this.text_arguments.setLayoutData((Object)gd);
        this.text_arguments.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                TCFArgumentsTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.button_variables = this.createPushButton(comp, "Variables", null);
        gd = new GridData(128);
        this.button_variables.setLayoutData((Object)gd);
        this.button_variables.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TCFArgumentsTab.this.handleVariablesButtonSelected(TCFArgumentsTab.this.text_arguments);
            }
        });
    }

    private void handleVariablesButtonSelected(Text textField) {
        String variable = this.getVariable();
        if (variable != null) {
            textField.append(variable);
        }
    }

    private String getVariable() {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
        dialog.open();
        return dialog.getVariableExpression();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("org.eclipse.tcf.debug.ProgramArguments", null);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.setErrorMessage(null);
        this.setMessage(null);
        try {
            this.text_arguments.setText(configuration.getAttribute("org.eclipse.tcf.debug.ProgramArguments", ""));
        }
        catch (CoreException e) {
            this.init_error = e;
            this.setErrorMessage("Cannot read launch configuration: " + (Object)((Object)e));
            Activator.log(e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.tcf.debug.ProgramArguments", this.getAttributeValueFrom(this.text_arguments));
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.init_error != null) {
            this.setErrorMessage("Cannot read launch configuration: " + this.init_error);
            return false;
        }
        return true;
    }

    protected String getAttributeValueFrom(Text text) {
        String content = text.getText().trim();
        if ((content = content.replaceAll("\r\n", "\n")).length() > 0) {
            return content;
        }
        return null;
    }

    public String getName() {
        return "Arguments";
    }

    public Image getImage() {
        return ImageCache.getImage("icons/arguments_tab.gif");
    }
}

