/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.model;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tcf.internal.debug.cmdline.TCFCommandLine;
import org.eclipse.tcf.internal.debug.ui.Activator;
import org.eclipse.tcf.internal.debug.ui.ImageCache;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleInputStream;
import org.eclipse.ui.console.IOConsoleOutputStream;

class TCFConsole {
    public static final int TYPE_PROCESS = 1;
    public static final int TYPE_CMD_LINE = 2;
    public static final int TYPE_DPRINTF = 3;
    private final TCFModel model;
    private final IOConsole console;
    private final Display display;
    private final String process_id;
    private final LinkedList<Message> out_queue;
    private final TCFCommandLine cmd_line;
    private final byte[] prompt = new byte[]{116, 99, 102, 62};
    private final StringBuffer cmd_buf = new StringBuffer();
    private final Thread inp_thread = new Thread(){

        @Override
        public void run() {
            try {
                int len;
                IOConsoleInputStream inp = TCFConsole.this.console.getInputStream();
                final byte[] buf = new byte[256];
                while ((len = inp.read(buf)) >= 0) {
                    if (len == 2 && buf[0] == 13 && buf[1] == 10) {
                        len = 1;
                    }
                    final int n = len;
                    Protocol.invokeAndWait((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            block13: {
                                try {
                                    if (TCFConsole.this.cmd_line != null) {
                                        String s = new String(buf, 0, n, "UTF-8");
                                        int l = s.length();
                                        int i = 0;
                                        while (i < l) {
                                            char ch = s.charAt(i);
                                            if (ch == '\r') {
                                                String res = TCFConsole.this.cmd_line.command(TCFConsole.this.cmd_buf.toString());
                                                TCFConsole.this.cmd_buf.setLength(0);
                                                if (res != null) {
                                                    if (res.length() > 0 && res.charAt(res.length() - 1) != '\n') {
                                                        res = String.valueOf(res) + '\n';
                                                    }
                                                    TCFConsole.this.write(0, res.getBytes("UTF-8"));
                                                }
                                                TCFConsole.this.write(0, TCFConsole.this.prompt);
                                            } else if (ch == '\b') {
                                                int n2 = TCFConsole.this.cmd_buf.length();
                                                if (n2 > 0) {
                                                    --n2;
                                                }
                                                TCFConsole.this.cmd_buf.setLength(n2);
                                            } else {
                                                TCFConsole.this.cmd_buf.append(ch);
                                            }
                                            ++i;
                                        }
                                    } else if (TCFConsole.this.process_id != null) {
                                        TCFConsole.this.model.getLaunch().writeProcessInputStream(TCFConsole.this.process_id, buf, 0, n);
                                    }
                                }
                                catch (Exception x) {
                                    if (TCFConsole.this.process_id == null) break block13;
                                    TCFConsole.this.model.onProcessStreamError(TCFConsole.this.process_id, 0, x, 0);
                                }
                            }
                        }
                    });
                }
            }
            catch (Throwable x) {
                Activator.log("Cannot read console input", x);
            }
        }
    };
    private final Thread out_thread = new Thread(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashMap<Integer, IOConsoleOutputStream> out_streams = new HashMap<Integer, IOConsoleOutputStream>();
            try {
                while (true) {
                    Message m = null;
                    LinkedList linkedList = TCFConsole.this.out_queue;
                    synchronized (linkedList) {
                        while (TCFConsole.this.out_queue.size() == 0) {
                            TCFConsole.this.out_queue.wait();
                        }
                        m = (Message)TCFConsole.this.out_queue.removeFirst();
                    }
                    if (m.data != null) {
                        IOConsoleOutputStream stream = (IOConsoleOutputStream)out_streams.get(m.stream_id);
                        if (stream == null) {
                            final int id = m.stream_id;
                            final IOConsoleOutputStream s = stream = TCFConsole.this.console.newOutputStream();
                            TCFConsole.this.display.syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        int color_id = 2;
                                        switch (id) {
                                            case 1: {
                                                color_id = 3;
                                                break;
                                            }
                                            case 2: {
                                                color_id = 9;
                                                break;
                                            }
                                            case 3: {
                                                color_id = 5;
                                            }
                                        }
                                        s.setColor(TCFConsole.this.display.getSystemColor(color_id));
                                    }
                                    catch (Throwable x) {
                                        Activator.log("Cannot open console view", x);
                                    }
                                }
                            });
                            out_streams.put(m.stream_id, stream);
                        }
                        stream.write(m.data, 0, m.data.length);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable x) {
                Activator.log("Cannot write console output", x);
            }
            for (IOConsoleOutputStream stream : out_streams.values()) {
                try {
                    stream.close();
                }
                catch (IOException x) {
                    Activator.log("Cannot close console stream", x);
                }
            }
            try {
                TCFConsole.this.console.getInputStream().close();
            }
            catch (IOException x) {
                Activator.log("Cannot close console stream", x);
            }
            try {
                TCFConsole.this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
                        manager.removeConsoles((IConsole[])new IOConsole[]{TCFConsole.this.console});
                    }
                });
            }
            catch (SWTException x) {
                if (x.code == 45) {
                    return;
                }
                Activator.log("Cannot remove console", x);
            }
        }
    };

    TCFConsole(TCFModel model, int type, String process_id) {
        this.model = model;
        this.process_id = process_id;
        this.display = model.getDisplay();
        this.out_queue = new LinkedList();
        String image = process_id != null ? "icons/full/obj16/debugt_obj.gif" : "icons/tcf.gif";
        String title = "TCF";
        switch (type) {
            case 1: {
                title = String.valueOf(title) + " " + process_id;
                break;
            }
            case 2: {
                title = String.valueOf(title) + " Debugger";
                break;
            }
            case 3: {
                title = String.valueOf(title) + " DPrintf";
            }
        }
        this.console = new IOConsole(title, null, ImageCache.getImageDescriptor(image), "UTF-8", true);
        TCFCommandLine tCFCommandLine = this.cmd_line = type == 2 ? new TCFCommandLine() : null;
        if (this.cmd_line != null) {
            this.write(0, this.prompt);
        }
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!PlatformUI.isWorkbenchRunning() || PlatformUI.getWorkbench().isStarting()) {
                    TCFConsole.this.display.timerExec(200, (Runnable)this);
                } else if (!PlatformUI.getWorkbench().isClosing()) {
                    try {
                        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
                        manager.addConsoles(new IConsole[]{TCFConsole.this.console});
                        IWorkbenchWindow w = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        if (w == null) {
                            return;
                        }
                        IWorkbenchPage page = w.getActivePage();
                        if (page == null) {
                            return;
                        }
                        IConsoleView view = (IConsoleView)page.showView("org.eclipse.ui.console.ConsoleView");
                        view.display((IConsole)TCFConsole.this.console);
                    }
                    catch (Throwable x) {
                        Activator.log("Cannot open console view", x);
                    }
                }
            }
        });
        this.inp_thread.setName("TCF Console Input");
        this.out_thread.setName("TCF Console Output");
        this.inp_thread.start();
        this.out_thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(int stream_id, byte[] data) {
        if (data == null || data.length == 0) {
            return;
        }
        LinkedList<Message> linkedList = this.out_queue;
        synchronized (linkedList) {
            Message m = new Message();
            m.stream_id = stream_id;
            m.data = data;
            this.out_queue.add(m);
            this.out_queue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        LinkedList<Message> linkedList = this.out_queue;
        synchronized (linkedList) {
            this.out_queue.add(new Message());
            this.out_queue.notify();
        }
    }

    private static class Message {
        int stream_id;
        byte[] data;

        private Message() {
        }
    }
}

