/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.tcf.internal.debug.ui.model.ISymbolOwner;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildren;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildrenContextQuery;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildrenExecContext;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeSymbol;
import org.eclipse.tcf.services.IMemory;
import org.eclipse.tcf.services.IRunControl;

public class TCFNodeLaunch
extends TCFNode
implements ISymbolOwner {
    private final TCFChildrenExecContext children;
    private final TCFChildren filtered_children;
    private final TCFChildrenContextQuery children_query;
    private final Map<String, TCFNodeSymbol> symbols = new HashMap<String, TCFNodeSymbol>();

    TCFNodeLaunch(final TCFModel model) {
        super(model);
        this.children = new TCFChildrenExecContext(this);
        this.children_query = new TCFChildrenContextQuery(this);
        this.filtered_children = new TCFChildren(this){

            protected boolean startDataRetrieval() {
                Set filter = TCFNodeLaunch.this.launch.getContextFilter();
                if (filter == null) {
                    if (!TCFNodeLaunch.this.children.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    this.set(null, TCFNodeLaunch.this.children.getError(), (Map)TCFNodeLaunch.this.children.getData());
                    return true;
                }
                HashMap<String, TCFNode> nodes = new HashMap<String, TCFNode>();
                for (String id : filter) {
                    if (!model.createNode(id, (Runnable)((Object)this))) {
                        return false;
                    }
                    if (this.isValid()) {
                        this.reset();
                        continue;
                    }
                    nodes.put(id, model.getNode(id));
                }
                this.set(null, null, nodes);
                return true;
            }

            @Override
            public void dispose() {
                this.getNodes().clear();
                super.dispose();
            }
        };
    }

    @Override
    void dispose() {
        ArrayList<TCFNodeSymbol> l = new ArrayList<TCFNodeSymbol>(this.symbols.values());
        for (TCFNodeSymbol s : l) {
            s.dispose();
        }
        assert (this.symbols.size() == 0);
        super.dispose();
    }

    @Override
    protected boolean getData(IChildrenCountUpdate result, Runnable done) {
        String view_id = result.getPresentationContext().getId();
        if ("org.eclipse.debug.ui.DebugView".equals(view_id)) {
            if (!this.filtered_children.validate(done)) {
                return false;
            }
            result.setChildCount(this.filtered_children.size());
        } else if ("org.eclipse.tcf.debug.ui.ContextQueryView".equals(view_id)) {
            if (!this.children_query.setQuery((IViewerUpdate)result, done)) {
                return false;
            }
            if (!this.children_query.validate(done)) {
                return false;
            }
            result.setChildCount(this.children_query.size());
        } else {
            result.setChildCount(0);
        }
        return true;
    }

    @Override
    protected boolean getData(IChildrenUpdate result, Runnable done) {
        String view_id = result.getPresentationContext().getId();
        if ("org.eclipse.debug.ui.DebugView".equals(view_id)) {
            return this.filtered_children.getData(result, done);
        }
        if ("org.eclipse.tcf.debug.ui.ContextQueryView".equals(view_id)) {
            if (!this.children_query.setQuery((IViewerUpdate)result, done)) {
                return false;
            }
            return this.children_query.getData(result, done);
        }
        return true;
    }

    @Override
    protected boolean getData(IHasChildrenUpdate result, Runnable done) {
        String view_id = result.getPresentationContext().getId();
        if ("org.eclipse.debug.ui.DebugView".equals(view_id)) {
            if (!this.filtered_children.validate(done)) {
                return false;
            }
            result.setHasChilren(this.filtered_children.size() > 0);
        } else if ("org.eclipse.tcf.debug.ui.ContextQueryView".equals(view_id)) {
            if (!this.children_query.setQuery((IViewerUpdate)result, done)) {
                return false;
            }
            if (!this.children_query.validate(done)) {
                return false;
            }
            result.setHasChilren(this.children_query.size() > 0);
        } else {
            result.setHasChilren(false);
        }
        return true;
    }

    void onContextAdded(IRunControl.RunControlContext context) {
        Set filter = this.launch.getContextFilter();
        if (filter != null) {
            String c = context.getCreatorID();
            while (c != null) {
                if (filter.contains(c)) {
                    filter.add(context.getID());
                    break;
                }
                Object o = this.model.getContextMap().get(c);
                if (!(o instanceof IRunControl.RunControlContext)) break;
                c = ((IRunControl.RunControlContext)o).getParentID();
            }
        }
        this.model.setDebugViewSelection(this, "Suspended");
        this.children.onContextAdded(context);
    }

    void onContextAdded(IMemory.MemoryContext context) {
        this.children.onContextAdded(context);
    }

    void onAnyContextSuspendedOrChanged() {
        for (TCFNodeSymbol s : this.symbols.values()) {
            s.onMemoryMapChanged();
        }
    }

    void onAnyContextAddedOrRemoved() {
        this.filtered_children.reset();
    }

    @Override
    public void addSymbol(TCFNodeSymbol s) {
        assert (this.symbols.get(s.id) == null);
        this.symbols.put(s.id, s);
    }

    @Override
    public void removeSymbol(TCFNodeSymbol s) {
        assert (this.symbols.get(s.id) == s);
        this.symbols.remove(s.id);
    }

    public TCFChildren getChildren() {
        return this.children;
    }

    public TCFChildren getFilteredChildren() {
        return this.filtered_children;
    }
}

