/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.ui.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;
import org.eclipse.tcf.te.runtime.statushandler.StatusHandlerUtil;
import org.eclipse.tcf.te.tcf.core.model.interfaces.IModel;
import org.eclipse.tcf.te.tcf.core.model.interfaces.services.IModelUpdateService;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.IProcessContextNode;
import org.eclipse.tcf.te.tcf.processes.core.model.steps.TerminateStep;
import org.eclipse.tcf.te.tcf.processes.ui.help.IContextHelpIds;
import org.eclipse.tcf.te.tcf.processes.ui.nls.Messages;
import org.eclipse.ui.handlers.HandlerUtil;

public class TerminateHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            for (Object candidate : (IStructuredSelection)selection) {
                if (!(candidate instanceof IProcessContextNode)) continue;
                final IProcessContextNode process = (IProcessContextNode)candidate;
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        TerminateStep step = new TerminateStep();
                        step.executeTerminate(process, (ICallback)new Callback(){

                            protected void internalDone(Object caller, IStatus status) {
                                if (status.getSeverity() != 4) {
                                    IModel model = (IModel)process.getParent(IModel.class);
                                    Assert.isNotNull((Object)model);
                                    ((IModelUpdateService)model.getService(IModelUpdateService.class)).remove((IModelNode)process);
                                } else {
                                    String template = NLS.bind((String)Messages.TerminateHandler_terminateFailed, (Object)process.getName(), (Object)Messages.PossibleCause);
                                    StatusHandlerUtil.handleStatus((IStatus)status, (Object)process, (String)template, null, (String)IContextHelpIds.MESSAGE_TERMINATE_FAILED, (Object)((Object)TerminateHandler.this), null);
                                }
                            }
                        });
                    }
                };
                Protocol.invokeLater((Runnable)runnable);
            }
        }
        return null;
    }
}

