/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.ui.internal.tabbed;

import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.ISysMonitor;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModelProvider;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.IProcessContextNode;
import org.eclipse.tcf.te.tcf.processes.ui.nls.Messages;
import org.eclipse.tcf.te.tcf.ui.tabbed.BaseTitledSection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class ContextIDSection
extends BaseTitledSection {
    ISysMonitor.SysMonitorContext context;
    private Text idText;
    private Text parentIdText;
    private Text pgrpText;
    private Text pidText;
    private Text ppidText;
    private Text tgidText;
    private Text tracerPidText;
    private Text uidText;
    private Text ugidText;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.idText = this.createTextField(null, Messages.ContextIDSection_ID);
        this.parentIdText = this.createTextField((Control)this.idText, Messages.ContextIDSection_ParentID);
        this.pgrpText = this.createTextField((Control)this.parentIdText, Messages.ContextIDSection_GroupID);
        this.pidText = this.createTextField((Control)this.pgrpText, Messages.ContextIDSection_PID);
        this.ppidText = this.createTextField((Control)this.pidText, Messages.ContextIDSection_PPID);
        this.tgidText = this.createTextField((Control)this.ppidText, Messages.ContextIDSection_TTY_GRPID);
        this.tracerPidText = this.createTextField((Control)this.tgidText, Messages.ContextIDSection_TracerPID);
        this.uidText = this.createTextField((Control)this.tracerPidText, Messages.ContextIDSection_UserID);
        this.ugidText = this.createTextField((Control)this.uidText, Messages.ContextIDSection_UserGRPID);
    }

    protected void updateInput(IPeerModelProvider input) {
        Assert.isTrue((boolean)(input instanceof IProcessContextNode));
        final IProcessContextNode node = (IProcessContextNode)input;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ContextIDSection.this.context = node.getSysMonitorContext();
            }
        };
        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
        Protocol.invokeAndWait((Runnable)runnable);
    }

    public void refresh() {
        this.idText.setText(this.context == null ? "" : (this.context.getID() != null ? this.context.getID() : ""));
        this.parentIdText.setText(this.context == null ? "" : (this.context.getParentID() != null ? this.context.getParentID() : ""));
        this.pgrpText.setText(this.context == null ? "" : (this.context.getPGRP() >= 0L ? "" + this.context.getPGRP() : ""));
        this.pidText.setText(this.context == null ? "" : (this.context.getPID() >= 0L ? "" + this.context.getPID() : ""));
        this.ppidText.setText(this.context == null ? "" : (this.context.getPPID() >= 0L ? "" + this.context.getPPID() : ""));
        this.tgidText.setText(this.context == null ? "" : (this.context.getTGID() >= 0L ? "" + this.context.getTGID() : ""));
        this.tracerPidText.setText(this.context == null ? "" : (this.context.getTracerPID() >= 0L ? "" + this.context.getTracerPID() : ""));
        this.uidText.setText(this.context == null ? "" : (this.context.getUID() >= 0L ? "" + this.context.getUID() : ""));
        this.ugidText.setText(this.context == null ? "" : (this.context.getUGID() >= 0L ? "" + this.context.getUGID() : ""));
        super.refresh();
    }

    protected String getText() {
        return Messages.ContextIDSection_ContextIDs;
    }
}

