/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.externaltools.internal.registry;

import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.externaltools.internal.ExternalToolsCore;
import org.eclipse.core.externaltools.internal.registry.ExternalToolsMigrationMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.RefreshUtil;

public final class ExternalToolMigration {
    private static final String VAR_TAG_START = "${";
    private static final String VAR_TAG_END = "}";
    private static final String VAR_TAG_SEP = ":";
    public static final String TOOL_TYPE_ANT_BUILD = "antBuildType";
    public static final String ID_ANT_BUILDER_LAUNCH_CONFIGURATION_TYPE = "org.eclipse.ant.AntBuilderLaunchConfigurationType";
    public static final String RUN_TARGETS_ATTRIBUTE = "antBuildType.runTargets";
    public static final String ATTR_ANT_TARGETS = "org.eclipse.ui.externaltools.ATTR_ANT_TARGETS";
    public static final String TAG_TOOL_TYPE = "!{tool_type}";
    public static final String TAG_TOOL_NAME = "!{tool_name}";
    public static final String TAG_TOOL_LOCATION = "!{tool_loc}";
    public static final String TAG_TOOL_ARGUMENTS = "!{tool_args}";
    public static final String TAG_TOOL_DIRECTORY = "!{tool_dir}";
    public static final String TAG_TOOL_REFRESH = "!{tool_refresh}";
    public static final String TAG_TOOL_SHOW_LOG = "!{tool_show_log}";
    public static final String TAG_TOOL_BUILD_TYPES = "!{tool_build_types}";
    public static final String TAG_TOOL_BLOCK = "!{tool_block}";
    private static final String TOOL_TYPE_ANT = "org.eclipse.ui.externaltools.type.ant";
    private static final String TOOL_TYPE_PROGRAM = "org.eclipse.ui.externaltools.type.program";
    public static final String TAG_TYPE = "type";
    public static final String TAG_NAME = "name";
    public static final String TAG_LOCATION = "location";
    public static final String TAG_WORK_DIR = "workDirectory";
    public static final String TAG_CAPTURE_OUTPUT = "captureOutput";
    public static final String TAG_SHOW_CONSOLE = "showConsole";
    public static final String TAG_RUN_BKGRND = "runInBackground";
    public static final String TAG_PROMPT_ARGS = "promptForArguments";
    public static final String TAG_ARGS = "arguments";
    public static final String TAG_REFRESH_SCOPE = "refreshScope";
    public static final String TAG_REFRESH_RECURSIVE = "refreshRecursive";
    public static final String TAG_RUN_BUILD_KINDS = "runForBuildKinds";
    public static final String TAG_EXTRA_ATTR = "extraAttribute";
    public static final String TAG_VERSION = "version";
    private static final String EXTRA_ATTR_SEPARATOR = "=";
    private static final String VERSION_21 = "2.1";
    private static final String TRUE = "true";
    private static final String FALSE = "false";

    private ExternalToolMigration() {
    }

    public static ILaunchConfigurationWorkingCopy configFromArgumentMap(Map args) {
        String version = (String)args.get(TAG_VERSION);
        if (VERSION_21.equals(version)) {
            return ExternalToolMigration.configFrom21ArgumentMap(args);
        }
        return ExternalToolMigration.configFrom20ArgumentMap(args);
    }

    public static ILaunchConfigurationWorkingCopy configFrom21ArgumentMap(Map commandArgs) {
        String extraAttributes;
        String name = (String)commandArgs.get(TAG_NAME);
        String type = (String)commandArgs.get(TAG_TYPE);
        ILaunchConfigurationWorkingCopy config = ExternalToolMigration.newConfig(type, name);
        if (config == null) {
            return null;
        }
        config.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", (String)commandArgs.get(TAG_LOCATION));
        config.setAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", (String)commandArgs.get(TAG_WORK_DIR));
        config.setAttribute("org.eclipse.debug.core.capture_output", TRUE.equals(commandArgs.get(TAG_CAPTURE_OUTPUT)));
        config.setAttribute("org.eclipse.ui.externaltools.ATTR_SHOW_CONSOLE", TRUE.equals(commandArgs.get(TAG_SHOW_CONSOLE)));
        config.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", TRUE.equals(commandArgs.get(TAG_RUN_BKGRND)));
        config.setAttribute("org.eclipse.ui.externaltools.ATTR_PROMPT_FOR_ARGUMENTS", TRUE.equals(commandArgs.get(TAG_PROMPT_ARGS)));
        config.setAttribute(RefreshUtil.ATTR_REFRESH_SCOPE, (String)commandArgs.get(TAG_REFRESH_SCOPE));
        config.setAttribute(RefreshUtil.ATTR_REFRESH_RECURSIVE, TRUE.equals(commandArgs.get(TAG_REFRESH_RECURSIVE)));
        config.setAttribute("org.eclipse.ui.externaltools.ATTR_RUN_BUILD_KINDS", (String)commandArgs.get(TAG_RUN_BUILD_KINDS));
        String args = (String)commandArgs.get(TAG_ARGS);
        if (args != null) {
            config.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", args);
        }
        if ((extraAttributes = (String)commandArgs.get(TAG_EXTRA_ATTR)) != null) {
            StringTokenizer tokenizer = new StringTokenizer(extraAttributes, EXTRA_ATTR_SEPARATOR);
            while (tokenizer.hasMoreTokens()) {
                String key = tokenizer.nextToken();
                if (!tokenizer.hasMoreTokens()) break;
                String value = tokenizer.nextToken();
                if (!key.equals(RUN_TARGETS_ATTRIBUTE)) continue;
                config.setAttribute(ATTR_ANT_TARGETS, value);
            }
        }
        return config;
    }

    public static ILaunchConfigurationWorkingCopy configFrom20ArgumentMap(Map args) {
        String type = (String)args.get(TAG_TOOL_TYPE);
        if (TOOL_TYPE_ANT.equals(type)) {
            type = TOOL_TYPE_ANT_BUILD;
        } else if (TOOL_TYPE_PROGRAM.equals(type)) {
            type = "programType";
        } else {
            return null;
        }
        String name = (String)args.get(TAG_TOOL_NAME);
        ILaunchConfigurationWorkingCopy config = ExternalToolMigration.newConfig(type, name);
        if (config == null) {
            return null;
        }
        String location = (String)args.get(TAG_TOOL_LOCATION);
        config.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", location);
        String refresh = (String)args.get(TAG_TOOL_REFRESH);
        if (refresh != null) {
            VariableDefinition varDef = ExternalToolMigration.extractVariableDefinition(refresh, 0);
            if ("none".equals(varDef.name)) {
                refresh = null;
            }
            config.setAttribute(RefreshUtil.ATTR_REFRESH_SCOPE, refresh);
        }
        String arguments = (String)args.get(TAG_TOOL_ARGUMENTS);
        if (type.equals(TOOL_TYPE_ANT_BUILD)) {
            String targetNames = null;
            if (arguments != null) {
                int start = 0;
                ArrayList<String> targets = new ArrayList<String>();
                StringBuffer buffer = new StringBuffer();
                VariableDefinition varDef = ExternalToolMigration.extractVariableDefinition(arguments, start);
                while (varDef.end != -1) {
                    if ("ant_target".equals(varDef.name) && varDef.argument != null) {
                        targets.add(varDef.argument);
                        buffer.append(arguments.substring(start, varDef.start));
                    } else {
                        buffer.append(arguments.substring(start, varDef.end));
                    }
                    start = varDef.end;
                    varDef = ExternalToolMigration.extractVariableDefinition(arguments, start);
                }
                buffer.append(arguments.substring(start, arguments.length()));
                arguments = buffer.toString();
                buffer.setLength(0);
                int i = 0;
                while (i < targets.size()) {
                    String target = (String)targets.get(i);
                    if (target != null && target.length() > 0) {
                        buffer.append(target);
                        buffer.append(",");
                    }
                    ++i;
                }
                targetNames = buffer.toString();
            }
            if (targetNames != null && targetNames.length() > 0) {
                config.setAttribute(ATTR_ANT_TARGETS, targetNames);
            }
        }
        config.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", arguments);
        config.setAttribute("org.eclipse.ui.externaltools.ATTR_SHOW_CONSOLE", TRUE.equals(args.get(TAG_TOOL_SHOW_LOG)));
        config.setAttribute("org.eclipse.debug.core.capture_output", TRUE.equals(args.get(TAG_TOOL_SHOW_LOG)));
        config.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", FALSE.equals(args.get(TAG_TOOL_BLOCK)));
        String buildKinds = (String)args.get(TAG_TOOL_BUILD_TYPES);
        if (buildKinds != null) {
            buildKinds = buildKinds.replace(';', ',');
        }
        config.setAttribute("org.eclipse.ui.externaltools.ATTR_RUN_BUILD_KINDS", buildKinds);
        config.setAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", (String)args.get(TAG_TOOL_DIRECTORY));
        return config;
    }

    private static ILaunchConfigurationWorkingCopy newConfig(String type, String name) {
        ILaunchConfigurationType configType;
        if (type == null || name == null) {
            return null;
        }
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        if (TOOL_TYPE_ANT_BUILD.equals(type)) {
            configType = manager.getLaunchConfigurationType(ID_ANT_BUILDER_LAUNCH_CONFIGURATION_TYPE);
        } else if ("programType".equals(type)) {
            configType = manager.getLaunchConfigurationType("org.eclipse.ui.externaltools.ProgramBuilderLaunchConfigurationType");
        } else {
            return null;
        }
        try {
            if (configType != null) {
                return configType.newInstance(null, name);
            }
        }
        catch (CoreException e) {
            ExternalToolsCore.log(e);
        }
        return null;
    }

    public static String getNameFromCommandArgs(Map commandArgs) {
        String name = (String)commandArgs.get(TAG_NAME);
        if (name == null) {
            name = (String)commandArgs.get(TAG_TOOL_NAME);
        }
        return name;
    }

    public static ILaunchConfiguration migrateRunInBackground(ILaunchConfiguration config) {
        String noValueFlag = "NoValue";
        String attr = null;
        try {
            attr = config.getAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", noValueFlag);
        }
        catch (CoreException coreException) {
            return config;
        }
        if (noValueFlag.equals(attr)) {
            String ATTR_RUN_IN_BACKGROUND = "org.eclipse.ui.externaltools.ATTR_RUN_IN_BACKGROUND";
            boolean runInBackground = false;
            try {
                runInBackground = config.getAttribute(ATTR_RUN_IN_BACKGROUND, runInBackground);
            }
            catch (CoreException e) {
                ExternalToolsCore.log(ExternalToolsMigrationMessages.ExternalToolMigration_37, e);
            }
            try {
                ILaunchConfigurationWorkingCopy workingCopy = config.getWorkingCopy();
                workingCopy.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", runInBackground);
                config = workingCopy.doSave();
            }
            catch (CoreException e) {
                ExternalToolsCore.log(ExternalToolsMigrationMessages.ExternalToolMigration_38, e);
            }
        }
        return config;
    }

    public static VariableDefinition extractVariableDefinition(String text, int start) {
        VariableDefinition varDef = new VariableDefinition();
        varDef.start = text.indexOf(VAR_TAG_START, start);
        if (varDef.start < 0) {
            return varDef;
        }
        start = varDef.start + VAR_TAG_START.length();
        int end = text.indexOf(VAR_TAG_END, start);
        if (end < 0) {
            return varDef;
        }
        varDef.end = end + VAR_TAG_END.length();
        if (end == start) {
            return varDef;
        }
        int mid = text.indexOf(VAR_TAG_SEP, start);
        if (mid < 0 || mid > end) {
            varDef.name = text.substring(start, end);
        } else {
            if (mid > start) {
                varDef.name = text.substring(start, mid);
            }
            if ((mid += VAR_TAG_SEP.length()) < end) {
                varDef.argument = text.substring(mid, end);
            }
        }
        return varDef;
    }

    public static final class VariableDefinition {
        public int start = -1;
        public int end = -1;
        public String name = null;
        public String argument = null;

        private VariableDefinition() {
        }
    }
}

