/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.envvar;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.internal.core.envvar.EnvironmentChangeEvent;
import org.eclipse.cdt.utils.envvar.IEnvironmentChangeEvent;
import org.eclipse.cdt.utils.envvar.IEnvironmentChangeListener;
import org.eclipse.cdt.utils.envvar.StorableEnvVar;
import org.eclipse.cdt.utils.envvar.StorableEnvironment;
import org.eclipse.cdt.utils.envvar.StorableEnvironmentLoader;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferenceNodeVisitor;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class PrefsStorableEnvironment
extends StorableEnvironment {
    private StorableEnvironmentLoader.ISerializeInfo fSerialEnv;
    protected Set<String> fDeletedVariables;
    private Map<String, IEnvironmentVariable> fCachedSerialEnv = new HashMap<String, IEnvironmentVariable>();
    private boolean fAppendChanged = false;
    private boolean fAppendContributedChanged = false;
    private static ListenerList fEnvironmentChangeListeners = new ListenerList(1);
    private PrefListener fPrefsChangedListener;

    private Set<String> getDeletedSet() {
        if (this.fDeletedVariables == null) {
            this.fDeletedVariables = new HashSet<String>();
        }
        return this.fDeletedVariables;
    }

    PrefsStorableEnvironment(StorableEnvironment env, StorableEnvironmentLoader.ISerializeInfo serializeInfo, boolean isReadOnly) {
        super(isReadOnly);
        this.fAppend = env.fAppend;
        this.fAppendContributedEnv = env.fAppendContributedEnv;
        if (env instanceof PrefsStorableEnvironment) {
            PrefsStorableEnvironment other = (PrefsStorableEnvironment)env;
            this.fAppendChanged = other.fAppendChanged;
            this.fAppendContributedChanged = other.fAppendContributedChanged;
            if (serializeInfo == null || other.fSerialEnv == null || !serializeInfo.getPrefName().equals(other.fSerialEnv.getPrefName())) {
                this.fVariables = env.getAllVariablesMap();
            } else {
                if (other.fVariables != null) {
                    this.getMap().putAll(other.fVariables);
                }
                if (other.fDeletedVariables != null) {
                    this.getDeletedSet().addAll(other.fDeletedVariables);
                }
            }
        } else {
            if (env.fVariables != null) {
                this.fVariables = env.getAllVariablesMap();
            }
            this.fAppendChanged = true;
            this.fAppendContributedChanged = true;
        }
        this.setSerializeInfo(serializeInfo);
    }

    PrefsStorableEnvironment(StorableEnvironmentLoader.ISerializeInfo serializeInfo, boolean isReadOnly) {
        super(isReadOnly);
        this.setSerializeInfo(serializeInfo);
    }

    private void setSerializeInfo(StorableEnvironmentLoader.ISerializeInfo serializeInfo) {
        if (this.fPrefsChangedListener != null) {
            this.fPrefsChangedListener.remove();
        }
        this.fSerialEnv = serializeInfo;
        this.fPrefsChangedListener = new PrefListener(this, this.fSerialEnv);
        this.checkBackingSerializeInfo();
    }

    private void checkBackingSerializeInfo() {
        block14: {
            if (!this.fPrefsChangedListener.preferencesChanged(this.fSerialEnv)) {
                return;
            }
            Preferences topNode = this.fSerialEnv.getNode();
            if (topNode == null) {
                return;
            }
            try {
                if (topNode.get(this.fSerialEnv.getPrefName(), "").length() != 0) {
                    this.migrateOldStylePrefs();
                }
                if (!topNode.nodeExists(this.fSerialEnv.getPrefName())) break block14;
                this.fCachedSerialEnv.clear();
                Preferences prefs = topNode.node(this.fSerialEnv.getPrefName());
                try {
                    String[] stringArray = prefs.childrenNames();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String child = stringArray[n2];
                        String name = this.getNameForMap(child);
                        StorableEnvVar env = new StorableEnvVar(child, prefs.node(child));
                        this.addVariable(this.fCachedSerialEnv, env);
                        if (((Object)env).equals(this.getMap().get(name))) {
                            this.getMap().remove(name);
                        }
                        ++n2;
                    }
                }
                catch (BackingStoreException e) {
                    CCorePlugin.log(e);
                }
                if (this.fDeletedVariables != null) {
                    Iterator<String> it = this.fDeletedVariables.iterator();
                    while (it.hasNext()) {
                        String name = it.next();
                        if (this.fCachedSerialEnv.containsKey(name)) continue;
                        it.remove();
                    }
                    if (this.fDeletedVariables.isEmpty()) {
                        this.fDeletedVariables = null;
                    }
                }
                boolean append = prefs.getBoolean("append", true);
                if (!this.fAppendChanged || this.fAppend == append) {
                    this.fAppend = append;
                    this.fAppendChanged = false;
                }
                append = prefs.getBoolean("appendContributed", true);
                if (!this.fAppendContributedChanged || this.fAppendContributedEnv == append) {
                    this.fAppendContributedEnv = append;
                    this.fAppendContributedChanged = false;
                }
            }
            catch (BackingStoreException e) {
                CCorePlugin.log(e);
            }
        }
    }

    private void migrateOldStylePrefs() {
        String envString = StorableEnvironmentLoader.loadPreferenceNode(this.fSerialEnv);
        ICStorageElement element = StorableEnvironmentLoader.environmentStorageFromString(envString);
        if (element != null) {
            Preferences oldNode = this.fSerialEnv.getNode();
            oldNode.put(this.fSerialEnv.getPrefName(), "");
            Preferences newNode = this.fSerialEnv.getNode().node(this.fSerialEnv.getPrefName());
            StorableEnvironment oldEnv = new StorableEnvironment(element, false);
            for (Map.Entry<String, IEnvironmentVariable> e : oldEnv.getMap().entrySet()) {
                ((StorableEnvVar)e.getValue()).serialize(newNode.node(e.getKey()));
            }
            this.fCachedSerialEnv.putAll(oldEnv.getMap());
            if (!this.fAppendChanged) {
                this.fAppend = oldEnv.fAppend;
            }
            newNode.putBoolean("append", this.fAppend);
            if (!this.fAppendContributedChanged) {
                this.fAppendContributedEnv = oldEnv.fAppendContributedEnv;
            }
            newNode.putBoolean("appendContributed", this.fAppendContributedEnv);
        }
    }

    @Override
    @Deprecated
    public void serialize(ICStorageElement element) {
        this.checkBackingSerializeInfo();
        Map<String, IEnvironmentVariable> map = this.getAllVariablesMap();
        element.setAttribute("append", Boolean.valueOf(this.fAppend).toString());
        element.setAttribute("appendContributed", Boolean.valueOf(this.fAppendContributedEnv).toString());
        if (!map.isEmpty()) {
            for (StorableEnvVar storableEnvVar : map.values()) {
                ICStorageElement varEl = element.createChild("variable");
                storableEnvVar.serialize(varEl);
            }
        }
    }

    void serialize() {
        if (!this.isDirty()) {
            return;
        }
        HashMap<String, IEnvironmentVariable> oldEnv = new HashMap<String, IEnvironmentVariable>(this.fCachedSerialEnv);
        Preferences element = this.fSerialEnv.getNode().node(this.fSerialEnv.getPrefName());
        element.putBoolean("append", this.fAppend);
        this.fAppendChanged = false;
        element.putBoolean("appendContributed", this.fAppendContributedEnv);
        this.fAppendContributedChanged = false;
        try {
            if (this.fDeletedVariables != null) {
                for (String string : this.fDeletedVariables) {
                    element.node(string).removeNode();
                    this.fCachedSerialEnv.remove(string);
                }
                this.fDeletedVariables.clear();
            }
        }
        catch (BackingStoreException backingStoreException) {
            CCorePlugin.log(backingStoreException);
        }
        if (this.fVariables != null) {
            for (Map.Entry entry : this.fVariables.entrySet()) {
                ((StorableEnvVar)entry.getValue()).serialize(element.node((String)entry.getKey()));
            }
            this.fCachedSerialEnv.putAll(this.fVariables);
            this.fVariables.clear();
        }
        try {
            element.flush();
        }
        catch (BackingStoreException backingStoreException) {
            CCorePlugin.log(backingStoreException);
        }
        if (this.fAppendChanged || this.fAppendContributedChanged || !oldEnv.equals(this.fCachedSerialEnv)) {
            EnvironmentChangeEvent environmentChangeEvent = new EnvironmentChangeEvent(oldEnv.values(), this.fCachedSerialEnv.values());
            PrefsStorableEnvironment.notifyLanguageSettingsChangeListeners(environmentChangeEvent);
        }
    }

    @Override
    public IEnvironmentVariable createVariable(String name, String value, int op, String delimiter) {
        IEnvironmentVariable var = super.createVariable(name, value, op, delimiter);
        if (var != null) {
            if (this.fDeletedVariables != null) {
                this.fDeletedVariables.remove(this.getNameForMap(name));
            }
            if (var.equals(this.fCachedSerialEnv.get(this.getNameForMap(name)))) {
                this.getMap().remove(this.getNameForMap(name));
            }
        }
        return var;
    }

    @Override
    public IEnvironmentVariable getVariable(String name) {
        IEnvironmentVariable var = super.getVariable(name = this.getNameForMap(name));
        if (var != null) {
            return var;
        }
        if (this.fDeletedVariables != null && this.fDeletedVariables.contains(name)) {
            return null;
        }
        this.checkBackingSerializeInfo();
        return this.fCachedSerialEnv.get(name);
    }

    @Override
    Map<String, IEnvironmentVariable> getAllVariablesMap() {
        this.checkBackingSerializeInfo();
        HashMap<String, IEnvironmentVariable> vars = new HashMap<String, IEnvironmentVariable>();
        if (this.fCachedSerialEnv != null) {
            vars.putAll(this.fCachedSerialEnv);
        }
        if (this.fDeletedVariables != null) {
            for (String name : this.fDeletedVariables) {
                vars.remove(name);
            }
        }
        vars.putAll(this.getMap());
        return vars;
    }

    @Override
    public IEnvironmentVariable deleteVariable(String name) {
        name = this.getNameForMap(name);
        IEnvironmentVariable var = super.deleteVariable(name);
        if (name == null) {
            return null;
        }
        this.getDeletedSet().add(name);
        return var;
    }

    @Override
    public boolean deleteAll() {
        boolean change = super.deleteAll();
        change = change || !this.getDeletedSet().equals(this.fCachedSerialEnv.keySet());
        this.getDeletedSet().addAll(this.fCachedSerialEnv.keySet());
        if (change) {
            this.fIsChanged = true;
        }
        return change;
    }

    @Override
    public void setAppendEnvironment(boolean append) {
        boolean prevVal = this.fAppend;
        super.setAppendEnvironment(append);
        if (prevVal != this.fAppend) {
            this.fAppendChanged = true;
        }
    }

    @Override
    public void setAppendContributedEnvironment(boolean append) {
        boolean prevVal = this.fAppendContributedEnv;
        super.setAppendContributedEnvironment(append);
        if (prevVal != this.fAppendContributedEnv) {
            this.fAppendContributedChanged = true;
        }
    }

    @Override
    public void restoreDefaults() {
        super.restoreDefaults();
        this.fAppendChanged = false;
        this.fAppendContributedChanged = false;
    }

    @Override
    public boolean isDirty() {
        return this.fAppendChanged || this.fAppendContributedChanged || this.fVariables != null && !this.fVariables.isEmpty() || this.fDeletedVariables != null && !this.fDeletedVariables.isEmpty();
    }

    public void registerEnvironmentChangeListener(IEnvironmentChangeListener listener) {
        fEnvironmentChangeListeners.add((Object)listener);
    }

    public void unregisterEnvironmentChangeListener(IEnvironmentChangeListener listener) {
        fEnvironmentChangeListeners.remove((Object)listener);
    }

    private static void notifyLanguageSettingsChangeListeners(IEnvironmentChangeEvent event) {
        Object[] objectArray = fEnvironmentChangeListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IEnvironmentChangeListener)listener).handleEvent(event);
            ++n2;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.fPrefsChangedListener != null) {
            this.fPrefsChangedListener.remove();
        }
    }

    private static class PrefListener
    implements IEclipsePreferences.IPreferenceChangeListener,
    IEclipsePreferences.INodeChangeListener {
        private volatile boolean prefsChanged = true;
        private Set<IEclipsePreferences> registeredOn = Collections.synchronizedSet(new HashSet());
        volatile IEclipsePreferences root;
        Reference<PrefsStorableEnvironment> parentRef;

        public PrefListener(PrefsStorableEnvironment parent, StorableEnvironmentLoader.ISerializeInfo info) {
            this.parentRef = new WeakReference<PrefsStorableEnvironment>(parent);
            this.register(info);
        }

        public void remove() {
            if (this.root != null) {
                try {
                    this.removeListener();
                }
                catch (Exception e) {
                    CCorePlugin.log(e);
                }
                this.root = null;
            }
        }

        private void register(StorableEnvironmentLoader.ISerializeInfo info) {
            if (this.root != null) {
                return;
            }
            this.root = (IEclipsePreferences)info.getNode();
            if (this.root != null) {
                this.addListener(this.root);
            }
            this.prefsChanged = true;
        }

        private void addListener(IEclipsePreferences node) {
            try {
                node.accept(new IPreferenceNodeVisitor(){

                    public boolean visit(IEclipsePreferences node) throws BackingStoreException {
                        node.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)PrefListener.this);
                        node.addNodeChangeListener((IEclipsePreferences.INodeChangeListener)PrefListener.this);
                        PrefListener.this.registeredOn.add(node);
                        return true;
                    }
                });
            }
            catch (BackingStoreException e) {
                CCorePlugin.log(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeListener() {
            Set<IEclipsePreferences> set = this.registeredOn;
            synchronized (set) {
                for (IEclipsePreferences pref : this.registeredOn) {
                    try {
                        pref.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
                        pref.removeNodeChangeListener((IEclipsePreferences.INodeChangeListener)this);
                    }
                    catch (IllegalStateException illegalStateException) {}
                }
            }
        }

        public boolean preferencesChanged(StorableEnvironmentLoader.ISerializeInfo info) {
            if (this.root == null) {
                this.register(info);
            }
            boolean retVal = this.prefsChanged;
            if (this.root != null) {
                this.prefsChanged = false;
            }
            return retVal;
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            this.prefsChanged = true;
            if (this.parentRef.get() == null) {
                this.removeListener();
            }
        }

        public void added(IEclipsePreferences.NodeChangeEvent event) {
            this.prefsChanged = true;
            if (this.parentRef.get() == null) {
                this.removeListener();
            } else {
                this.addListener((IEclipsePreferences)event.getChild());
            }
        }

        public void removed(IEclipsePreferences.NodeChangeEvent event) {
            this.prefsChanged = true;
        }
    }
}

