/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.operations;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.exceptions.TCFException;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.exceptions.TCFFileSystemException;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.Operation;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.nls.Messages;

public class OpRefresh
extends Operation {
    FSTreeNode node;

    public OpRefresh(FSTreeNode node) {
        this.node = node;
    }

    public OpRefresh(List<FSTreeNode> nodes) {
        this.node = (FSTreeNode)this.getAncestor(nodes);
    }

    @Override
    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        block8: {
            super.run(monitor);
            if (this.node != null && (this.node.childrenQueried || this.node.isFile())) {
                IChannel channel = null;
                try {
                    try {
                        channel = OpRefresh.openChannel(this.node.peerNode.getPeer());
                        if (channel == null) break block8;
                        IFileSystem service = OpRefresh.getBlockingFileSystem(channel);
                        if (service != null) {
                            this.refresh(this.node, service);
                            break block8;
                        }
                        String message = NLS.bind((String)Messages.Operation_NoFileSystemError, (Object)this.node.peerNode.getPeerId());
                        throw new TCFFileSystemException(4, message);
                    }
                    catch (TCFException e) {
                        throw new InvocationTargetException(e, e.getMessage());
                    }
                }
                finally {
                    if (channel != null) {
                        Tcf.getChannelManager().closeChannel(channel);
                    }
                    monitor.done();
                }
            }
            monitor.done();
        }
    }

    void refresh(FSTreeNode node, IFileSystem service) throws InterruptedException {
        if (this.monitor.isCanceled()) {
            throw new InterruptedException();
        }
        if ((node.isSystemRoot() || node.isDirectory()) && node.childrenQueried) {
            if (!node.isSystemRoot()) {
                try {
                    this.updateChildren(node, service);
                }
                catch (TCFException tCFException) {}
            }
            this.monitor.worked(1);
            List<FSTreeNode> children = node.getChildren();
            for (FSTreeNode child : children) {
                this.refresh(child, service);
            }
        } else if (node.isFile()) {
            node.refresh();
        }
    }

    protected void updateChildren(FSTreeNode node, IFileSystem service) throws TCFFileSystemException, InterruptedException {
        if (this.monitor.isCanceled()) {
            throw new InterruptedException();
        }
        List<FSTreeNode> current = node.getChildren();
        List<FSTreeNode> latest = this.queryChildren(node, service);
        List<FSTreeNode> newNodes = this.diff(latest, current);
        List<FSTreeNode> deleted = this.diff(current, latest);
        node.removeChildren(deleted);
        node.addChidren(newNodes);
    }

    private List<FSTreeNode> diff(List<FSTreeNode> aList, List<FSTreeNode> bList) {
        ArrayList<FSTreeNode> newList = new ArrayList<FSTreeNode>();
        for (FSTreeNode aNode : aList) {
            boolean found = false;
            for (FSTreeNode bNode : bList) {
                if (!aNode.name.equals(bNode.name)) continue;
                found = true;
                break;
            }
            if (found) continue;
            newList.add(aNode);
        }
        return newList;
    }

    @Override
    public String getName() {
        return NLS.bind((String)Messages.OpRefresh_RefreshJobTitle, (Object)(this.node == null ? "" : this.node.name));
    }

    @Override
    public int getTotalWork() {
        return this.count(this.node);
    }

    private int count(FSTreeNode node) {
        if ((node.isSystemRoot() || node.isDirectory()) && node.childrenQueried) {
            int total = 1;
            List<FSTreeNode> children = node.getChildren();
            for (FSTreeNode child : children) {
                total += this.count(child);
            }
            return total;
        }
        return 0;
    }
}

