/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.operations;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.exceptions.TCFException;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.exceptions.TCFFileSystemException;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.Operation;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.CacheManager;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.PersistenceManager;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.nls.Messages;

public class OpRename
extends Operation {
    FSTreeNode node;
    String newName;

    public OpRename(FSTreeNode node, String newName) {
        this.node = node;
        this.newName = newName;
    }

    @Override
    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        block7: {
            super.run(monitor);
            IChannel channel = null;
            try {
                try {
                    channel = OpRename.openChannel(this.node.peerNode.getPeer());
                    if (channel == null) break block7;
                    IFileSystem service = OpRename.getBlockingFileSystem(channel);
                    if (service != null) {
                        this.renameNode(service);
                        break block7;
                    }
                    String message = NLS.bind((String)Messages.Operation_NoFileSystemError, (Object)this.node.peerNode.getPeerId());
                    throw new TCFFileSystemException(4, message);
                }
                catch (TCFException e) {
                    throw new InvocationTargetException(e, e.getMessage());
                }
            }
            finally {
                if (channel != null) {
                    Tcf.getChannelManager().closeChannel(channel);
                }
                monitor.done();
            }
        }
    }

    void renameNode(IFileSystem service) throws TCFFileSystemException {
        String src_path = this.node.getLocation(true);
        String oldName = this.node.name;
        this.node.name = this.newName;
        String dst_path = this.node.getLocation(true);
        this.node.name = oldName;
        final TCFFileSystemException[] errors = new TCFFileSystemException[1];
        service.rename(src_path, dst_path, new IFileSystem.DoneRename(){

            public void doneRename(IToken token, IFileSystem.FileSystemException error) {
                if (error != null) {
                    String message = NLS.bind((String)Messages.OpRename_CannotRename, (Object)OpRename.this.node.name, (Object)error);
                    errors[0] = new TCFFileSystemException(4, message, (Throwable)error);
                } else {
                    File file = CacheManager.getCacheFile(OpRename.this.node);
                    if (OpRename.this.node.isFile() && file.exists()) {
                        PersistenceManager.getInstance().removeFileDigest(OpRename.this.node.getLocationURI());
                    }
                    OpRename.this.deleteFileChecked(file);
                    OpRename.this.node.setName(OpRename.this.newName);
                }
            }
        });
        this.monitor.worked(1);
        if (errors[0] != null) {
            throw errors[0];
        }
    }

    @Override
    public String getName() {
        return Messages.OpRename_TitleRename;
    }
}

