/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.operations;

import java.io.File;
import java.text.DecimalFormat;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.Operation;
import org.eclipse.tcf.te.tcf.filesystem.core.nls.Messages;

public abstract class OpStreamOp
extends Operation {
    protected static final DecimalFormat SIZE_FORMAT = new DecimalFormat("#,##0.##");
    public static final int DEFAULT_CHUNK_SIZE = 5120;

    protected void setReadOnlyChecked(final File file) {
        if (file.exists()) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    if (!file.setReadOnly()) {
                        throw new Exception(NLS.bind((String)Messages.OpStreamOp_SetReadOnlyFailed, (Object)file.getAbsolutePath()));
                    }
                }

                public void handleException(Throwable exception) {
                }
            });
        }
    }

    protected String formatSize(long size) {
        double kbSize = (double)size / 1024.0;
        if (kbSize < 1.0) {
            return String.valueOf(SIZE_FORMAT.format(size)) + Messages.OpStreamOp_Bytes;
        }
        double mbSize = kbSize / 1024.0;
        if (mbSize < 1.0) {
            return String.valueOf(SIZE_FORMAT.format(kbSize)) + Messages.OpStreamOp_KBs;
        }
        return String.valueOf(SIZE_FORMAT.format(mbSize)) + Messages.OpStreamOp_MBs;
    }
}

