/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.operations;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IConfirmCallback;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.NullOpExecutor;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.OpCreateFolder;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.OpStreamOp;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.url.TcfURLConnection;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.CacheManager;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.FileState;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.PersistenceManager;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.nls.Messages;

public class OpUpload
extends OpStreamOp {
    File[] srcFiles;
    URL[] dstURLs;
    IConfirmCallback confirmCallback;
    Map<File, FSTreeNode> parentFolders;
    FSTreeNode[] nodes;

    public OpUpload(File srcFile, URL dstURL) {
        this(new File[]{srcFile}, new URL[]{dstURL});
    }

    public OpUpload(File[] srcFiles, URL[] dstURLs) {
        this(srcFiles, dstURLs, null);
    }

    public OpUpload(String[] sourceFiles, FSTreeNode targetFolder) {
        this(sourceFiles, targetFolder, null);
    }

    public OpUpload(File[] srcFiles, URL[] dstURLs, IConfirmCallback confirmCallback) {
        this.srcFiles = srcFiles;
        this.dstURLs = dstURLs;
        this.confirmCallback = confirmCallback;
    }

    public OpUpload(FSTreeNode ... nodes) {
        this.srcFiles = new File[nodes.length];
        this.dstURLs = new URL[nodes.length];
        int i = 0;
        while (i < nodes.length) {
            this.srcFiles[i] = CacheManager.getCacheFile(nodes[i]);
            this.dstURLs[i] = nodes[i].getLocationURL();
            ++i;
        }
        this.nodes = nodes;
    }

    public OpUpload(String[] sourceFiles, FSTreeNode targetFolder, IConfirmCallback confirmCallback) {
        this.confirmCallback = confirmCallback;
        ArrayList<File> fileList = new ArrayList<File>();
        ArrayList<URL> urlList = new ArrayList<URL>();
        this.prepareDirStruct(sourceFiles, fileList, urlList, targetFolder);
        this.srcFiles = fileList.toArray(new File[fileList.size()]);
        this.dstURLs = urlList.toArray(new URL[urlList.size()]);
    }

    @Override
    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        super.run(monitor);
        try {
            try {
                this.uploadFiles(this.srcFiles, this.dstURLs);
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
            }
            catch (MalformedURLException e) {
                throw new InvocationTargetException(e);
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    private boolean requireConfirmation(File file) {
        return this.parentFolders != null && this.confirmCallback != null && !this.yes2All && this.confirmCallback.requires(file) && this.findNode(file) != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void uploadFiles(File[] files, URL[] urls) throws IOException {
        byte[] data = new byte[5120];
        long totalSize = 0L;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            totalSize += file.length();
            ++n2;
        }
        int chunk_size = (int)totalSize / 100;
        int percentRead = 0;
        long bytesRead = 0L;
        int i = 0;
        while (i < files.length && !this.monitor.isCanceled()) {
            block31: {
                FileState filedigest;
                File file;
                block30: {
                    file = files[i];
                    if (!this.requireConfirmation(file)) break block30;
                    int result = this.confirmCallback.confirms(file);
                    switch (result) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            this.yes2All = true;
                            break;
                        }
                        case 2: {
                            int percent;
                            if (chunk_size != 0 && (percent = (int)(bytesRead += file.length()) / chunk_size) != percentRead) {
                                this.monitor.worked(percent - percentRead);
                                percentRead = percent;
                                this.monitor.subTask(NLS.bind((String)Messages.OpUpload_UploadingProgress, (Object[])new Object[]{file.getName(), this.formatSize(bytesRead), this.formatSize(file.length())}));
                            }
                            break block31;
                        }
                        case 3: {
                            this.monitor.setCanceled(true);
                            break block31;
                        }
                    }
                }
                BufferedInputStream input = null;
                FilterOutputStream output = null;
                MessageDigest digest = null;
                try {
                    int length;
                    URL url = urls[i];
                    TcfURLConnection connection = (TcfURLConnection)url.openConnection();
                    connection.setDoInput(false);
                    connection.setDoOutput(true);
                    if (this.nodes != null) {
                        try {
                            digest = MessageDigest.getInstance("MD5");
                            input = new BufferedInputStream(new DigestInputStream(new FileInputStream(file), digest));
                        }
                        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                            input = new BufferedInputStream(new FileInputStream(file));
                        }
                    } else {
                        input = new BufferedInputStream(new FileInputStream(file));
                    }
                    output = new BufferedOutputStream(connection.getOutputStream());
                    String fileLength = this.formatSize(file.length());
                    while ((length = input.read(data)) >= 0 && !this.monitor.isCanceled()) {
                        int percent;
                        ((BufferedOutputStream)output).write(data, 0, length);
                        ((BufferedOutputStream)output).flush();
                        if (chunk_size == 0 || (percent = (int)(bytesRead += (long)length) / chunk_size) == percentRead) continue;
                        this.monitor.worked(percent - percentRead);
                        percentRead = percent;
                        this.monitor.subTask(NLS.bind((String)Messages.OpUpload_UploadingProgress, (Object[])new Object[]{file.getName(), this.formatSize(bytesRead), fileLength}));
                    }
                }
                catch (Throwable throwable) {
                    if (output != null) {
                        try {
                            output.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (digest != null && this.nodes != null) {
                        filedigest = PersistenceManager.getInstance().getFileDigest(this.nodes[i]);
                        filedigest.reset(digest.digest());
                    }
                    throw throwable;
                }
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (Exception exception) {}
                }
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (Exception exception) {}
                }
                if (digest != null && this.nodes != null) {
                    filedigest = PersistenceManager.getInstance().getFileDigest(this.nodes[i]);
                    filedigest.reset(digest.digest());
                }
            }
            ++i;
        }
    }

    private void prepareDirStruct(String[] sourceFiles, List<File> fileList, List<URL> urlList, FSTreeNode targetFolder) {
        this.parentFolders = Collections.synchronizedMap(new HashMap());
        ArrayList<File> files = new ArrayList<File>();
        String[] stringArray = sourceFiles;
        int n = sourceFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            files.add(new File(path));
            ++n2;
        }
        List<File> topFiles = this.getTopFiles(files);
        for (File topFile : topFiles) {
            this.appendFile(topFile, fileList, urlList, targetFolder);
        }
    }

    private void appendFile(final File file, final List<File> fileList, final List<URL> urlList, final FSTreeNode parent) {
        this.parentFolders.put(file, parent);
        if (file.isFile()) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    URL folderURL = parent.getLocationURL();
                    URL url = new URL(folderURL, file.getName());
                    fileList.add(file);
                    urlList.add(url);
                }

                public void handleException(Throwable exception) {
                }
            });
        } else if (file.isDirectory()) {
            File[] children;
            FSTreeNode node = this.findNode(file);
            if (node == null) {
                OpCreateFolder create = new OpCreateFolder(parent, file.getName());
                new NullOpExecutor().execute(create);
                node = create.getNode();
            }
            File[] fileArray = children = file.listFiles();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                this.appendFile(child, fileList, urlList, node);
                ++n2;
            }
        }
    }

    private List<File> getTopFiles(List<File> files) {
        ArrayList<File> result = new ArrayList<File>();
        for (File file : files) {
            if (this.hasFileAncestor(file, files)) continue;
            result.add(file);
        }
        return result;
    }

    private boolean hasFileAncestor(File target, List<File> files) {
        for (File file : files) {
            if (!this.isFileAncestor(file, target)) continue;
            return true;
        }
        return false;
    }

    private boolean isFileAncestor(File file, File target) {
        if (target == null) {
            return false;
        }
        File parent = target.getParentFile();
        if (file.equals(parent)) {
            return true;
        }
        return this.isFileAncestor(file, parent);
    }

    private FSTreeNode findNode(File file) {
        final FSTreeNode parent = this.parentFolders.get(file);
        if (parent != null) {
            final ArrayList targetChildren = new ArrayList();
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    targetChildren.addAll(OpUpload.this.getChildren(parent));
                }

                public void handleException(Throwable exception) {
                }
            });
            String name = file.getName();
            for (FSTreeNode child : targetChildren) {
                if (!name.equals(child.name)) continue;
                return child;
            }
        }
        return null;
    }

    @Override
    public String getName() {
        String message = this.srcFiles.length == 1 ? NLS.bind((String)Messages.OpUpload_UploadSingleFile, (Object)this.srcFiles[0].getName()) : NLS.bind((String)Messages.OpUpload_UploadNFiles, (Object)this.srcFiles.length);
        return message;
    }

    @Override
    public int getTotalWork() {
        return 100;
    }
}

