/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.operations;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.tcf.filesystem.core.activator.CorePlugin;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.exceptions.TCFException;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.exceptions.TCFFileSystemException;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.Operation;
import org.eclipse.tcf.te.tcf.filesystem.core.model.UserAccount;
import org.eclipse.tcf.te.tcf.filesystem.core.nls.Messages;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;

public class OpUser
extends Operation {
    static final String USER_ACCOUNT_KEY = String.valueOf(CorePlugin.getUniqueIdentifier()) + ".user.account";
    IPeerModel peerNode;
    UserAccount result;

    public OpUser(IPeerModel peerNode) {
        this.peerNode = peerNode;
    }

    public UserAccount getUserAccount() {
        return this.result;
    }

    @Override
    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        if (this.peerNode != null) {
            this.result = this.getUserFromPeer(this.peerNode);
            if (this.result == null) {
                UserAccount[] accounts = new UserAccount[1];
                IChannel channel = null;
                try {
                    try {
                        channel = Operation.openChannel(this.peerNode.getPeer());
                        if (channel != null) {
                            accounts[0] = this.getUserByChannel(channel);
                            if (accounts[0] != null) {
                                this.setUserToPeer(this.peerNode, accounts[0]);
                            }
                        }
                    }
                    catch (TCFException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    if (channel != null) {
                        Tcf.getChannelManager().closeChannel(channel);
                    }
                }
                this.result = accounts[0];
            }
        }
    }

    UserAccount getUserByChannel(IChannel channel) throws TCFFileSystemException {
        IFileSystem service = Operation.getBlockingFileSystem(channel);
        if (service != null) {
            final TCFFileSystemException[] errors = new TCFFileSystemException[1];
            final UserAccount[] accounts = new UserAccount[1];
            service.user(new IFileSystem.DoneUser(){

                public void doneUser(IToken token, IFileSystem.FileSystemException error, int real_uid, int effective_uid, int real_gid, int effective_gid, String home) {
                    if (error == null) {
                        accounts[0] = new UserAccount(real_uid, real_gid, effective_uid, effective_gid, home);
                    } else {
                        errors[0] = OpUser.this.newTCFException(2, error);
                    }
                }
            });
            if (errors[0] != null) {
                throw errors[0];
            }
            return accounts[0];
        }
        String message = NLS.bind((String)Messages.Operation_NoFileSystemError, (Object)channel.getRemotePeer().getID());
        throw new TCFFileSystemException(4, message);
    }

    private UserAccount getUserFromPeer(final IPeerModel peer) {
        Assert.isNotNull((Object)peer);
        if (Protocol.isDispatchThread()) {
            return (UserAccount)peer.getProperty(USER_ACCOUNT_KEY);
        }
        final UserAccount[] accounts = new UserAccount[1];
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                accounts[0] = (UserAccount)peer.getProperty(USER_ACCOUNT_KEY);
            }
        });
        return accounts[0];
    }

    void setUserToPeer(final IPeerModel peer, final UserAccount account) {
        Assert.isNotNull((Object)peer);
        Assert.isNotNull((Object)account);
        if (Protocol.isDispatchThread()) {
            peer.setProperty(USER_ACCOUNT_KEY, (Object)account);
        } else {
            Protocol.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    peer.setProperty(USER_ACCOUNT_KEY, (Object)account);
                }
            });
        }
    }
}

