/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.utils;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.te.tcf.filesystem.core.activator.CorePlugin;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.nls.Messages;

public class CacheManager {
    public static final char PATH_ESCAPE_CHAR = '$';

    public static IPath getCachePath(FSTreeNode node) {
        File location = CacheManager.getCacheRoot();
        String agentId = node.peerNode.getPeerId();
        String agent = agentId.replace(':', '$');
        IPath agentDir = new Path(location.getAbsolutePath()).append(agent);
        File agentDirFile = agentDir.toFile();
        CacheManager.mkdirChecked(agentDirFile);
        return CacheManager.appendNodePath(agentDir, node);
    }

    static void mkdirChecked(final File dir) {
        if (!dir.exists()) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    if (!dir.mkdir()) {
                        throw new Exception(NLS.bind((String)Messages.CacheManager_MkdirFailed, (Object)dir.getAbsolutePath()));
                    }
                }

                public void handleException(Throwable exception) {
                }
            });
        }
    }

    static void deleteFileChecked(final File file) {
        if (file.exists()) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    if (!file.delete()) {
                        throw new Exception(NLS.bind((String)Messages.Operation_DeletingFileFailed, (Object)file.getAbsolutePath()));
                    }
                }

                public void handleException(Throwable exception) {
                }
            });
        }
    }

    static void setReadOnlyChecked(final File file) {
        if (file.exists()) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    if (!file.setReadOnly()) {
                        throw new Exception(NLS.bind((String)Messages.OpStreamOp_SetReadOnlyFailed, (Object)file.getAbsolutePath()));
                    }
                }

                public void handleException(Throwable exception) {
                }
            });
        }
    }

    public static File getCacheFile(FSTreeNode node) {
        return CacheManager.getCachePath(node).toFile();
    }

    public static File getCacheRoot() {
        File location;
        try {
            location = CorePlugin.getDefault().getStateLocation().toFile();
        }
        catch (IllegalStateException illegalStateException) {
            location = new File(System.getProperty("user.home"), ".tcf");
            location = new File(location, "fs");
        }
        CacheManager.mkdirChecked(location);
        return location;
    }

    private static IPath appendNodePath(IPath path, FSTreeNode node) {
        if (!node.isRoot() && node.getParent() != null) {
            path = CacheManager.appendNodePath(path, node.getParent());
            return CacheManager.appendPathSegment(node, path, node.name);
        }
        if (node.isWindowsNode()) {
            String name = node.name;
            name = name.substring(0, name.length() - 1);
            name = name.replace(':', '$');
            return CacheManager.appendPathSegment(node, path, name);
        }
        return path;
    }

    private static IPath appendPathSegment(FSTreeNode node, IPath path, String name) {
        IPath newPath = path.append(name);
        File newFile = newPath.toFile();
        if (node.isDirectory()) {
            CacheManager.mkdirChecked(newFile);
        }
        return newPath;
    }
}

