/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.addons.dndaddon;

import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DnDInfo;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DnDManager;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DropAgent;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class DetachedDropAgent
extends DropAgent {
    DnDManager manager;
    private EModelService modelService;
    private Rectangle curRect;

    public DetachedDropAgent(DnDManager manager) {
        super(manager);
        this.manager = manager;
        this.modelService = manager.getModelService();
    }

    public boolean canDrop(MUIElement dragElement, DnDInfo info) {
        if (info.curElement != null) {
            return false;
        }
        return dragElement instanceof MPart || dragElement instanceof MPlaceholder || dragElement instanceof MPartStack;
    }

    public boolean drop(MUIElement dragElement, DnDInfo info) {
        if (dragElement.getTags().contains("Minimized")) {
            dragElement.getTags().remove("Minimized");
        }
        if (dragElement.getCurSharedRef() != null) {
            dragElement = dragElement.getCurSharedRef();
        }
        this.modelService.detach((MPartSashContainerElement)dragElement, this.curRect.x, this.curRect.y, this.curRect.width, this.curRect.height);
        return true;
    }

    public Rectangle getRectangle(MUIElement dragElement, DnDInfo info) {
        if (dragElement.getCurSharedRef() != null) {
            dragElement = dragElement.getCurSharedRef();
        }
        if (dragElement instanceof MPartStack) {
            Control ctrl = (Control)dragElement.getWidget();
            this.curRect = ctrl.getBounds();
        } else {
            MElementContainer parentME = dragElement.getParent();
            Control ctrl = (Control)parentME.getWidget();
            this.curRect = ctrl.getBounds();
            this.curRect.width += 10;
            this.curRect.height += 22;
        }
        Point cp = Display.getCurrent().getCursorLocation();
        this.curRect.x = cp.x - 15;
        this.curRect.y = cp.y - 15;
        return this.curRect;
    }

    public boolean track(MUIElement dragElement, DnDInfo info) {
        if (info.curElement != null) {
            return false;
        }
        this.manager.frameRect(this.getRectangle(dragElement, info));
        return true;
    }

    public void dragEnter(MUIElement dragElement, DnDInfo info) {
        super.dragEnter(dragElement, info);
        this.dndManager.setCursor(Display.getCurrent().getSystemCursor(21));
    }

    public void dragLeave(MUIElement dragElement, DnDInfo info) {
        this.manager.clearOverlay();
        this.dndManager.setCursor(Display.getCurrent().getSystemCursor(20));
        super.dragLeave(dragElement, info);
    }
}

