/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.core.helpers.CollectionUtils;
import org.eclipse.equinox.internal.p2.ui.ElementQueryDescriptor;
import org.eclipse.equinox.internal.p2.ui.QueryProvider;
import org.eclipse.equinox.internal.p2.ui.model.IUElementListRoot;
import org.eclipse.equinox.internal.p2.ui.model.ProvElement;
import org.eclipse.equinox.internal.p2.ui.query.IUViewQueryContext;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.ui.Policy;
import org.eclipse.equinox.p2.ui.ProvisioningUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QueriedElement
extends ProvElement {
    protected IQueryable<?> queryable;
    private Collection<?> cachedChildren;

    protected QueriedElement(Object parent) {
        super(parent);
    }

    public Policy getPolicy() {
        Object parent = this.getParent(this);
        if (parent instanceof QueriedElement) {
            return ((QueriedElement)parent).getPolicy();
        }
        return this.getProvisioningUI().getPolicy();
    }

    public ProvisioningUI getProvisioningUI() {
        Object parent = this.getParent(this);
        if (parent instanceof QueriedElement) {
            return ((QueriedElement)parent).getProvisioningUI();
        }
        return ProvisioningUI.getDefaultUI();
    }

    public IUViewQueryContext getQueryContext() {
        Object parent = this.getParent(this);
        if (parent instanceof QueriedElement) {
            return ((QueriedElement)parent).getQueryContext();
        }
        return null;
    }

    public Object[] getChildren(Object o) {
        return this.fetchChildren(o, (IProgressMonitor)new NullProgressMonitor());
    }

    public String getLabel(Object o) {
        return null;
    }

    protected abstract int getDefaultQueryType();

    public int getQueryType() {
        return this.getDefaultQueryType();
    }

    protected Object[] fetchChildren(Object o, IProgressMonitor monitor) {
        this.cachedChildren = CollectionUtils.emptyList();
        QueryProvider provider = new QueryProvider(this.getProvisioningUI());
        ElementQueryDescriptor queryDescriptor = provider.getQueryDescriptor(this);
        if (queryDescriptor == null) {
            return new Object[0];
        }
        Collection<?> results = queryDescriptor.performQuery(monitor);
        this.cachedChildren = Collections.unmodifiableCollection(results);
        if (results.size() > 0) {
            HashSet returnedChildren = new HashSet();
            returnedChildren.addAll(results);
            Object[] siblings = this.getSiblings();
            int i = 0;
            while (i < siblings.length) {
                returnedChildren.remove(siblings[i]);
                ++i;
            }
            return returnedChildren.toArray();
        }
        return new Object[0];
    }

    public void setQueryable(IQueryable<?> queryable) {
        this.queryable = queryable;
    }

    public IQueryable<?> getQueryable() {
        return this.queryable;
    }

    public boolean knowsQueryable() {
        return this.queryable != null;
    }

    public boolean hasQueryable() {
        return this.queryable != null;
    }

    public Object[] getCachedChildren() {
        return this.cachedChildren.toArray();
    }

    protected Object[] getSiblings() {
        Object parent = this.getParent(this);
        if (parent instanceof QueriedElement) {
            return ((QueriedElement)parent).getCachedChildren();
        }
        if (parent instanceof IUElementListRoot) {
            return ((IUElementListRoot)parent).getChildren(parent);
        }
        return new Object[0];
    }
}

