/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.model;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.core.commands.Request;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerInputRequestor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerInputUpdate;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.ui.progress.WorkbenchJob;

public class ViewerInputUpdate
extends Request
implements IViewerInputUpdate {
    private IPresentationContext fContext;
    private Object fSource;
    private boolean fDone;
    private Object fInputElement;
    private Object fViewerInput;
    private IViewerInputRequestor fRequestor;
    protected WorkbenchJob fViewerInputUpdateJob = new WorkbenchJob("Asynchronous viewer input update"){

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (ViewerInputUpdate.this.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            ViewerInputUpdate.this.fRequestor.viewerInputComplete(ViewerInputUpdate.this);
            return Status.OK_STATUS;
        }
    };

    public ViewerInputUpdate(IPresentationContext context, Object viewerInput, IViewerInputRequestor requestor, Object source) {
        this.fContext = context;
        this.fSource = source;
        this.fRequestor = requestor;
        this.fViewerInputUpdateJob.setSystem(true);
        this.fViewerInput = viewerInput;
    }

    public IPresentationContext getPresentationContext() {
        return this.fContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void done() {
        ViewerInputUpdate viewerInputUpdate = this;
        synchronized (viewerInputUpdate) {
            if (this.isDone()) {
                return;
            }
            this.fDone = true;
        }
        this.fViewerInputUpdateJob.schedule();
    }

    protected synchronized boolean isDone() {
        return this.fDone;
    }

    public Object getElement() {
        return this.fSource;
    }

    public TreePath getElementPath() {
        return TreePath.EMPTY;
    }

    public void setInputElement(Object element) {
        this.fInputElement = element;
    }

    public Object getInputElement() {
        return this.fInputElement;
    }

    public Object getViewerInput() {
        return this.fViewerInput;
    }
}

