/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.extractfunction;

import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.INodeFactory;
import org.eclipse.cdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTSimpleDeclSpecifier;
import org.eclipse.cdt.internal.ui.refactoring.NameInformation;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.FunctionExtractor;
import org.eclipse.cdt.internal.ui.refactoring.utils.ASTHelper;
import org.eclipse.text.edits.TextEditGroup;

public class StatementExtractor
extends FunctionExtractor {
    @Override
    public boolean canChooseReturnValue() {
        return true;
    }

    @Override
    public void constructMethodBody(IASTCompoundStatement compound, List<IASTNode> nodes, List<NameInformation> parameters, ASTRewrite rewrite, TextEditGroup group) {
        Map<IASTName, NameInformation> changedParameters = StatementExtractor.getChangedParameterReferences(parameters);
        INodeFactory nodeFactory = nodes.get(0).getTranslationUnit().getASTNodeFactory();
        for (IASTNode node : nodes) {
            ASTRewrite subRewrite = rewrite.insertBefore((IASTNode)compound, null, node, group);
            StatementExtractor.adjustParameterReferences(node, changedParameters, nodeFactory, subRewrite, group);
        }
    }

    @Override
    public IASTDeclSpecifier determineReturnType(IASTNode extractedNode, NameInformation returnVariable) {
        if (returnVariable != null) {
            IASTNode decl = ASTHelper.getDeclarationForNode((IASTNode)returnVariable.getDeclarationName());
            IASTDeclSpecifier declSpec = ASTHelper.getDeclarationSpecifier(decl);
            return declSpec != null ? declSpec.copy(IASTNode.CopyStyle.withLocations) : null;
        }
        CPPASTSimpleDeclSpecifier declSpec = new CPPASTSimpleDeclSpecifier();
        declSpec.setType(1);
        return declSpec.copy(IASTNode.CopyStyle.withLocations);
    }

    @Override
    public IASTNode createReturnAssignment(IASTNode node, IASTExpressionStatement stmt, IASTExpression callExpression) {
        stmt.setExpression(callExpression);
        return stmt;
    }
}

