/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.internal.ui.newui.Messages;
import org.eclipse.cdt.internal.ui.wizards.ICDTCommonProjectWizard;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.wizards.CDTMainWizardPage;
import org.eclipse.cdt.ui.wizards.CWizardHandler;
import org.eclipse.cdt.ui.wizards.IWizardWithMemory;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public abstract class CDTCommonProjectWizard
extends BasicNewResourceWizard
implements IExecutableExtension,
IWizardWithMemory,
ICDTCommonProjectWizard {
    private static final String PREFIX = "CProjectWizard";
    private static final String OP_ERROR = "CProjectWizard.op_error";
    private static final String title = CUIPlugin.getResourceString("CProjectWizard.op_error.title");
    private static final String message = CUIPlugin.getResourceString("CProjectWizard.op_error.message");
    private static final String[] EMPTY_ARR = new String[0];
    protected IConfigurationElement fConfigElement;
    protected CDTMainWizardPage fMainPage;
    protected IProject newProject;
    private String wz_title;
    private String wz_desc;
    private boolean existingPath = false;
    private String lastProjectName = null;
    private URI lastProjectLocation = null;
    private CWizardHandler savedHandler = null;
    protected IProgressMonitor continueCreationMonitor;

    public CDTCommonProjectWizard() {
        this(Messages.NewModelProjectWizard_0, Messages.NewModelProjectWizard_1);
    }

    public CDTCommonProjectWizard(String title, String desc) {
        this.setDialogSettings(CUIPlugin.getDefault().getDialogSettings());
        this.setNeedsProgressMonitor(true);
        this.setForcePreviousAndNextButtons(true);
        this.setWindowTitle(title);
        this.wz_title = title;
        this.wz_desc = desc;
    }

    public void addPages() {
        this.fMainPage = new CDTMainWizardPage(CUIPlugin.getResourceString(PREFIX));
        this.fMainPage.setTitle(this.wz_title);
        this.fMainPage.setDescription(this.wz_desc);
        this.addPage((IWizardPage)this.fMainPage);
    }

    private boolean isChanged() {
        if (this.savedHandler != this.fMainPage.h_selected) {
            return true;
        }
        if (!this.fMainPage.getProjectName().equals(this.lastProjectName)) {
            return true;
        }
        URI projectLocation = this.fMainPage.getProjectLocation();
        if (projectLocation == null ? this.lastProjectLocation != null : !projectLocation.equals(this.lastProjectLocation)) {
            return true;
        }
        return this.savedHandler.isChanged();
    }

    @Override
    public IProject getProject(boolean defaults) {
        return this.getProject(defaults, true);
    }

    @Override
    public IProject getProject(boolean defaults, boolean onFinish) {
        if (this.newProject != null && this.isChanged()) {
            this.clearProject();
        }
        if (this.newProject == null) {
            block7: {
                block8: {
                    IFileStore fs;
                    this.existingPath = false;
                    URI p = this.fMainPage.getProjectLocation();
                    if (p == null) {
                        fs = EFS.getStore((URI)ResourcesPlugin.getWorkspace().getRoot().getLocationURI());
                        fs = fs.getChild(this.fMainPage.getProjectName());
                    } else {
                        fs = EFS.getStore((URI)p);
                    }
                    IFileInfo f = fs.fetchInfo();
                    if (!f.exists() || !f.isDirectory()) break block7;
                    if (!fs.getChild(".project").fetchInfo().exists() || MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.CDTCommonProjectWizard_0, (String)Messages.CDTCommonProjectWizard_1)) break block8;
                    return null;
                }
                try {
                    this.existingPath = true;
                }
                catch (CoreException e) {
                    CUIPlugin.log(e.getStatus());
                }
            }
            this.savedHandler = this.fMainPage.h_selected;
            this.savedHandler.saveState();
            this.lastProjectName = this.fMainPage.getProjectName();
            this.lastProjectLocation = this.fMainPage.getProjectLocation();
            this.invokeRunnable(this.getRunnable(defaults, onFinish));
        }
        return this.newProject;
    }

    private void clearProject() {
        if (this.lastProjectName == null) {
            return;
        }
        try {
            ResourcesPlugin.getWorkspace().getRoot().getProject(this.lastProjectName).delete(!this.existingPath, true, null);
        }
        catch (CoreException coreException) {}
        this.newProject = null;
        this.lastProjectName = null;
        this.lastProjectLocation = null;
    }

    private boolean invokeRunnable(IRunnableWithProgress runnable) {
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(runnable);
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            CUIPlugin.errorDialog(this.getShell(), title, message, e.getTargetException(), true);
            this.clearProject();
            return false;
        }
        catch (InterruptedException interruptedException) {
            this.clearProject();
            return false;
        }
        return true;
    }

    public boolean performFinish() {
        boolean needsPost;
        boolean bl = needsPost = this.newProject != null && !this.isChanged();
        if (this.getProject(this.fMainPage.isCurrent(), true) == null) {
            return false;
        }
        this.fMainPage.h_selected.postProcess(this.newProject, needsPost);
        try {
            this.setCreated();
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigElement);
        this.selectAndReveal((IResource)this.newProject);
        return true;
    }

    protected boolean setCreated() throws CoreException {
        ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescription des = mngr.getProjectDescription(this.newProject, false);
        if (des == null) {
            return false;
        }
        if (des.isCdtProjectCreating()) {
            des = mngr.getProjectDescription(this.newProject, true);
            des.setCdtProjectCreated();
            mngr.setProjectDescription(this.newProject, des, false, null);
            return true;
        }
        return false;
    }

    public boolean performCancel() {
        this.clearProject();
        return true;
    }

    @Override
    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.fConfigElement = config;
    }

    private IRunnableWithProgress getRunnable(boolean _defaults, final boolean onFinish) {
        final boolean defaults = _defaults;
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor imonitor) throws InvocationTargetException, InterruptedException {
                final Exception[] except = new Exception[1];
                CDTCommonProjectWizard.this.getShell().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                Object fMonitor = monitor == null ? new NullProgressMonitor() : monitor;
                                fMonitor.beginTask(CUIPlugin.getResourceString("CProjectWizard.op_description"), 100);
                                fMonitor.worked(10);
                                try {
                                    try {
                                        ((this).this).CDTCommonProjectWizard.this.newProject = CDTCommonProjectWizard.this.createIProject(CDTCommonProjectWizard.this.lastProjectName, CDTCommonProjectWizard.this.lastProjectLocation, (IProgressMonitor)new SubProgressMonitor(fMonitor, 40));
                                        if (((this).this).CDTCommonProjectWizard.this.newProject != null) {
                                            ((this).this).CDTCommonProjectWizard.this.fMainPage.h_selected.createProject(((this).this).CDTCommonProjectWizard.this.newProject, defaults, onFinish, (IProgressMonitor)new SubProgressMonitor(fMonitor, 40));
                                        }
                                        fMonitor.worked(10);
                                    }
                                    catch (CoreException e) {
                                        CUIPlugin.log(e);
                                        fMonitor.done();
                                    }
                                }
                                finally {
                                    fMonitor.done();
                                }
                            }
                        });
                        try {
                            CDTCommonProjectWizard.this.getContainer().run(false, true, (IRunnableWithProgress)op);
                        }
                        catch (InvocationTargetException e) {
                            except[0] = e;
                        }
                        catch (InterruptedException e) {
                            except[0] = e;
                        }
                    }
                });
                if (except[0] != null) {
                    if (except[0] instanceof InvocationTargetException) {
                        throw (InvocationTargetException)except[0];
                    }
                    if (except[0] instanceof InterruptedException) {
                        throw (InterruptedException)except[0];
                    }
                    throw new InvocationTargetException(except[0]);
                }
            }
        };
    }

    @Override
    public IProject createIProject(String name, URI location) throws CoreException {
        return this.createIProject(name, location, (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public IProject createIProject(String name, URI location, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(Messages.CDTCommonProjectWizard_creatingProject, 100);
        if (this.newProject != null) {
            return this.newProject;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        final IProject newProjectHandle = root.getProject(name);
        if (!newProjectHandle.exists()) {
            IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
            if (location != null) {
                description.setLocationURI(location);
            }
            this.newProject = CCorePlugin.getDefault().createCDTProject(description, newProjectHandle, (IProgressMonitor)new SubProgressMonitor(monitor, 25));
        } else {
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    newProjectHandle.refreshLocal(2, monitor);
                }
            };
            workspace.run(runnable, (ISchedulingRule)root, 1, (IProgressMonitor)new SubProgressMonitor(monitor, 25));
            this.newProject = newProjectHandle;
        }
        if (!this.newProject.isOpen()) {
            this.newProject.open((IProgressMonitor)new SubProgressMonitor(monitor, 25));
        }
        this.continueCreationMonitor = new SubProgressMonitor(monitor, 25);
        IProject proj = this.continueCreation(this.newProject);
        monitor.done();
        return proj;
    }

    protected abstract IProject continueCreation(IProject var1);

    @Override
    public abstract String[] getNatures();

    public void dispose() {
        this.fMainPage.dispose();
    }

    public boolean canFinish() {
        if (this.fMainPage.h_selected != null) {
            if (!this.fMainPage.h_selected.canFinish()) {
                return false;
            }
            String s = this.fMainPage.h_selected.getErrorMessage();
            if (s != null) {
                return false;
            }
        }
        return super.canFinish();
    }

    @Override
    public String getLastProjectName() {
        return this.lastProjectName;
    }

    @Override
    public URI getLastProjectLocation() {
        return this.lastProjectLocation;
    }

    @Override
    public IProject getLastProject() {
        return this.newProject;
    }

    @Override
    public String[] getLanguageIDs() {
        String[] contentTypeIds = this.getContentTypeIDs();
        if (contentTypeIds.length > 0) {
            IContentTypeManager manager = Platform.getContentTypeManager();
            ArrayList<String> languageIDs = new ArrayList<String>();
            int i = 0;
            while (i < contentTypeIds.length) {
                ILanguage language;
                IContentType contentType = manager.getContentType(contentTypeIds[i]);
                if (contentType != null && !languageIDs.contains((language = LanguageManager.getInstance().getLanguage(contentType)).getId())) {
                    languageIDs.add(language.getId());
                }
                ++i;
            }
            return languageIDs.toArray(new String[languageIDs.size()]);
        }
        return EMPTY_ARR;
    }

    @Override
    public String[] getContentTypeIDs() {
        return EMPTY_ARR;
    }

    @Override
    public String[] getExtensions() {
        String[] contentTypeIds = this.getContentTypeIDs();
        if (contentTypeIds.length > 0) {
            IContentTypeManager manager = Platform.getContentTypeManager();
            ArrayList<String> extensions = new ArrayList<String>();
            int i = 0;
            while (i < contentTypeIds.length) {
                IContentType contentType = manager.getContentType(contentTypeIds[i]);
                if (contentType != null) {
                    String[] thisTypeExtensions = contentType.getFileSpecs(8);
                    extensions.addAll(Arrays.asList(thisTypeExtensions));
                }
                ++i;
            }
            return extensions.toArray(new String[extensions.size()]);
        }
        return EMPTY_ARR;
    }
}

