/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.dialogs;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.ui.activator.UIPlugin;
import org.eclipse.tcf.te.ui.forms.CustomFormToolkit;
import org.eclipse.tcf.te.ui.forms.FormLayoutFactory;
import org.eclipse.tcf.te.ui.forms.parts.AbstractSection;
import org.eclipse.tcf.te.ui.interfaces.data.IDataExchangeNode;
import org.eclipse.tcf.te.ui.jface.dialogs.CustomTitleAreaDialog;
import org.eclipse.tcf.te.ui.jface.interfaces.IValidatingContainer;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.osgi.framework.Bundle;

public abstract class AbstractSectionDialog
extends CustomTitleAreaDialog
implements IValidatingContainer,
IDataExchangeNode {
    private AbstractSection[] sections = null;
    private IPropertiesContainer data = null;
    private final boolean readOnly;
    private final String dialogTitle;
    private final String title;
    private final String message;

    public AbstractSectionDialog(Shell shell, String dialogTitle, String title, String message, boolean readOnly, String contextHelpId) {
        super(shell, contextHelpId);
        this.dialogTitle = dialogTitle;
        this.title = title;
        this.message = message;
        this.readOnly = readOnly;
    }

    protected IDialogSettings doGetDialogSettingsToInitialize() {
        return UIPlugin.getDefault().getDialogSettings();
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return super.getDialogSettings();
    }

    protected boolean isResizable() {
        return true;
    }

    protected abstract AbstractSection[] createSections(IManagedForm var1, Composite var2);

    protected void createDialogAreaContent(Composite parent) {
        AbstractSection section;
        int n;
        int n2;
        AbstractSection[] abstractSectionArray;
        super.createDialogAreaContent(parent);
        this.setDialogTitle(this.dialogTitle);
        this.setTitle(this.title);
        this.setMessage(this.message);
        FormToolkit toolkit = new FormToolkit(this.getShell().getDisplay());
        ScrolledForm scrolledForm = new CustomFormToolkit(toolkit).createScrolledForm(parent, null, true);
        scrolledForm.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        scrolledForm.getBody().setLayout((Layout)FormLayoutFactory.createClearGridLayout((boolean)false, (int)1));
        ManagedForm form = new ManagedForm(toolkit, scrolledForm){

            public void dirtyStateChanged() {
                AbstractSectionDialog.this.validate();
            }

            public void staleStateChanged() {
                AbstractSectionDialog.this.validate();
            }
        };
        this.sections = this.createSections((IManagedForm)form, scrolledForm.getBody());
        if (this.sections != null) {
            abstractSectionArray = this.sections;
            n2 = this.sections.length;
            n = 0;
            while (n < n2) {
                section = abstractSectionArray[n];
                section.setReadOnly(this.readOnly);
                form.addPart((IFormPart)section);
                ++n;
            }
        }
        this.restoreWidgetValues();
        if (this.data != null && this.sections != null) {
            abstractSectionArray = this.sections;
            n2 = this.sections.length;
            n = 0;
            while (n < n2) {
                section = abstractSectionArray[n];
                if (section instanceof IDataExchangeNode) {
                    ((IDataExchangeNode)section).setupData(this.data);
                }
                ++n;
            }
        }
        AbstractSectionDialog.applyDialogFont((Control)scrolledForm.getBody());
    }

    public String getDialogSettingsSectionName() {
        String name = this.getClass().getSimpleName();
        Class<?> enclosing = this.getClass().getEnclosingClass();
        while ((name == null || name.trim().length() == 0) && enclosing != null) {
            name = enclosing.getSimpleName();
            enclosing = enclosing.getEnclosingClass();
        }
        return name != null && name.trim().length() > 0 ? name : "SectionDialog";
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.validate();
        return control;
    }

    protected final Point getInitialSize() {
        return this.adjustInitialSize(super.getInitialSize());
    }

    protected Point adjustInitialSize(Point size) {
        Assert.isNotNull((Object)size);
        return size;
    }

    @Override
    public void setupData(IPropertiesContainer data) {
        Assert.isNotNull((Object)data);
        this.data = new PropertiesContainer();
        this.data.setProperties(data.getProperties());
        if (this.sections != null) {
            AbstractSection[] abstractSectionArray = this.sections;
            int n = this.sections.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractSection section = abstractSectionArray[n2];
                if (section instanceof IDataExchangeNode) {
                    ((IDataExchangeNode)section).setupData(data);
                } else if (Platform.inDebugMode()) {
                    Platform.getLog((Bundle)UIPlugin.getDefault().getBundle()).log((IStatus)new Status(2, UIPlugin.getUniqueIdentifier(), "Section " + section.getClass().getName() + " does not implement IDataExchangeNode!"));
                }
                ++n2;
            }
        }
    }

    @Override
    public void extractData(IPropertiesContainer data) {
        Assert.isNotNull((Object)data);
        data.setProperties(this.data.getProperties());
    }

    protected void okPressed() {
        if (this.data == null) {
            this.data = new PropertiesContainer();
        }
        if (this.sections != null) {
            AbstractSection[] abstractSectionArray = this.sections;
            int n = this.sections.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractSection section = abstractSectionArray[n2];
                if (section instanceof IDataExchangeNode) {
                    ((IDataExchangeNode)section).extractData(this.data);
                } else if (Platform.inDebugMode()) {
                    Platform.getLog((Bundle)UIPlugin.getDefault().getBundle()).log((IStatus)new Status(2, UIPlugin.getUniqueIdentifier(), "Section " + section.getClass().getName() + " does not implement IDataExchangeNode!"));
                }
                ++n2;
            }
        }
        super.okPressed();
    }

    protected void restoreWidgetValues() {
        super.restoreWidgetValues();
        if (this.sections != null) {
            AbstractSection[] abstractSectionArray = this.sections;
            int n = this.sections.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractSection section = abstractSectionArray[n2];
                section.restoreWidgetValues(this.getDialogSettings());
                ++n2;
            }
        }
    }

    protected void saveWidgetValues() {
        super.saveWidgetValues();
        if (this.sections != null) {
            AbstractSection[] abstractSectionArray = this.sections;
            int n = this.sections.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractSection section = abstractSectionArray[n2];
                section.saveWidgetValues(this.getDialogSettings());
                ++n2;
            }
        }
    }

    public void validate() {
        boolean valid = true;
        if (this.sections != null) {
            AbstractSection[] abstractSectionArray = this.sections;
            int n = this.sections.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractSection section = abstractSectionArray[n2];
                valid &= section.isValid();
                this.setMessage(section.getMessage(), section.getMessageType());
                ++n2;
            }
            if (!this.isMessageSet()) {
                this.setMessage(this.message);
            }
        }
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(!this.readOnly && valid);
        }
    }
}

