/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.internal.utils;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tcf.te.ui.interfaces.ISearchMatcher;
import org.eclipse.ui.PlatformUI;

public class SearchMatcher
implements ISearchMatcher {
    private String fSearchTarget;
    private boolean fCaseSensitive;
    private boolean fMatchPrecise;
    private TreeViewer fViewer;

    public SearchMatcher(TreeViewer viewer) {
        this.fViewer = viewer;
    }

    @Override
    public boolean match(Object context) {
        if (context == null) {
            return false;
        }
        String text = this.getElementText(context);
        if (text == null) {
            return false;
        }
        String target = this.fSearchTarget;
        if (!this.fCaseSensitive) {
            text = text.toLowerCase();
            String string = target = this.fSearchTarget != null ? this.fSearchTarget.toLowerCase() : null;
        }
        if (this.fMatchPrecise) {
            return text.equals(target);
        }
        return text.indexOf(target) != -1;
    }

    public String getElementText(final Object element) {
        if (Display.getCurrent() != null) {
            if (element == this.fViewer.getInput()) {
                return null;
            }
            ILabelProvider labelProvider = (ILabelProvider)this.fViewer.getLabelProvider();
            if (labelProvider != null) {
                return labelProvider.getText(element);
            }
            return element == null ? "" : element.toString();
        }
        final String[] result = new String[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                result[0] = SearchMatcher.this.getElementText(element);
            }
        });
        return result[0];
    }

    public void setMatchTarget(String target) {
        this.fSearchTarget = target;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.fCaseSensitive = caseSensitive;
    }

    public void setMatchPrecise(boolean matchPrecise) {
        this.fMatchPrecise = matchPrecise;
    }
}

