/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.di;

import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.IBinding;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.suppliers.ExtendedObjectSupplier;
import org.eclipse.e4.core.di.suppliers.IObjectDescriptor;
import org.eclipse.e4.core.di.suppliers.IRequestor;
import org.eclipse.e4.core.di.suppliers.PrimaryObjectSupplier;
import org.eclipse.e4.core.internal.di.Binding;
import org.eclipse.e4.core.internal.di.ClassRequestor;
import org.eclipse.e4.core.internal.di.ConstructorRequestor;
import org.eclipse.e4.core.internal.di.FieldRequestor;
import org.eclipse.e4.core.internal.di.MethodRequestor;
import org.eclipse.e4.core.internal.di.ObjectDescriptor;
import org.eclipse.e4.core.internal.di.ProviderImpl;
import org.eclipse.e4.core.internal.di.Requestor;
import org.eclipse.e4.core.internal.di.osgi.DIActivator;
import org.eclipse.e4.core.internal.di.osgi.LogHelper;
import org.eclipse.e4.core.internal.di.osgi.ProviderHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectorImpl
implements IInjector {
    private static final String DEBUG_INJECTION = "org.eclipse.e4.core.di/debug/injector";
    private static final boolean shouldDebug = DIActivator.getDefault().getBooleanDebugOption("org.eclipse.e4.core.di/debug/injector", false);
    private static final String JAVA_OBJECT = "java.lang.Object";
    private static final Boolean DEFAULT_BOOLEAN = new Boolean(false);
    private static final Integer DEFAULT_INTEGER = new Integer(0);
    private static final Character DEFAULT_CHAR = new Character('\u0000');
    private static final Float DEFAULT_FLOAT = new Float(0.0f);
    private static final Double DEFAULT_DOUBLE = new Double(0.0);
    private static final Long DEFAULT_LONG = new Long(0L);
    private static final Short DEFAULT_SHORT = new Short(0);
    private static final Byte DEFAULT_BYTE = new Byte(0);
    private Map<PrimaryObjectSupplier, List<WeakReference<?>>> injectedObjects = new HashMap();
    private Set<WeakReference<Class<?>>> injectedClasses = new HashSet();
    private HashMap<Class<?>, Object> singletonCache = new HashMap();
    private Map<Class<?>, Set<Binding>> bindings = new HashMap();
    private Map<Class<?>, Method[]> methodsCache = new WeakHashMap();
    private Map<Class<?>, Map<Method, Boolean>> isOverriddenCache = new WeakHashMap();
    private Set<Class<?>> classesBeingCreated = new HashSet(5);
    private PrimaryObjectSupplier defaultSupplier;

    @Override
    public void inject(Object object, PrimaryObjectSupplier objectSupplier) {
        try {
            this.inject(object, objectSupplier, null);
        }
        catch (NoClassDefFoundError e) {
            throw new InjectionException(e);
        }
        catch (NoSuchMethodError e) {
            throw new InjectionException(e);
        }
    }

    public void inject(Object object, PrimaryObjectSupplier objectSupplier, PrimaryObjectSupplier tempSupplier) {
        ArrayList<Requestor> requestors = new ArrayList<Requestor>();
        this.processClassHierarchy(object, objectSupplier, tempSupplier, true, true, requestors);
        boolean haveLink = false;
        for (Requestor requestor : requestors) {
            if (!requestor.shouldTrack()) continue;
            haveLink = true;
        }
        if (!haveLink) {
            requestors.add(new ClassRequestor(object.getClass(), (IInjector)this, objectSupplier, tempSupplier, object, true));
        }
        this.resolveRequestorArgs(requestors, objectSupplier, tempSupplier, false, true, true);
        for (Requestor requestor : requestors) {
            if (!requestor.isResolved()) continue;
            requestor.execute();
        }
        this.rememberInjectedObject(object, objectSupplier);
        this.processAnnotated(PostConstruct.class, object, object.getClass(), objectSupplier, tempSupplier, new ArrayList(5));
        for (Requestor requestor : requestors) {
            requestor.clearTempSupplier();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rememberInjectedObject(Object object, PrimaryObjectSupplier objectSupplier) {
        Map<PrimaryObjectSupplier, List<WeakReference<?>>> map = this.injectedObjects;
        synchronized (map) {
            List<Object> list;
            if (!this.injectedObjects.containsKey(objectSupplier)) {
                list = new ArrayList();
                this.injectedObjects.put(objectSupplier, list);
            } else {
                list = this.injectedObjects.get(objectSupplier);
            }
            for (WeakReference weakReference : list) {
                if (object != weakReference.get()) continue;
                return;
            }
            list.add(new WeakReference<Object>(object));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean forgetInjectedObject(Object object, PrimaryObjectSupplier objectSupplier) {
        Map<PrimaryObjectSupplier, List<WeakReference<?>>> map = this.injectedObjects;
        synchronized (map) {
            WeakReference<?> ref;
            if (!this.injectedObjects.containsKey(objectSupplier)) {
                return false;
            }
            List<WeakReference<?>> list = this.injectedObjects.get(objectSupplier);
            Iterator<WeakReference<?>> i = list.iterator();
            do {
                if (i.hasNext()) continue;
                return false;
            } while (object != (ref = i.next()).get());
            i.remove();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<WeakReference<?>> forgetSupplier(PrimaryObjectSupplier objectSupplier) {
        Map<PrimaryObjectSupplier, List<WeakReference<?>>> map = this.injectedObjects;
        synchronized (map) {
            block4: {
                if (this.injectedObjects.containsKey(objectSupplier)) break block4;
                return null;
            }
            return this.injectedObjects.remove(objectSupplier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<WeakReference<?>> getSupplierObjects(PrimaryObjectSupplier objectSupplier) {
        Map<PrimaryObjectSupplier, List<WeakReference<?>>> map = this.injectedObjects;
        synchronized (map) {
            block4: {
                if (this.injectedObjects.containsKey(objectSupplier)) break block4;
                return null;
            }
            return this.injectedObjects.get(objectSupplier);
        }
    }

    @Override
    public void uninject(Object object, PrimaryObjectSupplier objectSupplier) {
        try {
            if (!this.forgetInjectedObject(object, objectSupplier)) {
                return;
            }
            this.processAnnotated(PreDestroy.class, object, object.getClass(), objectSupplier, null, new ArrayList(5));
            ArrayList<Requestor> requestors = new ArrayList<Requestor>();
            this.processClassHierarchy(object, objectSupplier, null, true, false, requestors);
            for (Requestor requestor : requestors) {
                Object[] actualArgs = this.resolveArgs(requestor, null, null, true, false, false);
                int unresolved = this.unresolved(actualArgs);
                if (unresolved == -1) {
                    requestor.setResolvedArgs(actualArgs);
                    requestor.execute();
                    continue;
                }
                if (requestor.isOptional()) {
                    requestor.setResolvedArgs(null);
                    continue;
                }
                if (!shouldDebug) continue;
                StringBuffer tmp = new StringBuffer();
                tmp.append("Uninjecting object \"");
                tmp.append(object.toString());
                tmp.append("\": dependency on \"");
                tmp.append(requestor.getDependentObjects()[unresolved].toString());
                tmp.append("\" is not optional.");
                LogHelper.logError(tmp.toString(), null);
            }
        }
        catch (NoClassDefFoundError e) {
            throw new InjectionException(e);
        }
        catch (NoSuchMethodError e) {
            throw new InjectionException(e);
        }
    }

    @Override
    public Object invoke(Object object, Class<? extends Annotation> qualifier, PrimaryObjectSupplier objectSupplier) {
        Object result = this.invokeUsingClass(object, object.getClass(), qualifier, IInjector.NOT_A_VALUE, objectSupplier, null, true);
        if (result == IInjector.NOT_A_VALUE) {
            throw new InjectionException("Unable to find matching method to invoke");
        }
        return result;
    }

    @Override
    public Object invoke(Object object, Class<? extends Annotation> qualifier, Object defaultValue, PrimaryObjectSupplier objectSupplier) {
        return this.invokeUsingClass(object, object.getClass(), qualifier, defaultValue, objectSupplier, null, false);
    }

    @Override
    public Object invoke(Object object, Class<? extends Annotation> qualifier, Object defaultValue, PrimaryObjectSupplier objectSupplier, PrimaryObjectSupplier localSupplier) {
        return this.invokeUsingClass(object, object.getClass(), qualifier, defaultValue, objectSupplier, localSupplier, false);
    }

    private Object invokeUsingClass(Object userObject, Class<?> currentClass, Class<? extends Annotation> qualifier, Object defaultValue, PrimaryObjectSupplier objectSupplier, PrimaryObjectSupplier tempSupplier, boolean throwUnresolved) {
        Method[] methods = this.getDeclaredMethods(currentClass);
        int j = 0;
        while (j < methods.length) {
            Method method = methods[j];
            if (method.getAnnotation(qualifier) != null) {
                MethodRequestor requestor = new MethodRequestor(method, (IInjector)this, objectSupplier, tempSupplier, userObject, false);
                Object[] actualArgs = this.resolveArgs(requestor, objectSupplier, tempSupplier, false, true, false);
                int unresolved = this.unresolved(actualArgs);
                if (unresolved != -1) {
                    if (throwUnresolved) {
                        this.reportUnresolvedArgument(requestor, unresolved);
                    }
                } else {
                    requestor.setResolvedArgs(actualArgs);
                    return requestor.execute();
                }
            }
            ++j;
        }
        Class<?> superClass = currentClass.getSuperclass();
        if (superClass == null) {
            return defaultValue;
        }
        return this.invokeUsingClass(userObject, superClass, qualifier, defaultValue, objectSupplier, tempSupplier, throwUnresolved);
    }

    @Override
    public <T> T make(Class<T> clazz, PrimaryObjectSupplier objectSupplier) {
        Class<?> implementationClass = this.getImplementationClass(clazz);
        return clazz.cast(this.internalMake(implementationClass, objectSupplier, null));
    }

    private Class<?> getImplementationClass(Class<?> clazz) {
        ObjectDescriptor descriptor = new ObjectDescriptor(clazz, null);
        Binding binding = this.findBinding(descriptor);
        if (binding == null) {
            return this.getDesiredClass(descriptor.getDesiredType());
        }
        return binding.getImplementationClass();
    }

    @Override
    public <T> T make(Class<T> clazz, PrimaryObjectSupplier objectSupplier, PrimaryObjectSupplier staticSupplier) {
        Class<?> implementationClass = this.getImplementationClass(clazz);
        return clazz.cast(this.internalMake(implementationClass, objectSupplier, staticSupplier));
    }

    public Object makeFromProvider(IObjectDescriptor descriptor, PrimaryObjectSupplier objectSupplier) {
        Binding binding = this.findBinding(descriptor);
        Class<?> implementationClass = binding == null ? this.getProviderType(descriptor.getDesiredType()) : binding.getImplementationClass();
        if (objectSupplier != null) {
            ObjectDescriptor actualClass = new ObjectDescriptor(implementationClass, null);
            Object[] actualArgs = new Object[]{IInjector.NOT_A_VALUE};
            objectSupplier.get(new IObjectDescriptor[]{actualClass}, actualArgs, null, false, true, false);
            if (actualArgs[0] != IInjector.NOT_A_VALUE) {
                return actualArgs[0];
            }
        }
        return this.internalMake(implementationClass, objectSupplier, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object internalMake(Class<?> clazz, PrimaryObjectSupplier objectSupplier, PrimaryObjectSupplier tempSupplier) {
        if (InjectorImpl.shouldDebug && this.classesBeingCreated.contains(clazz)) {
            LogHelper.logWarning("Possible recursive reference trying to create class \"" + clazz.getName() + "\".", null);
        }
        try {
            if (InjectorImpl.shouldDebug) {
                this.classesBeingCreated.add(clazz);
            }
            if (isSingleton = clazz.isAnnotationPresent(Singleton.class)) {
                var5_7 = this.singletonCache;
                synchronized (var5_7) {
                    if (this.singletonCache.containsKey(clazz)) {
                        var15_8 = this.singletonCache.get(clazz);
                        return var15_8;
                    }
                    ** finally { 
                }
            }
            constructors = clazz.getDeclaredConstructors();
            sortedConstructors = new ArrayList<Constructor>(constructors.length);
            var10_11 = constructors;
            var9_12 = constructors.length;
            var8_13 = 0;
            while (true) {
                if (var8_13 >= var9_12) break;
                constructor = var10_11[var8_13];
                sortedConstructors.add(constructor);
                ++var8_13;
            }
            Collections.sort(sortedConstructors, new Comparator<Constructor<?>>(){

                @Override
                public int compare(Constructor<?> c1, Constructor<?> c2) {
                    int l1 = c1.getParameterTypes().length;
                    int l2 = c2.getParameterTypes().length;
                    return l2 - l1;
                }
            });
            var8_14 = sortedConstructors.iterator();
            while (true) {
                block24: {
                    if (var8_14.hasNext()) break block24;
                    throw new InjectionException("Could not find satisfiable constructor in " + clazz.getName());
                }
                constructor = (Constructor)var8_14.next();
                modifiers = constructor.getModifiers();
                if ((modifiers & 2) != 0 || (modifiers & 4) != 0 || !constructor.isAnnotationPresent(Inject.class) && constructor.getParameterTypes().length != 0 || this.unresolved(actualArgs = this.resolveArgs(requestor = new ConstructorRequestor(constructor, this, objectSupplier, tempSupplier), objectSupplier, tempSupplier, false, true, false)) != -1) continue;
                requestor.setResolvedArgs(actualArgs);
                newInstance = requestor.execute();
                if (newInstance != null) break;
            }
            this.inject(newInstance, objectSupplier, tempSupplier);
            if (isSingleton) {
                var13_18 = this.singletonCache;
                synchronized (var13_18) {
                    this.singletonCache.put(clazz, newInstance);
                }
            }
            var15_9 = newInstance;
            return var15_9;
        }
        catch (NoClassDefFoundError e) {
            throw new InjectionException(e);
        }
        catch (NoSuchMethodError e) {
            throw new InjectionException(e);
        }
        finally {
            if (InjectorImpl.shouldDebug) {
                this.classesBeingCreated.remove(clazz);
            }
        }
    }

    public void resolveArguments(IRequestor requestor, boolean initial) {
        Requestor internalRequestor = (Requestor)requestor;
        Object[] actualArgs = this.resolveArgs(internalRequestor, internalRequestor.getPrimarySupplier(), internalRequestor.getTempSupplier(), false, initial, internalRequestor.shouldTrack());
        int unresolved = this.unresolved(actualArgs);
        if (unresolved == -1) {
            internalRequestor.setResolvedArgs(actualArgs);
        } else if (internalRequestor.isOptional()) {
            internalRequestor.setResolvedArgs(null);
        } else {
            String msg = this.resolutionError(internalRequestor, unresolved);
            LogHelper.logError(msg, null);
        }
    }

    public void disposed(PrimaryObjectSupplier objectSupplier) {
        List<WeakReference<?>> references = this.getSupplierObjects(objectSupplier);
        if (references == null) {
            return;
        }
        Object[] objects = new Object[references.size()];
        int count = 0;
        for (WeakReference<?> ref : references) {
            Object object = ref.get();
            if (object == null) continue;
            objects[count] = object;
            ++count;
        }
        int i = 0;
        while (i < count) {
            Object object = objects[i];
            if (this.forgetInjectedObject(object, objectSupplier)) {
                this.processAnnotated(PreDestroy.class, object, object.getClass(), objectSupplier, null, new ArrayList(5));
            }
            ++i;
        }
        this.forgetSupplier(objectSupplier);
    }

    private void resolveRequestorArgs(ArrayList<Requestor> requestors, PrimaryObjectSupplier objectSupplier, PrimaryObjectSupplier tempSupplier, boolean uninject, boolean initial, boolean track) {
        for (Requestor requestor : requestors) {
            Object[] actualArgs = this.resolveArgs(requestor, objectSupplier, tempSupplier, uninject, initial, track);
            int unresolved = this.unresolved(actualArgs);
            if (unresolved == -1) {
                requestor.setResolvedArgs(actualArgs);
                continue;
            }
            if (requestor.isOptional()) {
                requestor.setResolvedArgs(null);
                continue;
            }
            this.reportUnresolvedArgument(requestor, unresolved);
        }
    }

    private void reportUnresolvedArgument(Requestor requestor, int argIndex) {
        String msg = this.resolutionError(requestor, argIndex);
        if (shouldDebug) {
            LogHelper.logError(msg, null);
        }
        throw new InjectionException(msg);
    }

    private String resolutionError(Requestor requestor, int argIndex) {
        StringBuffer tmp = new StringBuffer();
        tmp.append("Unable to process \"");
        tmp.append(requestor.toString());
        tmp.append("\": no actual value was found for the argument \"");
        tmp.append(requestor.getDependentObjects()[argIndex].toString());
        tmp.append("\".");
        return tmp.toString();
    }

    private Object[] resolveArgs(Requestor requestor, PrimaryObjectSupplier objectSupplier, PrimaryObjectSupplier tempSupplier, boolean uninject, boolean initial, boolean track) {
        IObjectDescriptor[] descriptors = requestor.getDependentObjects();
        Object[] actualArgs = new Object[descriptors.length];
        Arrays.fill(actualArgs, NOT_A_VALUE);
        int i = 0;
        while (i < actualArgs.length) {
            Class<?> providerClass = this.getProviderType(descriptors[i].getDesiredType());
            if (providerClass != null) {
                actualArgs[i] = new ProviderImpl(descriptors[i], this, objectSupplier);
            }
            ++i;
        }
        if (tempSupplier != null) {
            tempSupplier.get(descriptors, actualArgs, requestor, initial, false, requestor.shouldGroupUpdates());
        }
        if (objectSupplier != null) {
            objectSupplier.get(descriptors, actualArgs, requestor, initial, requestor.shouldTrack() && track, requestor.shouldGroupUpdates());
        }
        i = 0;
        while (i < actualArgs.length) {
            ExtendedObjectSupplier extendedSupplier;
            if (actualArgs[i] == NOT_A_VALUE && (extendedSupplier = this.findExtendedSupplier(descriptors[i], objectSupplier)) != null) {
                actualArgs[i] = extendedSupplier.get(descriptors[i], requestor, requestor.shouldTrack() && track, requestor.shouldGroupUpdates());
            }
            ++i;
        }
        i = 0;
        while (i < actualArgs.length) {
            Binding binding;
            if (actualArgs[i] == NOT_A_VALUE && (binding = this.findBinding(descriptors[i])) != null) {
                actualArgs[i] = this.internalMake(binding.getImplementationClass(), objectSupplier, tempSupplier);
            }
            ++i;
        }
        if (!uninject && !requestor.isOptional()) {
            i = 0;
            while (i < actualArgs.length) {
                if (actualArgs[i] == NOT_A_VALUE && !descriptors[i].hasQualifier(Optional.class)) {
                    try {
                        Class<?> desiredClass = this.getDesiredClass(descriptors[i].getDesiredType());
                        Creatable creatableAnnotation = desiredClass.getAnnotation(Creatable.class);
                        if (creatableAnnotation != null) {
                            actualArgs[i] = this.internalMake(this.getDesiredClass(descriptors[i].getDesiredType()), objectSupplier, tempSupplier);
                        }
                    }
                    catch (InjectionException injectionException) {}
                }
                ++i;
            }
        }
        i = 0;
        while (i < descriptors.length) {
            Class<Object> descriptorsClass;
            if (actualArgs[i] != null && actualArgs[i] != IInjector.NOT_A_VALUE) {
                descriptorsClass = this.getDesiredClass(descriptors[i].getDesiredType());
                if (descriptorsClass.isPrimitive()) {
                    if (descriptorsClass.equals(Boolean.TYPE)) {
                        descriptorsClass = Boolean.class;
                    } else if (descriptorsClass.equals(Integer.TYPE)) {
                        descriptorsClass = Integer.class;
                    } else if (descriptorsClass.equals(Character.TYPE)) {
                        descriptorsClass = Character.class;
                    } else if (descriptorsClass.equals(Float.TYPE)) {
                        descriptorsClass = Float.class;
                    } else if (descriptorsClass.equals(Double.TYPE)) {
                        descriptorsClass = Double.class;
                    } else if (descriptorsClass.equals(Long.TYPE)) {
                        descriptorsClass = Long.class;
                    } else if (descriptorsClass.equals(Short.TYPE)) {
                        descriptorsClass = Short.class;
                    } else if (descriptorsClass.equals(Byte.TYPE)) {
                        descriptorsClass = Byte.class;
                    }
                }
                if (!descriptorsClass.isAssignableFrom(actualArgs[i].getClass())) {
                    actualArgs[i] = IInjector.NOT_A_VALUE;
                }
            }
            if (actualArgs[i] == IInjector.NOT_A_VALUE && descriptors[i].hasQualifier(Optional.class)) {
                descriptorsClass = this.getDesiredClass(descriptors[i].getDesiredType());
                if (descriptorsClass.isPrimitive()) {
                    if (descriptorsClass.equals(Boolean.TYPE)) {
                        actualArgs[i] = DEFAULT_BOOLEAN;
                    } else if (descriptorsClass.equals(Integer.TYPE)) {
                        actualArgs[i] = DEFAULT_INTEGER;
                    } else if (descriptorsClass.equals(Character.TYPE)) {
                        actualArgs[i] = DEFAULT_CHAR;
                    } else if (descriptorsClass.equals(Float.TYPE)) {
                        actualArgs[i] = DEFAULT_FLOAT;
                    } else if (descriptorsClass.equals(Double.TYPE)) {
                        actualArgs[i] = DEFAULT_DOUBLE;
                    } else if (descriptorsClass.equals(Long.TYPE)) {
                        actualArgs[i] = DEFAULT_LONG;
                    } else if (descriptorsClass.equals(Short.TYPE)) {
                        actualArgs[i] = DEFAULT_SHORT;
                    } else if (descriptorsClass.equals(Byte.TYPE)) {
                        actualArgs[i] = DEFAULT_BYTE;
                    }
                } else {
                    actualArgs[i] = null;
                }
            }
            ++i;
        }
        return actualArgs;
    }

    private ExtendedObjectSupplier findExtendedSupplier(IObjectDescriptor descriptor, PrimaryObjectSupplier objectSupplier) {
        Annotation[] qualifiers = descriptor.getQualifiers();
        if (qualifiers == null) {
            return null;
        }
        Annotation[] annotationArray = qualifiers;
        int n = qualifiers.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation qualifier = annotationArray[n2];
            Class<? extends Annotation> type = qualifier.annotationType();
            if (type instanceof Class) {
                ExtendedObjectSupplier supplier;
                String key = type.getName();
                try {
                    supplier = ProviderHelper.findProvider(key, this.defaultSupplier);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    return null;
                }
                if (supplier != null) {
                    return supplier;
                }
            }
            ++n2;
        }
        return null;
    }

    private int unresolved(Object[] actualArgs) {
        int i = 0;
        while (i < actualArgs.length) {
            if (actualArgs[i] == IInjector.NOT_A_VALUE) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void processClassHierarchy(Object userObject, PrimaryObjectSupplier objectSupplier, PrimaryObjectSupplier tempSupplier, boolean track, boolean normalOrder, List<Requestor> requestors) {
        this.processClass(userObject, objectSupplier, tempSupplier, userObject == null ? null : userObject.getClass(), new ArrayList(5), track, normalOrder, requestors);
    }

    private void processClass(Object userObject, PrimaryObjectSupplier objectSupplier, PrimaryObjectSupplier tempSupplier, Class<?> objectsClass, ArrayList<Class<?>> classHierarchy, boolean track, boolean normalOrder, List<Requestor> requestors) {
        boolean injectedStaticMethods;
        boolean injectedStaticFields;
        Class<?> superClass;
        if (objectsClass != null && (superClass = objectsClass.getSuperclass()) != null && !superClass.getName().equals(JAVA_OBJECT)) {
            classHierarchy.add(objectsClass);
            this.processClass(userObject, objectSupplier, tempSupplier, superClass, classHierarchy, track, normalOrder, requestors);
            classHierarchy.remove(objectsClass);
        }
        if (normalOrder) {
            injectedStaticFields = this.processFields(userObject, objectSupplier, tempSupplier, objectsClass, track, requestors);
            injectedStaticMethods = this.processMethods(userObject, objectSupplier, tempSupplier, objectsClass, classHierarchy, track, requestors);
        } else {
            injectedStaticMethods = this.processMethods(userObject, objectSupplier, tempSupplier, objectsClass, classHierarchy, track, requestors);
            injectedStaticFields = this.processFields(userObject, objectSupplier, tempSupplier, objectsClass, track, requestors);
        }
        if (injectedStaticFields || injectedStaticMethods) {
            this.rememberInjectedStatic(objectsClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasInjectedStatic(Class<?> objectsClass) {
        Set<WeakReference<Class<?>>> set = this.injectedClasses;
        synchronized (set) {
            WeakReference<Class<?>> ref;
            Class injectedClass;
            Iterator<WeakReference<Class<?>>> iterator = this.injectedClasses.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while ((injectedClass = (Class)(ref = iterator.next()).get()) == null || injectedClass != objectsClass);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rememberInjectedStatic(Class<?> objectsClass) {
        Set<WeakReference<Class<?>>> set = this.injectedClasses;
        synchronized (set) {
            this.injectedClasses.add(new WeakReference(objectsClass));
        }
    }

    private boolean processFields(Object userObject, PrimaryObjectSupplier objectSupplier, PrimaryObjectSupplier tempSupplier, Class<?> objectsClass, boolean track, List<Requestor> requestors) {
        boolean injectedStatic = false;
        Field[] fields = objectsClass.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            block6: {
                Field field;
                block5: {
                    field = fields[i];
                    if (!Modifier.isStatic(field.getModifiers())) break block5;
                    if (this.hasInjectedStatic(objectsClass)) break block6;
                    injectedStatic = true;
                }
                if (field.isAnnotationPresent(Inject.class)) {
                    requestors.add(new FieldRequestor(field, (IInjector)this, objectSupplier, tempSupplier, userObject, track));
                }
            }
            ++i;
        }
        return injectedStatic;
    }

    private boolean processMethods(Object userObject, PrimaryObjectSupplier objectSupplier, PrimaryObjectSupplier tempSupplier, Class<?> objectsClass, ArrayList<Class<?>> classHierarchy, boolean track, List<Requestor> requestors) {
        boolean injectedStatic = false;
        Method[] methods = this.getDeclaredMethods(objectsClass);
        int i = 0;
        while (i < methods.length) {
            block8: {
                Method method;
                block9: {
                    method = methods[i];
                    Boolean isOverridden = null;
                    Map<Method, Boolean> methodMap = null;
                    Class<?> originalClass = userObject.getClass();
                    if (this.isOverriddenCache.containsKey(originalClass) && (methodMap = this.isOverriddenCache.get(originalClass)).containsKey(method)) {
                        isOverridden = methodMap.get(method);
                    }
                    if (isOverridden == null) {
                        isOverridden = this.isOverridden(method, classHierarchy);
                        if (methodMap == null) {
                            methodMap = new WeakHashMap<Method, Boolean>();
                            this.isOverriddenCache.put(originalClass, methodMap);
                        }
                        methodMap.put(method, isOverridden);
                    }
                    if (isOverridden.booleanValue()) break block8;
                    if (!Modifier.isStatic(method.getModifiers())) break block9;
                    if (this.hasInjectedStatic(objectsClass)) break block8;
                    injectedStatic = true;
                }
                if (method.isAnnotationPresent(Inject.class)) {
                    requestors.add(new MethodRequestor(method, (IInjector)this, objectSupplier, tempSupplier, userObject, track));
                }
            }
            ++i;
        }
        return injectedStatic;
    }

    private boolean isOverridden(Method method, ArrayList<Class<?>> classHierarchy) {
        int modifiers = method.getModifiers();
        if (Modifier.isPrivate(modifiers)) {
            return false;
        }
        if (Modifier.isStatic(modifiers)) {
            return false;
        }
        boolean isDefault = !Modifier.isPublic(modifiers) && !Modifier.isProtected(modifiers);
        String methodName = method.getName();
        Class<?>[] methodParams = method.getParameterTypes();
        int methodParamsLength = method.getParameterTypes().length;
        for (Class<?> subClass : classHierarchy) {
            Method[] methods = this.getDeclaredMethods(subClass);
            Method matchingMethod = null;
            Method[] methodArray = methods;
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?>[] candidateParams;
                Method candidate = methodArray[n2];
                if (methodName.equals(candidate.getName()) && (candidateParams = candidate.getParameterTypes()).length == methodParamsLength) {
                    boolean paramsMatch = true;
                    int i = 0;
                    while (i < methodParamsLength) {
                        if (!candidateParams[i].equals(methodParams[i])) {
                            paramsMatch = false;
                        }
                        ++i;
                    }
                    if (paramsMatch) {
                        matchingMethod = candidate;
                        break;
                    }
                }
                ++n2;
            }
            if (matchingMethod == null) continue;
            if (isDefault) {
                Package originalPackage = method.getDeclaringClass().getPackage();
                Package overridePackage = subClass.getPackage();
                if (originalPackage == null && overridePackage == null) {
                    return true;
                }
                if (originalPackage == null || overridePackage == null) {
                    return false;
                }
                if (!originalPackage.equals(overridePackage)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private Method[] getDeclaredMethods(Class<?> c) {
        Method[] methods = this.methodsCache.get(c);
        if (methods == null) {
            methods = c.getDeclaredMethods();
            this.methodsCache.put(c, methods);
        }
        return methods;
    }

    private Class<?> getDesiredClass(Type desiredType) {
        Type rawType;
        if (desiredType instanceof Class) {
            return (Class)desiredType;
        }
        if (desiredType instanceof ParameterizedType && (rawType = ((ParameterizedType)desiredType).getRawType()) instanceof Class) {
            return (Class)rawType;
        }
        return null;
    }

    private Class<?> getProviderType(Type type) {
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        Type rawType = ((ParameterizedType)type).getRawType();
        if (!Provider.class.equals((Object)rawType)) {
            return null;
        }
        Type[] actualTypes = ((ParameterizedType)type).getActualTypeArguments();
        if (actualTypes.length != 1) {
            return null;
        }
        if (!(actualTypes[0] instanceof Class)) {
            return null;
        }
        return (Class)actualTypes[0];
    }

    @Override
    public IBinding addBinding(Class<?> clazz) {
        return this.addBinding(new Binding(clazz, this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBinding addBinding(IBinding binding) {
        Binding internalBinding = (Binding)binding;
        Class<?> clazz = internalBinding.getDescribedClass();
        Map<Class<?>, Set<Binding>> map = this.bindings;
        synchronized (map) {
            if (this.bindings.containsKey(clazz)) {
                Set<Binding> collection = this.bindings.get(clazz);
                String desiredQualifierName = internalBinding.getQualifierName();
                Iterator<Binding> i = collection.iterator();
                while (i.hasNext()) {
                    Binding collectionBinding = i.next();
                    if (!this.eq(collectionBinding.getQualifierName(), desiredQualifierName)) continue;
                    i.remove();
                    break;
                }
                collection.add(internalBinding);
            } else {
                HashSet<Binding> collection = new HashSet<Binding>(1);
                collection.add(internalBinding);
                this.bindings.put(clazz, collection);
            }
        }
        return binding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Binding findBinding(IObjectDescriptor descriptor) {
        Class<?> desiredClass = this.getProviderType(descriptor.getDesiredType());
        if (desiredClass == null) {
            desiredClass = this.getDesiredClass(descriptor.getDesiredType());
        }
        Map<Class<?>, Set<Binding>> map = this.bindings;
        synchronized (map) {
            block11: {
                if (this.bindings.containsKey(desiredClass)) break block11;
                return null;
            }
            Set<Binding> collection = this.bindings.get(desiredClass);
            String desiredQualifierName = null;
            if (descriptor.hasQualifier(Named.class)) {
                Named namedAnnotation = descriptor.getQualifier(Named.class);
                desiredQualifierName = namedAnnotation.value();
            } else {
                Annotation[] annotations = descriptor.getQualifiers();
                if (annotations != null) {
                    Annotation[] annotationArray = annotations;
                    if (annotations.length != 0) {
                        Annotation annotation = annotationArray[0];
                        desiredQualifierName = annotation.annotationType().getName();
                    }
                }
            }
            for (Binding collectionBinding : collection) {
                if (!this.eq(collectionBinding.getQualifierName(), desiredQualifierName)) continue;
                return collectionBinding;
            }
            desiredQualifierName = desiredClass.getName();
            for (Binding collectionBinding : collection) {
                String simpleClassName;
                Class<?> bindingClass = collectionBinding.getDescribedClass();
                if (bindingClass == null || !this.eq(simpleClassName = bindingClass.getName(), desiredQualifierName)) continue;
                return collectionBinding;
            }
        }
        return null;
    }

    private boolean eq(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return true;
        }
        if (str1 == null || str2 == null) {
            return false;
        }
        return str1.equals(str2);
    }

    private void processAnnotated(Class<? extends Annotation> annotation, Object userObject, Class<?> objectClass, PrimaryObjectSupplier objectSupplier, PrimaryObjectSupplier tempSupplier, ArrayList<Class<?>> classHierarchy) {
        Class<?> superClass = objectClass.getSuperclass();
        if (superClass != null && !superClass.getName().equals(JAVA_OBJECT)) {
            classHierarchy.add(objectClass);
            this.processAnnotated(annotation, userObject, superClass, objectSupplier, tempSupplier, classHierarchy);
            classHierarchy.remove(objectClass);
        }
        Method[] methods = this.getDeclaredMethods(objectClass);
        int i = 0;
        while (i < methods.length) {
            block5: {
                Object[] actualArgs;
                MethodRequestor requestor;
                block6: {
                    Method method = methods[i];
                    if (!method.isAnnotationPresent(annotation) || this.isOverridden(method, classHierarchy)) break block5;
                    requestor = new MethodRequestor(method, (IInjector)this, objectSupplier, tempSupplier, userObject, false);
                    actualArgs = this.resolveArgs(requestor, objectSupplier, tempSupplier, false, false, false);
                    int unresolved = this.unresolved(actualArgs);
                    if (unresolved == -1) break block6;
                    if (method.isAnnotationPresent(Optional.class)) break block5;
                    this.reportUnresolvedArgument(requestor, unresolved);
                }
                requestor.setResolvedArgs(actualArgs);
                requestor.execute();
            }
            ++i;
        }
    }

    @Override
    public void setDefaultSupplier(PrimaryObjectSupplier objectSupplier) {
        this.defaultSupplier = objectSupplier;
    }
}

